/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.map.impl;

import java.util.HashMap;
import org.drools.persistence.jta.JtaTransactionManager;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.manager.DefaultCacheManager;
import org.jbpm.persistence.map.impl.MapPersistenceTest;
import org.jbpm.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class InfinispanBasedPersistenceTest
extends MapPersistenceTest {
    private HashMap<String, Object> context;
    private DefaultCacheManager cm;
    private JtaTransactionManager txm;
    private boolean useTransactions = false;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.useTransactions = false;
        Environment env = PersistenceUtil.createEnvironment(this.context);
        Object tm = env.get("org.kie.transaction.TransactionManager");
        this.txm = new JtaTransactionManager(env.get("org.kie.transaction.Transaction"), env.get("org.kie.transaction.TransactionSynchronizationRegistry"), tm);
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    protected StatefulKnowledgeSession createSession(KieBase kbase) {
        return InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    protected StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, long ksessionId, KieBase kbase) {
        ksession.dispose();
        return InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)ksessionId, (KieBase)kbase, null, (Environment)PersistenceUtil.createEnvironment(this.context));
    }

    protected int getProcessInstancesCount() {
        boolean txOwner = false;
        if (this.useTransactions) {
            txOwner = this.txm.begin();
        }
        Cache cache = this.cm.getCache("jbpm-configured-cache");
        CacheSet keyset = cache.keySet();
        int size = 0;
        for (String key : keyset) {
            if (!key.startsWith("processInstanceInfo")) continue;
            ++size;
        }
        if (this.useTransactions) {
            this.txm.commit(txOwner);
        }
        return size;
    }

    protected int getKnowledgeSessionsCount() {
        boolean txOwner = false;
        if (this.useTransactions) {
            txOwner = this.txm.begin();
        }
        Cache cache = this.cm.getCache("jbpm-configured-cache");
        CacheSet keyset = cache.keySet();
        int size = 0;
        for (String key : keyset) {
            if (!key.startsWith("sessionInfo")) continue;
            ++size;
        }
        if (this.useTransactions) {
            this.txm.commit(txOwner);
        }
        return size;
    }
}

