/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.util.HashMap;
import javax.transaction.UserTransaction;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.infinispan.marshaller.InfinispanPlaceholderResolverStrategy;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.jbpm.persistence.processinstance.objects.NonSerializableClass;
import org.jbpm.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceResolverStrategyTest {
    private static Logger logger = LoggerFactory.getLogger(ProcessInstanceResolverStrategyTest.class);
    private HashMap<String, Object> context;
    private StatefulKnowledgeSession ksession;
    private static final String RF_FILE = "SimpleProcess.rf";
    private static final String PROCESS_ID = "org.jbpm.persistence.TestProcess";
    private static final String VAR_NAME = "persistVar";

    @Before
    public void before() {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa", false);
        Environment env = PersistenceUtil.createEnvironment(this.context);
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new ProcessInstanceResolverStrategy(), new InfinispanPlaceholderResolverStrategy(env), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieBase kbase = this.loadKnowledgeBase();
        this.ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        Assert.assertTrue((String)"Valid KnowledgeSession could not be created.", (this.ksession != null && this.ksession.getIdentifier() > 0L ? 1 : 0) != 0);
    }

    private KieBase loadKnowledgeBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource(RF_FILE), ResourceType.DRF);
        KieBase kbase = kbuilder.newKieBase();
        return kbase;
    }

    @After
    public void after() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testWithDatabaseAndStartProcess() throws Exception {
        HashMap<String, NonSerializableClass> params = new HashMap<String, NonSerializableClass>();
        NonSerializableClass processVar = new NonSerializableClass();
        processVar.setString("1234567890");
        params.put(VAR_NAME, processVar);
        params.put("logger", (NonSerializableClass)logger);
        DefaultCacheManager cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        Cache cache = cm.getCache("jbpm-configured-cache");
        UserTransaction ut = (UserTransaction)cache.getAdvancedCache().getTransactionManager();
        ut.begin();
        processVar.setId("nonSerializable1");
        cache.put((Object)"nonSerializable1", (Object)processVar);
        ut.commit();
        ProcessInstance processInstance = this.ksession.startProcess(PROCESS_ID, params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        processVar = (NonSerializableClass)((WorkflowProcessInstance)processInstance).getVariable(VAR_NAME);
        Assert.assertNotNull((Object)processVar);
    }

    @Test
    public void testWithDatabaseAndStartProcessInstance() throws Exception {
        HashMap<String, NonSerializableClass> params = new HashMap<String, NonSerializableClass>();
        NonSerializableClass processVar = new NonSerializableClass();
        processVar.setString("1234567890");
        params.put(VAR_NAME, processVar);
        DefaultCacheManager cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        Cache cache = cm.getCache("jbpm-configured-cache");
        UserTransaction ut = (UserTransaction)cache.getAdvancedCache().getTransactionManager();
        ut.begin();
        processVar.setId("nonSerializable2");
        cache.put((Object)"nonSerializable2", (Object)processVar);
        ut.commit();
        ProcessInstance processInstance = this.ksession.createProcessInstance(PROCESS_ID, params);
        long processInstanceId = processInstance.getId();
        Assert.assertTrue((processInstanceId > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)processInstance.getState());
        ut.begin();
        this.ksession.insert((Object)processInstance);
        this.ksession.startProcessInstance(processInstanceId);
        this.ksession.fireAllRules();
        ut.commit();
        processInstance = this.ksession.getProcessInstance(processInstanceId);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        processVar = (NonSerializableClass)((WorkflowProcessInstance)processInstance).getVariable(VAR_NAME);
        Assert.assertNotNull((Object)processVar);
    }
}

