/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.mail.extension.MailExtension;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class MailSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    MailSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{MailExtension.SUBSYSTEM_PATH});
        list.add(Util.createAddOperation((PathAddress)address));
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: 
                case MAIL_1_1: 
                case MAIL_1_2: {
                    String element;
                    switch (element = reader.getLocalName()) {
                        case "mail-session": {
                            this.parseMailSession(reader, list, address);
                            continue block9;
                        }
                    }
                    reader.handleAny(list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMailSession(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parent) throws XMLStreamException {
        String jndiName = null;
        ModelNode operation = new ModelNode();
        block25: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (attr) {
                case "jndi-name": {
                    jndiName = value;
                    MailSessionDefinition.JNDI_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block25;
                }
                case "debug": {
                    MailSessionDefinition.DEBUG.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block25;
                }
                case "from": {
                    MailSessionDefinition.FROM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                }
            }
        }
        if (jndiName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(MailSessionDefinition.JNDI_NAME));
        }
        PathAddress address = parent.append("mail-session", jndiName);
        operation.get("address").set(address.toModelNode());
        operation.get("operation").set("add");
        list.add(operation);
        block26: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case MAIL_1_0: 
                case MAIL_1_1: 
                case MAIL_1_2: {
                    String element;
                    switch (element = reader.getLocalName()) {
                        case "smtp-server": {
                            this.parseServerConfig(reader, "smtp", address, list);
                            continue block26;
                        }
                        case "pop3-server": {
                            this.parseServerConfig(reader, "pop3", address, list);
                            continue block26;
                        }
                        case "imap-server": {
                            this.parseServerConfig(reader, "imap", address, list);
                            continue block26;
                        }
                        case "custom-server": {
                            this.parseCustomServerConfig(reader, address, list);
                            continue block26;
                        }
                    }
                    reader.handleAny(list);
                    continue block26;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerConfig(XMLExtendedStreamReader reader, String name, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = parent.append("server", name);
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        list.add(operation);
        String socketBindingRef = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (attr) {
                case "outbound-socket-binding-ref": {
                    socketBindingRef = value;
                    MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case "ssl": {
                    MailServerDefinition.SSL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case "tls": {
                    MailServerDefinition.TLS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (socketBindingRef == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF));
        }
        this.parseLogin(reader, operation);
    }

    private void parseCustomServerConfig(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation((PathAddress)parent);
        list.add(operation);
        String name = null;
        block20: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (attr) {
                case "outbound-socket-binding-ref": {
                    MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF_OPTIONAL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block20;
                }
                case "ssl": {
                    MailServerDefinition.SSL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block20;
                }
                case "tls": {
                    MailServerDefinition.TLS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block20;
                }
                case "name": {
                    name = value;
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            String element;
            switch (element = reader.getLocalName()) {
                case "login": {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String att = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (att.equals("username")) {
                            MailServerDefinition.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            continue;
                        }
                        if (!att.equals("password")) continue;
                        MailServerDefinition.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block21;
                }
                case "property": {
                    String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
                    MailServerDefinition.PROPERTIES.parseAndAddParameterElement(array[0], array[1], operation, reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block21;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        PathAddress address = parent.append("custom", name);
        operation.get("address").set(address.toModelNode());
    }

    private void parseLogin(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String element;
            switch (element = reader.getLocalName()) {
                case "login": {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String att = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (att.equals("username")) {
                            MailServerDefinition.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            continue;
                        }
                        if (!att.equals("password")) continue;
                        MailServerDefinition.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                }
            }
        }
    }
}

