/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.jboss.classfilewriter.ClassFile;
import sun.misc.Unsafe;

public class ClassFileUtils {
    private static Method defineClass1;
    private static Method defineClass2;

    private ClassFileUtils() {
    }

    public static Class<?> toClass(ClassFile ct, ClassLoader loader, ProtectionDomain domain) {
        try {
            Object[] args;
            Method method;
            byte[] b = ct.toBytecode();
            if (domain == null) {
                method = defineClass1;
                args = new Object[]{ct.getName(), b, 0, b.length};
            } else {
                method = defineClass2;
                args = new Object[]{ct.getName(), b, 0, b.length, domain};
            }
            return ClassFileUtils.toClass2(method, loader, args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized Class<?> toClass2(Method method, ClassLoader loader, Object[] args) throws Exception {
        Class clazz = (Class)Class.class.cast(method.invoke((Object)loader, args));
        return clazz;
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Class<?> cl = Class.forName("java.lang.ClassLoader");
                    String name = "defineClass";
                    Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
                    singleoneInstanceField.setAccessible(true);
                    Unsafe theUnsafe = (Unsafe)singleoneInstanceField.get(null);
                    long overrideOffset = theUnsafe.objectFieldOffset(AccessibleObject.class.getDeclaredField("override"));
                    defineClass1 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    defineClass2 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    theUnsafe.putBoolean(defineClass1, overrideOffset, true);
                    theUnsafe.putBoolean(defineClass2, overrideOffset, true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("cannot initialize ClassPool", pae.getException());
        }
    }
}

