/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v53.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.InvocationAfterCompletion;
import org.infinispan.hibernate.cache.v53.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.v53.impl.BaseRegionImpl;
import org.infinispan.transaction.TransactionMode;

public final class QueryResultsRegionImpl
extends BaseRegionImpl
implements QueryResultsRegion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(QueryResultsRegionImpl.class);
    private static final SessionAccess SESSION_ACCESS = SessionAccess.findSessionAccess();
    private final AdvancedCache putCache;
    private final AdvancedCache getCache;
    private final ConcurrentMap<Object, Map> transactionContext = new ConcurrentHashMap<Object, Map>();
    private final boolean putCacheRequiresTransaction;

    public QueryResultsRegionImpl(AdvancedCache cache, String name, InfinispanRegionFactory factory) {
        super(cache, name, factory);
        boolean localOnly = Caches.isInvalidationCache((AdvancedCache)cache);
        this.putCache = localOnly ? Caches.failSilentWriteCache((AdvancedCache)cache, (Flag)Flag.CACHE_MODE_LOCAL) : Caches.failSilentWriteCache((AdvancedCache)cache);
        this.getCache = Caches.failSilentReadCache((AdvancedCache)cache);
        TransactionConfiguration transactionConfiguration = this.putCache.getCacheConfiguration().transaction();
        boolean transactional = transactionConfiguration.transactionMode() != TransactionMode.NON_TRANSACTIONAL;
        boolean bl = this.putCacheRequiresTransaction = transactional && !transactionConfiguration.autoCommit();
        if (transactional) {
            log.useNonTransactionalQueryCache();
        }
    }

    @Override
    public void clear() throws CacheException {
        this.transactionContext.clear();
        this.invalidateRegion();
        Caches.broadcastEvictAll((AdvancedCache)this.cache);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        if (!this.checkValid()) {
            return null;
        }
        Object result = null;
        Map map = (Map)this.transactionContext.get(session);
        if (map != null) {
            result = map.get(key);
        }
        if (result == null) {
            result = this.getCache.get(key);
        }
        return result;
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        if (!this.checkValid()) {
            return;
        }
        SessionAccess.TransactionCoordinatorAccess tc = SESSION_ACCESS.getTransactionCoordinator((Object)session);
        if (tc != null && tc.isJoined()) {
            tc.registerLocalSynchronization((Synchronization)new PostTransactionQueryUpdate(tc, session, key, value));
            this.transactionContext.computeIfAbsent(session, k -> new HashMap()).put(key, value);
        } else {
            this.putCache.put(key, value);
        }
    }

    private class PostTransactionQueryUpdate
    extends InvocationAfterCompletion {
        private final Object session;
        private final Object key;
        private final Object value;

        PostTransactionQueryUpdate(SessionAccess.TransactionCoordinatorAccess tc, Object session, Object key, Object value) {
            super(tc, QueryResultsRegionImpl.this.putCacheRequiresTransaction);
            this.session = session;
            this.key = key;
            this.value = value;
        }

        public void afterCompletion(int status) {
            QueryResultsRegionImpl.this.transactionContext.remove(this.session);
            super.afterCompletion(status);
        }

        protected void invoke(boolean success) {
            if (success) {
                QueryResultsRegionImpl.this.putCache.put(this.key, this.value);
            }
        }
    }
}

