/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.logging;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class UndertowLogger_$logger
extends DelegatingBasicLogger
implements UndertowLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String couldNotInitJsp = "WFLYUT0001: Could not initialize JSP";
    private static final String serverStarting = "WFLYUT0003: Undertow %s starting";
    private static final String serverStopping = "WFLYUT0004: Undertow %s stopping";
    private static final String secureListenerNotAvailableForPort = "WFLYUT0005: Secure listener for protocol: '%s' not found! Using non secure port!";
    private static final String listenerStarted = "WFLYUT0006: Undertow %s listener %s listening on %s:%d";
    private static final String listenerStopped = "WFLYUT0007: Undertow %s listener %s stopped, was bound to %s:%d";
    private static final String listenerSuspend = "WFLYUT0008: Undertow %s listener %s suspending";
    private static final String cannotLoadDesignatedHandleTypes = "WFLYUT0009: Could not load class designated by HandlesTypes [%s].";
    private static final String couldNotLoadWebSocketEndpoint = "WFLYUT0010: Could not load web socket endpoint %s.";
    private static final String couldNotLoadWebSocketConfig = "WFLYUT0011: Could not load web socket application config %s.";
    private static final String startedServer = "WFLYUT0012: Started server %s.";
    private static final String invalidRedirectURI = "WFLYUT0013: Could not create redirect URI.";
    private static final String creatingFileHandler = "WFLYUT0014: Creating file handler for path '%s' with options [directory-listing: '%s', follow-symlink: '%s', case-sensitive: '%s', safe-symlink-paths: '%s']";
    private static final String invalidAbsoluteOrdering = "WFLYUT0016: Could not resolve name in absolute ordering: %s";
    private static final String couldNotDeleteTempFile = "WFLYUT0017: Could not delete servlet temp file %s";
    private static final String hostStarting = "WFLYUT0018: Host %s starting";
    private static final String hostStopping = "WFLYUT0019: Host %s stopping";
    private static final String clusteringNotSupported = "WFLYUT0020: Clustering not supported, falling back to non-clustered session manager";
    private static final String registerWebapp = "WFLYUT0021: Registered web context: '%s' for server '%s'";
    private static final String unregisterWebapp = "WFLYUT0022: Unregistered web context: '%s' from server '%s'";
    private static final String skippedSCI = "WFLYUT0023: Skipped SCI for jar: %s.";
    private static final String failedToPersistSessionAttribute = "WFLYUT0024: Failed to persist session attribute %s with value %s for session %s";
    private static final String failedToRegisterPolicyContextHandler = "WFLYUT0025: Failed to register policy context handler for key %s";
    private static final String failToParseXMLDescriptor3 = "WFLYUT0027: Failed to parse XML descriptor %s at [%s,%s]";
    private static final String failToParseXMLDescriptor1 = "WFLYUT0028: Failed to parse XML descriptor %s";
    private static final String invalidWebServletAnnotation = "WFLYUT0029: @WebServlet is only allowed at class level %s";
    private static final String invalidWebInitParamAnnotation = "WFLYUT0030: @WebInitParam requires name and value on %s";
    private static final String invalidWebFilterAnnotation = "WFLYUT0031: @WebFilter is only allowed at class level %s";
    private static final String invalidWebListenerAnnotation = "WFLYUT0032: @WebListener is only allowed at class level %s";
    private static final String invalidRunAsAnnotation = "WFLYUT0033: @RunAs needs to specify a role name on %s";
    private static final String invalidDeclareRolesAnnotation = "WFLYUT0034: @DeclareRoles needs to specify role names on %s";
    private static final String invalidMultipartConfigAnnotation = "WFLYUT0035: @MultipartConfig is only allowed at class level %s";
    private static final String invalidServletSecurityAnnotation = "WFLYUT0036: @ServletSecurity is only allowed at class level %s";
    private static final String wrongComponentType = "WFLYUT0037: %s has the wrong component type, it cannot be used as a web component";
    private static final String tldFileNotContainedInRoot = "WFLYUT0038: TLD file %s not contained in root %s";
    private static final String failedToResolveModule = "WFLYUT0039: Failed to resolve module for deployment %s";
    private static final String invalidMultipleOthers = "WFLYUT0040: Duplicate others in absolute ordering";
    private static final String invalidRelativeOrdering0 = "WFLYUT0041: Invalid relative ordering";
    private static final String invalidWebFragment = "WFLYUT0042: Conflict occurred processing web fragment in JAR: %s";
    private static final String invalidRelativeOrdering1 = "WFLYUT0043: Relative ordering processing error with JAR: %s";
    private static final String invalidRelativeOrderingBeforeAndAfter = "WFLYUT0044: Ordering includes both before and after others in JAR: %s";
    private static final String invalidRelativeOrderingDuplicateName = "WFLYUT0045: Duplicate name declared in JAR: %s";
    private static final String invalidRelativeOrderingUnknownName = "WFLYUT0046: Unknown web fragment name declared in JAR: %s";
    private static final String invalidRelativeOrderingConflict = "WFLYUT0047: Relative ordering conflict with JAR: %s";
    private static final String failToProcessWebInfLib = "WFLYUT0048: Failed to process WEB-INF/lib: %s";
    private static final String errorLoadingSCIFromModule = "WFLYUT0049: Error loading SCI from module: %s";
    private static final String unableToResolveAnnotationIndex = "WFLYUT0050: Unable to resolve annotation index for deployment unit: %s";
    private static final String errorProcessingSCI = "WFLYUT0051: Deployment error processing SCI for jar: %s";
    private static final String failToCreateSecurityContext = "WFLYUT0052: Security context creation failed";
    private static final String noSecurityContext = "WFLYUT0053: No security context found";
    private static final String unknownMetric = "WFLYUT0054: Unknown metric %s";
    private static final String nullDefaultHost = "WFLYUT0055: Null default host";
    private static final String nullHostName = "WFLYUT0056: Null host name";
    private static final String nullParamter = "WFLYUT0057: Null parameter %s";
    private static final String cannotActivateContext = "WFLYUT0058: Cannot activate context: %s";
    private static final String cannotCreateHttpHandler = "WFLYUT0059: Could not construct handler for class: %s. with parameters %s";
    private static final String invalidPersistentSessionDir = "WFLYUT0060: Invalid persistent sessions directory %s";
    private static final String failedToCreatePersistentSessionDir = "WFLYUT0061: Failed to create persistent sessions dir %s";
    private static final String couldNotCreateLogDirectory = "WFLYUT0062: Could not create log directory: %s";
    private static final String noPortListeningForProtocol = "WFLYUT0063: Could not find the port number listening for protocol %s";
    private static final String failedToConfigureHandler = "WFLYUT0064: Failed to configure handler %s";
    private static final String handlerWasNotAHandlerOrWrapper = "WFLYUT0065: Handler class %s was not a handler or a wrapper";
    private static final String failedToConfigureHandlerClass = "WFLYUT0066: Failed to configure handler %s";
    private static final String servletClassNotDefined = "WFLYUT0067: Servlet class not defined for servlet %s";
    private static final String noAuthorizationHelper = "WFLYUT0068: Error obtaining authorization helper";
    private static final String sharedSessionConfigNotInRootDeployment = "WFLYUT0069: Ignoring shared-session-config in jboss-all.xml in deployment %s. This entry is only valid in top level deployments.";
    private static final String couldNotLoadHandlerFromModule = "WFLYUT0070: Could not load handler %s from %s module";
    private static final String alpnNotFound = "WFLYUT0071: No ALPN provider found, HTTP/2 will not be enabled. To remove this message set enable-http2 to false on the listener %s in the Undertow subsystem.";
    private static final String couldNotFindExternalPath = "WFLYUT0072: Could not find configured external path %s";
    private static final String advertiseSocketBindingRequiresMulticastAddress = "WFLYUT0073: mod_cluster advertise socket binding requires multicast address to be set";
    private static final String tldNotFound = "WFLYUT0074: Could not find TLD %s";
    private static final String cannotRegisterResourceOfType = "WFLYUT0075: Cannot register resource of type %s";
    private static final String cannotRemoveResourceOfType = "WFLYUT0076: Cannot remove resource of type %s";
    private static final String failedToRegisterWebsocket = "WFLYUT0078: Failed to register management view for websocket %s at %s";
    private static final String errorInvokingSecureResponse = "WFLYUT0077: Error invoking secure response";
    private static final String noSslContextInSecurityRealm = "WFLYUT0079: No SSL Context available from security realm '%s'. Either the realm is not configured for SSL, or the server has not been reloaded since the SSL config was added.";
    private static final String unsupportedValveFeature = "WFLYUT0080: Valves are no longer supported, %s is not activated.";
    private static final String distributableDisabledInFragmentXml = "WFLYUT0081: The deployment %s will not be distributable because this feature is disabled in web-fragment.xml of the module %s.";
    private static final String couldNotStartListener = "WFLYUT0082: Could not start '%s' listener.";
    private static final String nullNotAllowed = "WFLYUT0083: %s is not allowed to be null";
    private static final String duplicateDefaultWebModuleMapping = "WFLYUT0087: Duplicate default web module '%s' configured on server '%s', host '%s'";
    private static final String predicateNotValid = "WFLYUT0089: Predicate %s was not valid, message was: %s";
    private static final String missingKeyStoreEntry = "WFLYUT0090: Key alias %s does not exist in the configured key store";
    private static final String keyStoreEntryNotPrivate = "WFLYUT0091: Key store entry %s is not a private key entry";
    private static final String missingCredential = "WFLYUT0092: Credential alias %s does not exist in the configured credential store";
    private static final String credentialNotClearPassword = "WFLYUT0093: Credential %s is not a clear text password";
    private static final String configurationOptionIgnoredWhenUsingElytron = "WFLYUT0094: Configuration option [%s] ignored when using Elytron subsystem";
    private static final String unableAddHandlerForPath = "WFLYUT0095: the path ['%s'] doesn't exist on file system";
    private static final String workerValueInHTTPListenerMustMatchRemoting = "WFLYUT0097: If http-upgrade is enabled, remoting worker and http(s) worker must be the same. Please adjust values if need be.";
    private static final String unexceptedAuthentificationError = "WFLYUT0098: Unexpected Authentication Error: %s";
    private static final String sessionManagerNotAvailable = "WFLYUT0099: Session manager not available";
    private static final String sessionNotFound = "WFLYUT0100: Session %s not found";
    private static final String duplicateServletMapping = "WFLYUT0101: Duplicate servlet mapping %s found";

    public UndertowLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void couldNotInitJsp(ClassNotFoundException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotInitJsp$str(), new Object[0]);
    }

    protected String couldNotInitJsp$str() {
        return couldNotInitJsp;
    }

    @Override
    public final void serverStarting(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarting$str(), (Object)version);
    }

    protected String serverStarting$str() {
        return serverStarting;
    }

    @Override
    public final void serverStopping(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopping$str(), (Object)version);
    }

    protected String serverStopping$str() {
        return serverStopping;
    }

    @Override
    public final void secureListenerNotAvailableForPort(String protocol) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.secureListenerNotAvailableForPort$str(), (Object)protocol);
    }

    protected String secureListenerNotAvailableForPort$str() {
        return secureListenerNotAvailableForPort;
    }

    @Override
    public final void listenerStarted(String type, String name, String address, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.listenerStarted$str(), new Object[]{type, name, address, port});
    }

    protected String listenerStarted$str() {
        return listenerStarted;
    }

    @Override
    public final void listenerStopped(String type, String name, String address, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.listenerStopped$str(), new Object[]{type, name, address, port});
    }

    protected String listenerStopped$str() {
        return listenerStopped;
    }

    @Override
    public final void listenerSuspend(String type, String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.listenerSuspend$str(), (Object)type, (Object)name);
    }

    protected String listenerSuspend$str() {
        return listenerSuspend;
    }

    @Override
    public final void cannotLoadDesignatedHandleTypes(ClassInfo classInfo, Exception e) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)e, this.cannotLoadDesignatedHandleTypes$str(), (Object)classInfo);
    }

    protected String cannotLoadDesignatedHandleTypes$str() {
        return cannotLoadDesignatedHandleTypes;
    }

    @Override
    public final void couldNotLoadWebSocketEndpoint(String s, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.couldNotLoadWebSocketEndpoint$str(), (Object)s);
    }

    protected String couldNotLoadWebSocketEndpoint$str() {
        return couldNotLoadWebSocketEndpoint;
    }

    @Override
    public final void couldNotLoadWebSocketConfig(String s, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.couldNotLoadWebSocketConfig$str(), (Object)s);
    }

    protected String couldNotLoadWebSocketConfig$str() {
        return couldNotLoadWebSocketConfig;
    }

    @Override
    public final void startedServer(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startedServer$str(), (Object)name);
    }

    protected String startedServer$str() {
        return startedServer;
    }

    @Override
    public final void invalidRedirectURI(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.invalidRedirectURI$str(), new Object[0]);
    }

    protected String invalidRedirectURI$str() {
        return invalidRedirectURI;
    }

    @Override
    public final void creatingFileHandler(String path, boolean directoryListing, boolean followSymlink, boolean caseSensitive, List<String> safePaths) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.creatingFileHandler$str(), new Object[]{path, directoryListing, followSymlink, caseSensitive, safePaths});
    }

    protected String creatingFileHandler$str() {
        return creatingFileHandler;
    }

    @Override
    public final void invalidAbsoluteOrdering(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidAbsoluteOrdering$str(), (Object)name);
    }

    protected String invalidAbsoluteOrdering$str() {
        return invalidAbsoluteOrdering;
    }

    @Override
    public final void couldNotDeleteTempFile(File file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.couldNotDeleteTempFile$str(), (Object)file);
    }

    protected String couldNotDeleteTempFile$str() {
        return couldNotDeleteTempFile;
    }

    @Override
    public final void hostStarting(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.hostStarting$str(), (Object)version);
    }

    protected String hostStarting$str() {
        return hostStarting;
    }

    @Override
    public final void hostStopping(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.hostStopping$str(), (Object)version);
    }

    protected String hostStopping$str() {
        return hostStopping;
    }

    @Override
    public final void clusteringNotSupported() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.clusteringNotSupported$str(), new Object[0]);
    }

    protected String clusteringNotSupported$str() {
        return clusteringNotSupported;
    }

    @Override
    public final void registerWebapp(String webappPath, String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registerWebapp$str(), (Object)webappPath, (Object)serverName);
    }

    protected String registerWebapp$str() {
        return registerWebapp;
    }

    @Override
    public final void unregisterWebapp(String webappPath, String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unregisterWebapp$str(), (Object)webappPath, (Object)serverName);
    }

    protected String unregisterWebapp$str() {
        return unregisterWebapp;
    }

    @Override
    public final void skippedSCI(String jar, Exception e) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)e, this.skippedSCI$str(), (Object)jar);
    }

    protected String skippedSCI$str() {
        return skippedSCI;
    }

    @Override
    public final void failedToPersistSessionAttribute(String attributeName, Object value, String sessionID, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToPersistSessionAttribute$str(), (Object)attributeName, value, (Object)sessionID);
    }

    protected String failedToPersistSessionAttribute$str() {
        return failedToPersistSessionAttribute;
    }

    @Override
    public final void failedToRegisterPolicyContextHandler(String key, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToRegisterPolicyContextHandler$str(), (Object)key);
    }

    protected String failedToRegisterPolicyContextHandler$str() {
        return failedToRegisterPolicyContextHandler;
    }

    protected String failToParseXMLDescriptor3$str() {
        return failToParseXMLDescriptor3;
    }

    @Override
    public final String failToParseXMLDescriptor(String xmlFile, Integer line, Integer column) {
        return String.format(this.getLoggingLocale(), this.failToParseXMLDescriptor3$str(), xmlFile, line, column);
    }

    protected String failToParseXMLDescriptor1$str() {
        return failToParseXMLDescriptor1;
    }

    @Override
    public final String failToParseXMLDescriptor(String xmlFile) {
        return String.format(this.getLoggingLocale(), this.failToParseXMLDescriptor1$str(), xmlFile);
    }

    protected String invalidWebServletAnnotation$str() {
        return invalidWebServletAnnotation;
    }

    @Override
    public final String invalidWebServletAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidWebServletAnnotation$str(), target);
    }

    protected String invalidWebInitParamAnnotation$str() {
        return invalidWebInitParamAnnotation;
    }

    @Override
    public final String invalidWebInitParamAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidWebInitParamAnnotation$str(), target);
    }

    protected String invalidWebFilterAnnotation$str() {
        return invalidWebFilterAnnotation;
    }

    @Override
    public final String invalidWebFilterAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidWebFilterAnnotation$str(), target);
    }

    protected String invalidWebListenerAnnotation$str() {
        return invalidWebListenerAnnotation;
    }

    @Override
    public final String invalidWebListenerAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidWebListenerAnnotation$str(), target);
    }

    protected String invalidRunAsAnnotation$str() {
        return invalidRunAsAnnotation;
    }

    @Override
    public final String invalidRunAsAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidRunAsAnnotation$str(), target);
    }

    protected String invalidDeclareRolesAnnotation$str() {
        return invalidDeclareRolesAnnotation;
    }

    @Override
    public final String invalidDeclareRolesAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidDeclareRolesAnnotation$str(), target);
    }

    protected String invalidMultipartConfigAnnotation$str() {
        return invalidMultipartConfigAnnotation;
    }

    @Override
    public final String invalidMultipartConfigAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidMultipartConfigAnnotation$str(), target);
    }

    protected String invalidServletSecurityAnnotation$str() {
        return invalidServletSecurityAnnotation;
    }

    @Override
    public final String invalidServletSecurityAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidServletSecurityAnnotation$str(), target);
    }

    protected String wrongComponentType$str() {
        return wrongComponentType;
    }

    @Override
    public final RuntimeException wrongComponentType(String clazz) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.wrongComponentType$str(), clazz));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tldFileNotContainedInRoot$str() {
        return tldFileNotContainedInRoot;
    }

    @Override
    public final String tldFileNotContainedInRoot(String tldPath, String rootPath) {
        return String.format(this.getLoggingLocale(), this.tldFileNotContainedInRoot$str(), tldPath, rootPath);
    }

    protected String failedToResolveModule$str() {
        return failedToResolveModule;
    }

    @Override
    public final DeploymentUnitProcessingException failedToResolveModule(DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToResolveModule$str(), deploymentUnit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMultipleOthers$str() {
        return invalidMultipleOthers;
    }

    @Override
    public final String invalidMultipleOthers() {
        return String.format(this.getLoggingLocale(), this.invalidMultipleOthers$str(), new Object[0]);
    }

    protected String invalidRelativeOrdering0$str() {
        return invalidRelativeOrdering0;
    }

    @Override
    public final String invalidRelativeOrdering() {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrdering0$str(), new Object[0]);
    }

    protected String invalidWebFragment$str() {
        return invalidWebFragment;
    }

    @Override
    public final String invalidWebFragment(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidWebFragment$str(), jar);
    }

    protected String invalidRelativeOrdering1$str() {
        return invalidRelativeOrdering1;
    }

    @Override
    public final String invalidRelativeOrdering(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrdering1$str(), jar);
    }

    protected String invalidRelativeOrderingBeforeAndAfter$str() {
        return invalidRelativeOrderingBeforeAndAfter;
    }

    @Override
    public final String invalidRelativeOrderingBeforeAndAfter(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrderingBeforeAndAfter$str(), jar);
    }

    protected String invalidRelativeOrderingDuplicateName$str() {
        return invalidRelativeOrderingDuplicateName;
    }

    @Override
    public final String invalidRelativeOrderingDuplicateName(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrderingDuplicateName$str(), jar);
    }

    @Override
    public final void invalidRelativeOrderingUnknownName(String jar) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidRelativeOrderingUnknownName$str(), (Object)jar);
    }

    protected String invalidRelativeOrderingUnknownName$str() {
        return invalidRelativeOrderingUnknownName;
    }

    protected String invalidRelativeOrderingConflict$str() {
        return invalidRelativeOrderingConflict;
    }

    @Override
    public final String invalidRelativeOrderingConflict(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrderingConflict$str(), jar);
    }

    protected String failToProcessWebInfLib$str() {
        return failToProcessWebInfLib;
    }

    @Override
    public final String failToProcessWebInfLib(VirtualFile xmlFile) {
        return String.format(this.getLoggingLocale(), this.failToProcessWebInfLib$str(), xmlFile);
    }

    protected String errorLoadingSCIFromModule$str() {
        return errorLoadingSCIFromModule;
    }

    @Override
    public final DeploymentUnitProcessingException errorLoadingSCIFromModule(String identifier, Exception e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorLoadingSCIFromModule$str(), identifier), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToResolveAnnotationIndex$str() {
        return unableToResolveAnnotationIndex;
    }

    @Override
    public final DeploymentUnitProcessingException unableToResolveAnnotationIndex(DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.unableToResolveAnnotationIndex$str(), deploymentUnit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorProcessingSCI$str() {
        return errorProcessingSCI;
    }

    @Override
    public final DeploymentUnitProcessingException errorProcessingSCI(String jar, Exception e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorProcessingSCI$str(), jar), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToCreateSecurityContext$str() {
        return failToCreateSecurityContext;
    }

    @Override
    public final RuntimeException failToCreateSecurityContext(Throwable t) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failToCreateSecurityContext$str(), new Object[0]), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSecurityContext$str() {
        return noSecurityContext;
    }

    @Override
    public final IllegalStateException noSecurityContext() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noSecurityContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownMetric$str() {
        return unknownMetric;
    }

    @Override
    public final String unknownMetric(Object metric) {
        return String.format(this.getLoggingLocale(), this.unknownMetric$str(), metric);
    }

    protected String nullDefaultHost$str() {
        return nullDefaultHost;
    }

    @Override
    public final IllegalArgumentException nullDefaultHost() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullDefaultHost$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullHostName$str() {
        return nullHostName;
    }

    @Override
    public final IllegalStateException nullHostName() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.nullHostName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullParamter$str() {
        return nullParamter;
    }

    @Override
    public final IllegalArgumentException nullParamter(String id) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullParamter$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotActivateContext$str() {
        return cannotActivateContext;
    }

    @Override
    public final IllegalStateException cannotActivateContext(Throwable th, ServiceName service) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotActivateContext$str(), service), th);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateHttpHandler$str() {
        return cannotCreateHttpHandler;
    }

    @Override
    public final RuntimeException cannotCreateHttpHandler(Class<?> handlerClass, ModelNode parameters, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotCreateHttpHandler$str(), handlerClass, parameters), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPersistentSessionDir$str() {
        return invalidPersistentSessionDir;
    }

    @Override
    public final StartException invalidPersistentSessionDir(File baseDir) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidPersistentSessionDir$str(), baseDir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToCreatePersistentSessionDir$str() {
        return failedToCreatePersistentSessionDir;
    }

    @Override
    public final StartException failedToCreatePersistentSessionDir(File baseDir) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToCreatePersistentSessionDir$str(), baseDir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateLogDirectory$str() {
        return couldNotCreateLogDirectory;
    }

    @Override
    public final StartException couldNotCreateLogDirectory(Path directory, IOException e) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.couldNotCreateLogDirectory$str(), directory), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPortListeningForProtocol$str() {
        return noPortListeningForProtocol;
    }

    @Override
    public final IllegalStateException noPortListeningForProtocol(String protocol) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noPortListeningForProtocol$str(), protocol));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToConfigureHandler$str() {
        return failedToConfigureHandler;
    }

    @Override
    public final RuntimeException failedToConfigureHandler(Class<?> handlerClass, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToConfigureHandler$str(), handlerClass), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String handlerWasNotAHandlerOrWrapper$str() {
        return handlerWasNotAHandlerOrWrapper;
    }

    @Override
    public final IllegalArgumentException handlerWasNotAHandlerOrWrapper(Class<?> handlerClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.handlerWasNotAHandlerOrWrapper$str(), handlerClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToConfigureHandlerClass$str() {
        return failedToConfigureHandlerClass;
    }

    @Override
    public final RuntimeException failedToConfigureHandlerClass(String handlerClass, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToConfigureHandlerClass$str(), handlerClass), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String servletClassNotDefined$str() {
        return servletClassNotDefined;
    }

    @Override
    public final IllegalArgumentException servletClassNotDefined(String servletName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.servletClassNotDefined$str(), servletName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void noAuthorizationHelper(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.noAuthorizationHelper$str(), new Object[0]);
    }

    protected String noAuthorizationHelper$str() {
        return noAuthorizationHelper;
    }

    @Override
    public final void sharedSessionConfigNotInRootDeployment(String deployment) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.sharedSessionConfigNotInRootDeployment$str(), (Object)deployment);
    }

    protected String sharedSessionConfigNotInRootDeployment$str() {
        return sharedSessionConfigNotInRootDeployment;
    }

    protected String couldNotLoadHandlerFromModule$str() {
        return couldNotLoadHandlerFromModule;
    }

    @Override
    public final RuntimeException couldNotLoadHandlerFromModule(String className, String moduleName, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotLoadHandlerFromModule$str(), className, moduleName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void alpnNotFound(String listener) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.alpnNotFound$str(), (Object)listener);
    }

    protected String alpnNotFound$str() {
        return alpnNotFound;
    }

    protected String couldNotFindExternalPath$str() {
        return couldNotFindExternalPath;
    }

    @Override
    public final DeploymentUnitProcessingException couldNotFindExternalPath(File path) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotFindExternalPath$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String advertiseSocketBindingRequiresMulticastAddress$str() {
        return advertiseSocketBindingRequiresMulticastAddress;
    }

    @Override
    public final StartException advertiseSocketBindingRequiresMulticastAddress() {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.advertiseSocketBindingRequiresMulticastAddress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void tldNotFound(String location) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.tldNotFound$str(), (Object)location);
    }

    protected String tldNotFound$str() {
        return tldNotFound;
    }

    protected String cannotRegisterResourceOfType$str() {
        return cannotRegisterResourceOfType;
    }

    @Override
    public final IllegalArgumentException cannotRegisterResourceOfType(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotRegisterResourceOfType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRemoveResourceOfType$str() {
        return cannotRemoveResourceOfType;
    }

    @Override
    public final IllegalArgumentException cannotRemoveResourceOfType(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotRemoveResourceOfType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void failedToRegisterWebsocket(Class endpoint, String path, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToRegisterWebsocket$str(), (Object)endpoint, (Object)path);
    }

    protected String failedToRegisterWebsocket$str() {
        return failedToRegisterWebsocket;
    }

    @Override
    public final void errorInvokingSecureResponse(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorInvokingSecureResponse$str(), new Object[0]);
    }

    protected String errorInvokingSecureResponse$str() {
        return errorInvokingSecureResponse;
    }

    protected String noSslContextInSecurityRealm$str() {
        return noSslContextInSecurityRealm;
    }

    @Override
    public final IllegalStateException noSslContextInSecurityRealm(String securityRealm) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noSslContextInSecurityRealm$str(), securityRealm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unsupportedValveFeature(String valve) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedValveFeature$str(), (Object)valve);
    }

    protected String unsupportedValveFeature$str() {
        return unsupportedValveFeature;
    }

    @Override
    public final void distributableDisabledInFragmentXml(String deployment, String module) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.distributableDisabledInFragmentXml$str(), (Object)deployment, (Object)module);
    }

    protected String distributableDisabledInFragmentXml$str() {
        return distributableDisabledInFragmentXml;
    }

    protected String couldNotStartListener$str() {
        return couldNotStartListener;
    }

    @Override
    public final StartException couldNotStartListener(String name, IOException e) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.couldNotStartListener$str(), name), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullNotAllowed$str() {
        return nullNotAllowed;
    }

    @Override
    public final String nullNotAllowed(String name) {
        return String.format(this.getLoggingLocale(), this.nullNotAllowed$str(), name);
    }

    protected String duplicateDefaultWebModuleMapping$str() {
        return duplicateDefaultWebModuleMapping;
    }

    @Override
    public final IllegalArgumentException duplicateDefaultWebModuleMapping(String defaultDeploymentName, String serverName, String hostName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.duplicateDefaultWebModuleMapping$str(), defaultDeploymentName, serverName, hostName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String predicateNotValid$str() {
        return predicateNotValid;
    }

    @Override
    public final String predicateNotValid(String predicate, String error) {
        return String.format(this.getLoggingLocale(), this.predicateNotValid$str(), predicate, error);
    }

    protected String missingKeyStoreEntry$str() {
        return missingKeyStoreEntry;
    }

    @Override
    public final IllegalArgumentException missingKeyStoreEntry(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingKeyStoreEntry$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreEntryNotPrivate$str() {
        return keyStoreEntryNotPrivate;
    }

    @Override
    public final IllegalArgumentException keyStoreEntryNotPrivate(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.keyStoreEntryNotPrivate$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCredential$str() {
        return missingCredential;
    }

    @Override
    public final IllegalArgumentException missingCredential(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingCredential$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNotClearPassword$str() {
        return credentialNotClearPassword;
    }

    @Override
    public final IllegalArgumentException credentialNotClearPassword(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.credentialNotClearPassword$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void configurationOptionIgnoredWhenUsingElytron(String option) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configurationOptionIgnoredWhenUsingElytron$str(), (Object)option);
    }

    protected String configurationOptionIgnoredWhenUsingElytron$str() {
        return configurationOptionIgnoredWhenUsingElytron;
    }

    protected String unableAddHandlerForPath$str() {
        return unableAddHandlerForPath;
    }

    @Override
    public final String unableAddHandlerForPath(String path) {
        return String.format(this.getLoggingLocale(), this.unableAddHandlerForPath$str(), path);
    }

    protected String workerValueInHTTPListenerMustMatchRemoting$str() {
        return workerValueInHTTPListenerMustMatchRemoting;
    }

    @Override
    public final String workerValueInHTTPListenerMustMatchRemoting() {
        return String.format(this.getLoggingLocale(), this.workerValueInHTTPListenerMustMatchRemoting$str(), new Object[0]);
    }

    @Override
    public final void unexceptedAuthentificationError(String errorMessage, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unexceptedAuthentificationError$str(), (Object)errorMessage);
    }

    protected String unexceptedAuthentificationError$str() {
        return unexceptedAuthentificationError;
    }

    protected String sessionManagerNotAvailable$str() {
        return sessionManagerNotAvailable;
    }

    @Override
    public final OperationFailedException sessionManagerNotAvailable() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.sessionManagerNotAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionNotFound$str() {
        return sessionNotFound;
    }

    @Override
    public final OperationFailedException sessionNotFound(String sessionId) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.sessionNotFound$str(), sessionId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void duplicateServletMapping(String mapping) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.duplicateServletMapping$str(), (Object)mapping);
    }

    protected String duplicateServletMapping$str() {
        return duplicateServletMapping;
    }
}

