/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.util.ReadOnlySegmentAwareIterator;
import org.infinispan.util.AbstractDelegatingCollection;

public class ReadOnlySegmentAwareCollection<E>
extends AbstractDelegatingCollection<E> {
    protected final Collection<E> set;
    protected final ConsistentHash ch;
    protected final IntSet allowedSegments;

    public ReadOnlySegmentAwareCollection(Collection<E> set, ConsistentHash ch, IntSet allowedSegments) {
        this.set = Collections.unmodifiableCollection(set);
        this.ch = ch;
        this.allowedSegments = allowedSegments;
    }

    @Override
    protected Collection<E> delegate() {
        return this.set;
    }

    protected boolean valueAllowed(Object obj) {
        int segment = this.ch.getSegment(obj);
        return this.allowedSegments.contains(segment);
    }

    @Override
    public boolean contains(Object o) {
        if (this.valueAllowed(o)) {
            return super.contains(o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (!this.valueAllowed(obj) || super.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        Iterator<E> iter = this.iterator();
        return !iter.hasNext();
    }

    @Override
    public int size() {
        Iterator<E> iter = this.iterator();
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlySegmentAwareIterator(super.iterator(), this.ch, this.allowedSegments);
    }
}

