/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.BinaryEncoder;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.CompatModeEncoder;
import org.infinispan.commons.dataconversion.DefaultTranscoder;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.GenericJbossMarshallerEncoder;
import org.infinispan.commons.dataconversion.GlobalMarshallerEncoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.JavaCompatEncoder;
import org.infinispan.commons.dataconversion.JavaSerializationEncoder;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.UTF8CompatEncoder;
import org.infinispan.commons.dataconversion.UTF8Encoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.core.EncoderRegistryImpl;

@DefaultFactoryFor(classes={EncoderRegistry.class})
public class EncoderRegistryFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    @Inject
    private StreamingMarshaller globalMarshaller;
    @Inject
    private EmbeddedCacheManager embeddedCacheManager;

    @Override
    public <T> T construct(Class<T> componentType) {
        EncoderRegistryImpl encoderRegistry = new EncoderRegistryImpl();
        ClassWhiteList classWhiteList = this.embeddedCacheManager.getClassWhiteList();
        ClassLoader classLoader = this.globalConfiguration.classLoader();
        GenericJBossMarshaller jBossMarshaller = new GenericJBossMarshaller(classLoader, classWhiteList);
        JavaSerializationMarshaller javaSerializationMarshaller = new JavaSerializationMarshaller(classWhiteList);
        encoderRegistry.registerEncoder((Encoder)IdentityEncoder.INSTANCE);
        encoderRegistry.registerEncoder((Encoder)UTF8Encoder.INSTANCE);
        encoderRegistry.registerEncoder((Encoder)new JavaSerializationEncoder(classWhiteList));
        encoderRegistry.registerEncoder((Encoder)new BinaryEncoder(this.globalMarshaller));
        encoderRegistry.registerEncoder((Encoder)new GenericJbossMarshallerEncoder(jBossMarshaller));
        encoderRegistry.registerEncoder((Encoder)new GlobalMarshallerEncoder((Marshaller)this.globalMarshaller));
        encoderRegistry.registerEncoder((Encoder)new CompatModeEncoder((Marshaller)this.globalMarshaller));
        encoderRegistry.registerEncoder((Encoder)new JavaCompatEncoder(classWhiteList));
        encoderRegistry.registerEncoder((Encoder)UTF8CompatEncoder.INSTANCE);
        encoderRegistry.registerTranscoder((Transcoder)new DefaultTranscoder(jBossMarshaller, javaSerializationMarshaller));
        encoderRegistry.registerWrapper((Wrapper)ByteArrayWrapper.INSTANCE);
        encoderRegistry.registerWrapper((Wrapper)IdentityWrapper.INSTANCE);
        return componentType.cast(encoderRegistry);
    }
}

