/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import io.smallrye.health.SmallRyeHealth;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

@ApplicationScoped
public class SmallRyeHealthReporter {
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true);
    @Inject
    @Health
    private Instance<HealthCheck> checks;
    private List<HealthCheck> additionalChecks = new ArrayList<HealthCheck>();

    public void reportHealth(OutputStream out, SmallRyeHealth health) {
        JsonWriterFactory factory = Json.createWriterFactory(JSON_CONFIG);
        JsonWriter writer = factory.createWriter(out);
        writer.writeObject(health.getPayload());
        writer.close();
    }

    public SmallRyeHealth getHealth() {
        JsonArrayBuilder results = Json.createArrayBuilder();
        HealthCheckResponse.State outcome = HealthCheckResponse.State.UP;
        if (this.checks != null) {
            for (HealthCheck check : this.checks) {
                outcome = this.fillCheck(check, results, outcome);
            }
        }
        if (!this.additionalChecks.isEmpty()) {
            for (HealthCheck check : this.additionalChecks) {
                outcome = this.fillCheck(check, results, outcome);
            }
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("outcome", outcome.toString());
        builder.add("checks", results);
        return new SmallRyeHealth(builder.build());
    }

    private HealthCheckResponse.State fillCheck(HealthCheck check, JsonArrayBuilder results, HealthCheckResponse.State globalOutcome) {
        String state;
        if (check == null) {
            return globalOutcome;
        }
        JsonObject each = this.jsonObject(check);
        results.add((JsonValue)each);
        if (globalOutcome == HealthCheckResponse.State.UP && (state = each.getString("state")).equals("DOWN")) {
            return HealthCheckResponse.State.DOWN;
        }
        return globalOutcome;
    }

    private JsonObject jsonObject(HealthCheck check) {
        return this.jsonObject(check.call());
    }

    private JsonObject jsonObject(HealthCheckResponse response) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("name", response.getName());
        builder.add("state", response.getState().toString());
        response.getData().ifPresent(d -> {
            JsonObjectBuilder data = Json.createObjectBuilder();
            for (Map.Entry entry : d.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    data.add((String)entry.getKey(), ((Long)value).longValue());
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
            }
            builder.add("data", (JsonValue)data.build());
        });
        return builder.build();
    }

    public void addHealthCheck(HealthCheck check) {
        if (check != null) {
            this.additionalChecks.add(check);
        }
    }

    public void removeHealthCheck(HealthCheck check) {
        this.additionalChecks.remove(check);
    }
}

