/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public class SmallRyeConfigProviderResolver
extends ConfigProviderResolver {
    public static final SmallRyeConfigProviderResolver INSTANCE = new SmallRyeConfigProviderResolver();
    private Map<ClassLoader, Config> configsForClassLoader = new HashMap<ClassLoader, Config>();

    public Config getConfig() {
        return this.getConfig(Thread.currentThread().getContextClassLoader());
    }

    public Config getConfig(ClassLoader classLoader) {
        Config config = this.configsForClassLoader.get(classLoader);
        if (config != null) {
            return config;
        }
        config = this.getBuilder().forClassLoader(classLoader).addDefaultSources().addDiscoveredSources().addDiscoveredConverters().build();
        this.registerConfig(config, classLoader);
        return config;
    }

    public ConfigBuilder getBuilder() {
        return new SmallRyeConfigBuilder();
    }

    public void registerConfig(Config config, ClassLoader classLoader) {
        this.configsForClassLoader.put(classLoader, config);
    }

    public void releaseConfig(Config config) {
        Iterator<Map.Entry<ClassLoader, Config>> iterator = this.configsForClassLoader.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ClassLoader, Config> entry = iterator.next();
            if (entry.getValue() != config) continue;
            iterator.remove();
            return;
        }
    }
}

