/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.jboss.logging.Logger;

public class EmbedMessageUtil {
    private static final byte[] signature = new byte[]{69, 77, 66};
    private static final Logger logger = Logger.getLogger(EmbedMessageUtil.class);

    public static ICoreMessage embedAsCoreMessage(Message source) {
        if (source instanceof ICoreMessage) {
            return (ICoreMessage)source;
        }
        Persister persister = source.getPersister();
        CoreMessage message = new CoreMessage(source.getMessageID(), persister.getEncodeSize((Object)source) + signature.length + 4).setType((byte)7);
        ActiveMQBuffer buffer = message.getBodyBuffer();
        buffer.writeBytes(signature);
        persister.encode(buffer, (Object)source);
        return message;
    }

    public static Message extractEmbedded(ICoreMessage message) {
        if (message.getType() == 7) {
            ActiveMQBuffer buffer = message.getReadOnlyBodyBuffer();
            if (buffer.readableBytes() < signature.length || !EmbedMessageUtil.checkSignature(buffer)) {
                if (!logger.isTraceEnabled()) {
                    logger.trace((Object)"Message type 7 was used for something other than embed messages, ignoring content and treating as a regular message");
                }
                return message;
            }
            try {
                return MessagePersister.getInstance().decode(buffer, null);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                return message;
            }
        }
        return message;
    }

    private static boolean checkSignature(ActiveMQBuffer buffer) {
        return buffer.readByte() == signature[0] && buffer.readByte() == signature[1] && buffer.readByte() == signature[2];
    }
}

