/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.resource.NotSupportedException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;

public class ActiveMQRABundle_$bundle
implements ActiveMQRABundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQRABundle_$bundle INSTANCE = new ActiveMQRABundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String errorDecodingPassword = "AMQ159000: Error decoding password using codec instance";
    private static final String noActivationSpec = "AMQ159001: MDB cannot be deployed as it has no Activation Spec. Please provide an Activation!";
    private static final String noDestinationName = "AMQ159002: Please provide a destination for the MDB";
    private static final String illegalJEEMethod = "AMQ159003: This method is not applicable inside the application server. See the JEE spec, e.g. JEE 7 Section 6.7";
    private static final String invalidSessionTransactedModeRuntime = "AMQ159004: Invalid Session Mode SESSION_TRANSACTED";
    private static final String invalidClientAcknowledgeModeRuntime = "AMQ159005: Invalid Session Mode CLIENT_ACKNOWLEDGE";
    private static final String invalidAcknowledgeMode = "AMQ159006: Invalid Session Mode {0}";
    private static final String invalidSessionTransactedModeRuntimeAllowLocal = "AMQ159007: Invalid Session Mode SESSION_TRANSACTED, to enable Local Transacted Sessions you can set the allowLocalTransactions (allow-local-transactions) on the resource adapter";

    protected ActiveMQRABundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String errorDecodingPassword$str() {
        return errorDecodingPassword;
    }

    @Override
    public final ActiveMQIllegalStateException errorDecodingPassword(Exception e) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.errorDecodingPassword$str(), new Object[0]));
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noActivationSpec$str() {
        return noActivationSpec;
    }

    @Override
    public final NotSupportedException noActivationSpec() {
        NotSupportedException result = new NotSupportedException(String.format(this.getLoggingLocale(), this.noActivationSpec$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDestinationName$str() {
        return noDestinationName;
    }

    @Override
    public final IllegalArgumentException noDestinationName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noDestinationName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalJEEMethod$str() {
        return illegalJEEMethod;
    }

    @Override
    public final JMSRuntimeException illegalJEEMethod() {
        JMSRuntimeException result = new JMSRuntimeException(String.format(this.getLoggingLocale(), this.illegalJEEMethod$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSessionTransactedModeRuntime$str() {
        return invalidSessionTransactedModeRuntime;
    }

    @Override
    public final JMSRuntimeException invalidSessionTransactedModeRuntime() {
        JMSRuntimeException result = new JMSRuntimeException(String.format(this.getLoggingLocale(), this.invalidSessionTransactedModeRuntime$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidClientAcknowledgeModeRuntime$str() {
        return invalidClientAcknowledgeModeRuntime;
    }

    @Override
    public final JMSRuntimeException invalidClientAcknowledgeModeRuntime() {
        JMSRuntimeException result = new JMSRuntimeException(String.format(this.getLoggingLocale(), this.invalidClientAcknowledgeModeRuntime$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAcknowledgeMode$str() {
        return invalidAcknowledgeMode;
    }

    @Override
    public final JMSRuntimeException invalidAcknowledgeMode(int sessionMode) {
        JMSRuntimeException result = new JMSRuntimeException(this._formatMessage(this.invalidAcknowledgeMode$str(), sessionMode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String invalidSessionTransactedModeRuntimeAllowLocal$str() {
        return invalidSessionTransactedModeRuntimeAllowLocal;
    }

    @Override
    public final JMSException invalidSessionTransactedModeRuntimeAllowLocal() {
        JMSException result = new JMSException(String.format(this.getLoggingLocale(), this.invalidSessionTransactedModeRuntimeAllowLocal$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

