/*
 * Decompiled with CFR 0.152.
 */
package org.kie.openrewrite.recipe.jpmml;

import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.kie.openrewrite.recipe.jpmml.JPMMLCodeRecipe;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.Java11Parser;
import org.openrewrite.java.JavaParser;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

public class JPMMLCodeRecipeTest
implements RewriteTest {
    public void defaults(RecipeSpec spec) {
        List paths = JavaParser.runtimeClasspath();
        spec.recipe((Recipe)new JPMMLCodeRecipe("org.dmg.pmml.ScoreDistribution", "org.dmg.pmml.ComplexScoreDistribution"));
        spec.parser((Parser.Builder)((Java11Parser.Builder)Java11Parser.builder().classpath((Collection)paths)).logCompilationWarningsAndErrors(true));
    }

    @Test
    public void removeFieldNameCreate() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic void method() {\nSystem.out.println(FieldName.create(\"OUTPUT_\"));\n}\n}";
        String after = "package com.yourorg;\nclass FooBar {\nstatic void method() {\nSystem.out.println(\"OUTPUT_\");\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeInstantiation_ScoreDistribution() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.ScoreDistribution;\nclass FooBar {\nstatic void method() {\nScoreDistribution toReturn = new ScoreDistribution();\n}\n}";
        String after = "package com.yourorg;\nimport org.dmg.pmml.ComplexScoreDistribution;\nimport org.dmg.pmml.ScoreDistribution;\n\nclass FooBar {\nstatic void method() {\nScoreDistribution toReturn = new ComplexScoreDistribution();\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeInstantiation_DataDictionary() {
        String before = "package com.yourorg;\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\nclass FooBar {\nstatic void method(List<DataField> dataFields) {\nDataDictionary dataDictionary = new DataDictionary(dataFields);\n}\n}";
        String after = "package com.yourorg;\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\nclass FooBar {\nstatic void method(List<DataField> dataFields) {\nDataDictionary dataDictionary = new DataDictionary().addDataFields(dataFields.toArray(new org.dmg.pmml.DataField[0]));\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeUsage_FieldNameCreateWithBinary() {
        String before = "package com.yourorg;\n\nimport org.dmg.pmml.DataField;\nimport org.dmg.pmml.FieldName;\n\npublic class Stub {\n      \n    public void hello(DataField dataField) {\n        System.out.println(FieldName.create(\"OUTPUT_\" + dataField.getName().getValue()));\n    }\n\n}";
        String after = "package com.yourorg;\n\nimport org.dmg.pmml.DataField;\n\npublic class Stub {\n      \n    public void hello(DataField dataField) {\n        System.out.println(\"OUTPUT_\" +dataField.getName());\n    }\n\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }
}

