/*
 * Decompiled with CFR 0.152.
 */
package org.kie.openrewrite.recipe.jpmml;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.Java11Parser;
import org.openrewrite.java.JavaParser;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class JPMMLRecipeTest
implements RewriteTest {
    private static final String JPMML_RECIPE_NAME = "org.kie.openrewrite.recipe.jpmml.JPMMLRecipe";

    JPMMLRecipeTest() {
    }

    public void defaults(RecipeSpec spec) {
        List paths = JavaParser.runtimeClasspath();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/rewrite/rewrite.yml");){
            spec.recipe(inputStream, new String[]{JPMML_RECIPE_NAME});
            spec.parser((Parser.Builder)((Java11Parser.Builder)Java11Parser.builder().classpath((Collection)paths)).logCompilationWarningsAndErrors(true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void changeInstantiation_DataDictionary() {
        String before = "package com.yourorg;\n\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\n\npublic class Stub {\n\n    public String hello(List<DataField> dataFields) {\n        new DataDictionary(dataFields);\n        return \"Hello from com.yourorg.FooLol!\";\n    }\n\n}";
        String after = "package com.yourorg;\n\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\n\npublic class Stub {\n\n    public String hello(List<DataField> dataFields) {\n        new DataDictionary().addStrings(dataFields.toArray(new String[0]));\n        return \"Hello from com.yourorg.FooLol!\";\n    }\n\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void addMissingMethods_Model() {
        String before = "package com.yourorg;\n\nimport org.dmg.pmml.Model;\n\npublic class Stub extends Model {\n\n}";
        String after = "package com.yourorg;\n\nimport org.dmg.pmml.Model;\n\npublic class Stub extends Model {\n    @Override\n    public MiningFunction requireMiningFunction() {\n        return null;\n    }\n\n    @Override\n    public MiningSchema requireMiningSchema() {\n        return null;\n    }\n\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeImports() {
        String before = "package com.yourorg;\nimport org.jpmml.model.inlinetable.InputCell;\nclass FooBar {\nstatic public void method() {\nInputCell input = null;\n}\n}";
        String after = "package com.yourorg;\n\nimport org.jpmml.model.cells.InputCell;\n\nclass FooBar {\nstatic public void method() {\nInputCell input = null;\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeFieldNameVariableDeclaration() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\nFieldName fieldName = FieldName.create(\"OUTPUT_\");\n}\n}";
        String after = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\n String fieldName =  String.valueOf(\"OUTPUT_\");\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeFieldNameVariableNull() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\nFieldName fieldName = null;\n}\n}";
        String after = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\n String fieldName = null;\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void removeFieldNameCreate() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\nSystem.out.println(FieldName.create(\"OUTPUT_\"));\n}\n}";
        String after = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\nSystem.out.println( String.valueOf(\"OUTPUT_\"));\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void removeFieldNameGetValue() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.OutputField;\nclass FooBar {\nstatic public void method(OutputField toConvert) {\nfinal String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;\n}\n}";
        String after = "package com.yourorg;\nimport org.dmg.pmml.OutputField;\nclass FooBar {\nstatic public void method(OutputField toConvert) {\nfinal String name = toConvert.getName() != null ?toConvert.getName() : null;\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeInstantiation_ScoreDistribution() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.ScoreDistribution;\nclass FooBar {\nstatic public void method() {\nScoreDistribution toReturn = new ScoreDistribution();\n}\n}";
        String after = "package com.yourorg;\nimport org.dmg.pmml.ComplexScoreDistribution;\nimport org.dmg.pmml.ScoreDistribution;\n\nclass FooBar {\nstatic public void method() {\nScoreDistribution toReturn = new ComplexScoreDistribution();\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }
}

