/*
 * Decompiled with CFR 0.152.
 */
package org.kie.openrewrite.recipe.jpmml;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.openrewrite.recipe.jpmml.CommonTestingUtilities;
import org.kie.openrewrite.recipe.jpmml.JPMMLVisitor;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

class JPMMLVisitorTest {
    private JPMMLVisitor jpmmlVisitor;

    JPMMLVisitorTest() {
    }

    @BeforeEach
    public void init() {
        this.jpmmlVisitor = new JPMMLVisitor("org.dmg.pmml.ScoreDistribution", "org.dmg.pmml.ComplexScoreDistribution");
    }

    @Test
    public void visitBinary_StringFieldNameGetValue() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.DataField;\n\nclass Stub {\n    public void hello(DataField dataField) {\n        FieldName.create(\"DER_\" + dataField.getName().getValue());\n    }\n}";
        String binary = "\"DER_\" + dataField.getName().getValue()";
        J.Binary toTest = CommonTestingUtilities.getBinaryFromClassSource(classTested, binary).orElseThrow(() -> new RuntimeException("Failed to find J.Binary " + binary));
        J retrieved = this.jpmmlVisitor.visitBinary(toTest, CommonTestingUtilities.getExecutionContext(null));
        String expected = "\"DER_\" +dataField.getName()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.Binary.class)).hasToString(expected);
    }

    @Test
    public void visitBinary_FieldNameGetValueString() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.DataField;\n\nclass Stub {\n    public void hello(DataField dataField) {\n        FieldName.create(dataField.getName().getValue() + \"DER_\");\n    }\n}";
        String binary = "dataField.getName().getValue() + \"DER_\"";
        J.Binary toTest = CommonTestingUtilities.getBinaryFromClassSource(classTested, binary).orElseThrow(() -> new RuntimeException("Failed to find J.Binary " + binary));
        J retrieved = this.jpmmlVisitor.visitBinary(toTest, CommonTestingUtilities.getExecutionContext(null));
        String expected = "dataField.getName() + \"DER_\"";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.Binary.class)).hasToString(expected);
    }

    @Test
    public void visitBinary_FieldNameGetValueFieldNameGetValue() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.DataField;\n\nclass Stub {\n    public void hello(DataField dataField) {\n        FieldName.create(dataField.getName().getValue() + dataField.getName().getValue());\n    }\n}";
        String binary = "dataField.getName().getValue() + dataField.getName().getValue()";
        J.Binary toTest = CommonTestingUtilities.getBinaryFromClassSource(classTested, binary).orElseThrow(() -> new RuntimeException("Failed to find J.Binary " + binary));
        J retrieved = this.jpmmlVisitor.visitBinary(toTest, CommonTestingUtilities.getExecutionContext(null));
        String expected = "dataField.getName() +dataField.getName()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.Binary.class)).hasToString(expected);
    }

    @Test
    public void visitMethodInvocation_NumericPredictorGetName() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.regression.NumericPredictor;\n\nclass Stub {\n    public String bye(NumericPredictor numericPredictor) {\n        FieldName fieldName = numericPredictor.getName();\n        return fieldName.getValue();\n    }}";
        String methodTested = "numericPredictor.getName";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation numericPredictor.getName()"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        String expected = "numericPredictor.getField()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
    }

    @Test
    public void visitMethodInvocation_CategoricalPredictorGetName() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.regression.CategoricalPredictor;\n\nclass Stub {\n    public String bye(CategoricalPredictor categoricalPredictor) {\n        FieldName fieldName = categoricalPredictor.getName();\n        return fieldName.getValue();\n    }}";
        String methodTested = "categoricalPredictor.getName";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation categoricalPredictor.getName()"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        String expected = "categoricalPredictor.getField()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
    }

    @Test
    public void visitMethodInvocation_FieldNameCreate() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\n\nclass Stub {\n    public String hello() {\n        System.out.println(FieldName.create(\"OUTPUT_\"));\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String expressionTested = "FieldName.create";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, expressionTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation FieldName.create(\"OUTPUT_\")"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        String expected = "OUTPUT_";
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.Literal.class);
        Assertions.assertThat((Object)((J.Literal)retrieved).getValue()).isEqualTo((Object)expected);
    }

    @Test
    public void visitMethodInvocation_FieldNameCreateWithBinary() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.DataField;\nimport org.dmg.pmml.FieldName;\n\nclass Stub {\n    public String hello(DataField dataField) {\n        System.out.println(FieldName.create(\"OUTPUT_\" + dataField.getName().getValue()));\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String expressionTested = "System.out.println";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, expressionTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation System.out.println(FieldName.create(\"OUTPUT_\" + dataField.getName().getValue()))"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        String expected = "System.out.println(\"OUTPUT_\" +dataField.getName())";
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class);
        Assertions.assertThat((Object)((J.MethodInvocation)retrieved)).hasToString(expected);
    }

    @Test
    public void visitMethodInvocation_AccessFieldName() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.DataType;\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.MiningField;\nimport org.dmg.pmml.mining.MiningModel;\nimport org.dmg.pmml.OpType;\nimport org.dmg.pmml.OutputField;\nimport org.dmg.pmml.Target;\n\nclass Stub {\n    public String bye() {\n         MiningField toReturn = new MiningField(FieldName.create(new String(\"TestingFIeld\")));\n        OutputField toConvert = new OutputField(FieldName.create(\"FIELDNAME\"), OpType.CATEGORICAL, DataType.BOOLEAN);\n        final String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;\n        Target target = new Target();\n        String field = target.getField().getValue();\n        String key = target.getKey().getValue();\n        return name;\n    }}";
        String methodTested = "toConvert.getName().getValue";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation toConvert.getName().getValue"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        String expected = "toConvert.getName()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
        methodTested = "target.getField().getValue";
        toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation target.getField().getValue"));
        Assertions.assertThat((Object)toTest).isNotNull();
        retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        expected = "target.getField()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
        methodTested = "target.getKey().getValue";
        toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation target.getKey().getValue"));
        Assertions.assertThat((Object)toTest).isNotNull();
        retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        expected = "target.getKey()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
    }

    @Test
    public void visitMethodInvocation_FieldNameGetValue() {
        String classTested = "package com.yourorg;\n\nimport java.util.List;\nimport java.util.Objects;\n\nimport org.dmg.pmml.DataField;\nimport org.dmg.pmml.Field;\n\npublic class Stub {\n\n    private List<Field<?>> fields;\n\n    public void bye() {\n        DataField targetDataField = this.fields.stream()\n                .filter(DataField.class::isInstance)\n                .map(DataField.class::cast)\n                .filter(field -> Objects.equals(getTargetFieldName(), field.getName().getValue()))\n                .findFirst().orElse(null);\n    }\n    public String getTargetFieldName() {\n        return \"targetDataFieldName\";\n    }\n}";
        String expressionTested = "field.getName().getValue";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, expressionTested).orElseThrow(() -> new RuntimeException("Failed to find Expression FieldName.create(\"OUTPUT_\")"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        String expected = "field.getName()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
    }

    @Test
    public void visitMethodInvocation_FieldNameGetNameToGetFieldMapped() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.regression.CategoricalPredictor;\n\nclass Stub {\n    public String hello(CategoricalPredictor categoricalPredictor) {\n        FieldName fieldName = categoricalPredictor.getName();\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String methodInvocation = "categoricalPredictor.getName";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation categoricalPredictor.getName()"));
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        String expected = "categoricalPredictor.getField()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
    }

    @Test
    public void visitMethodInvocation_HasFieldNameParameter() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.DataField;\nimport org.dmg.pmml.DerivedField;\nimport java.util.Objects;\n\nclass Stub {\n    public void hello(DataField dataField) {\n        DerivedField toReturn = new DerivedField();\n        toReturn.setName(FieldName.create(\"DER_\" + dataField.getName().getValue()));\n    }\n}";
        String methodInvocation = "toReturn.setName";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to toReturn.setName"));
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitMethodInvocation(toTest, executionContext);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class);
        String expected = "String";
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class);
        Assertions.assertThat((Object)((JavaType)((J.MethodInvocation)retrieved).getMethodType().getParameterTypes().get(0))).hasToString(expected);
    }

    @Test
    public void visitNewClass_FieldNameCreate() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.MiningField;\n\npublic class Stub {\n\n    public String hello() {\n        MiningField toReturn = new MiningField(FieldName.create(new String(\"TestingField\")));\n        return \"Hello from com.yourorg.FooLol!\";\n    }\n\n}";
        String classInstantiated = "org.dmg.pmml.MiningField";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, classInstantiated).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.MiningField"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitNewClass(toTest, executionContext);
        String expected = "new MiningField(new String(\"TestingField\"))";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.NewClass.class)).hasToString(expected);
    }

    @Test
    public void visitNewClass_AccessFieldNameInsideConstructor() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.Target;\n\nclass Stub {\n    public String bye() {\n        Target target = new Target();\n        String name = new String(target.getKey().getValue());\n        return name;\n    }}";
        String classInstantiated = "java.lang.String";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, classInstantiated).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass java.lang.String"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitNewClass(toTest, executionContext);
        String expected = "new String(target.getKey())";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.NewClass.class)).hasToString(expected);
    }

    @Test
    public void visitNewClass_ScoreDistribution() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.ScoreDistribution;\n\npublic class Stub {\n\n    public String hello() {\n        ScoreDistribution scoreDistribution = new ScoreDistribution();\n        return \"Hello from com.yourorg.FooLol!\";\n    }\n\n}";
        String classInstantiated = "org.dmg.pmml.ScoreDistribution";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, classInstantiated).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.ScoreDistribution"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitNewClass(toTest, executionContext);
        String expected = "new ComplexScoreDistribution()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.NewClass.class)).hasToString(expected);
    }

    @Test
    public void visitNewClass_DataDictionary() {
        String classTested = "package com.yourorg;\n\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\n\npublic class Stub {\n\n    public String hello(List<DataField> dataFields) {\n        DataDictionary dataDictionary = new DataDictionary(dataFields);\n        return \"Hello from com.yourorg.FooLol!\";\n    }\n\n}";
        String classInstantiated = "org.dmg.pmml.DataDictionary";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, classInstantiated).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.DataDictionary"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J retrieved = this.jpmmlVisitor.visitNewClass(toTest, executionContext);
        String expected = "new DataDictionary().addDataFields(dataFields.toArray(new org.dmg.pmml.DataField[0]))";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
    }

    @Test
    public void visitVariableDeclarations_AccessFieldNameAsSecondParameter() {
        String classTested = "package com.yourorg;\n\nimport java.util.List;\nimport java.util.Objects;\n\nimport org.dmg.pmml.DataField;\nimport org.dmg.pmml.Field;\n\npublic class Stub {\n\n    private List<Field<?>> fields;\n\n    public void bye() {\n        DataField targetDataField = this.fields.stream()\n                .filter(DataField.class::isInstance)\n                .map(DataField.class::cast)\n                .filter(field -> Objects.equals(getTargetFieldName(), field.getName().getValue()))\n                .findFirst().orElse(null);\n    }\n    public String getTargetFieldName() {\n        return \"targetDataFieldName\";\n    }\n}";
        String variableDeclaration = "DataField targetDataField = ";
        J.VariableDeclarations toTest = CommonTestingUtilities.getVariableDeclarationsFromClassSource(classTested, variableDeclaration).orElseThrow(() -> new RuntimeException("Failed to find J.VariableDeclarations DataField targetDataField = "));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J.VariableDeclarations retrieved = this.jpmmlVisitor.visitVariableDeclarations(toTest, executionContext);
        String expected = "DataField targetDataField = this.fields.stream()\n                .filter(DataField.class::isInstance)\n                .map(DataField.class::cast)\n                .filter(field -> Objects.equals(getTargetFieldName(),field.getName()))\n                .findFirst().orElse(null)";
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).hasToString(expected);
    }

    @Test
    public void visitVariableDeclarations_FieldName() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\n\nclass Stub {\n    public String hello() {\n        FieldName fieldName = FieldName.create(\"OUTPUT_\");\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String variableDeclaration = "FieldName fieldName = FieldName.create(\"OUTPUT_\")";
        J.VariableDeclarations toTest = CommonTestingUtilities.getVariableDeclarationsFromClassSource(classTested, variableDeclaration).orElseThrow(() -> new RuntimeException("Failed to find J.VariableDeclarations FieldName fieldName = FieldName.create(\"OUTPUT_\")"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J.VariableDeclarations retrieved = this.jpmmlVisitor.visitVariableDeclarations(toTest, executionContext);
        String expected = "String fieldName =\"OUTPUT_\"";
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).hasToString(expected);
    }

    @Test
    public void visitVariableDeclarations_CategoricalPredictorGetName() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.regression.CategoricalPredictor;\n\nclass Stub {\n    public String hello(CategoricalPredictor categoricalPredictor) {\n        FieldName fieldName = categoricalPredictor.getName();\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String variableDeclaration = "FieldName fieldName = categoricalPredictor.getName()";
        J.VariableDeclarations toTest = CommonTestingUtilities.getVariableDeclarationsFromClassSource(classTested, variableDeclaration).orElseThrow(() -> new RuntimeException("Failed to find J.VariableDeclarations FieldName fieldName = categoricalPredictor.getName()"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J.VariableDeclarations retrieved = this.jpmmlVisitor.visitVariableDeclarations(toTest, executionContext);
        String expected = "String fieldName = categoricalPredictor.getField()";
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).hasToString(expected);
    }

    @Test
    public void visitVariableDeclarations_NumericPredictorGetName() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.regression.NumericPredictor;\n\nclass Stub {\n    public String hello(NumericPredictor numericPredictor) {\n        FieldName fieldName = numericPredictor.getName();\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String variableDeclaration = "FieldName fieldName = numericPredictor.getName()";
        J.VariableDeclarations toTest = CommonTestingUtilities.getVariableDeclarationsFromClassSource(classTested, variableDeclaration).orElseThrow(() -> new RuntimeException("Failed to find J.VariableDeclarations FieldName fieldName = FieldName.create(\"OUTPUT_\")"));
        Assertions.assertThat((Object)toTest).isNotNull();
        ExecutionContext executionContext = CommonTestingUtilities.getExecutionContext(null);
        J.VariableDeclarations retrieved = this.jpmmlVisitor.visitVariableDeclarations(toTest, executionContext);
        String expected = "String fieldName = numericPredictor.getField()";
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).hasToString(expected);
    }

    @Test
    public void removeFieldNameImport_removed() {
        String classTested = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nimport java.util.List;\nclass FooBar {\n};";
        J.CompilationUnit toTest = CommonTestingUtilities.getCompilationUnitFromClassSource(classTested);
        J.CompilationUnit retrieved = this.jpmmlVisitor.removeFieldNameImport(toTest);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)toTest);
        Assertions.assertThat((List)retrieved.getImports()).isNotEqualTo((Object)toTest.getImports());
        Assertions.assertThat((List)retrieved.getImports()).hasSize(toTest.getImports().size() - 1);
        Assertions.assertThat((boolean)this.jpmmlVisitor.hasFieldNameImport(retrieved)).isFalse();
    }

    @Test
    public void removeFieldNameImport_notRemoved() {
        String classTested = "package com.yourorg;\nimport java.util.List;\nimport org.dmg.pmml.DataField;\nclass FooBar {\n};";
        J.CompilationUnit toTest = CommonTestingUtilities.getCompilationUnitFromClassSource(classTested);
        J.CompilationUnit retrieved = this.jpmmlVisitor.removeFieldNameImport(toTest);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)toTest);
        Assertions.assertThat((List)retrieved.getImports()).isEqualTo((Object)toTest.getImports());
    }

    @Test
    public void hasFieldNameImport_true() {
        String classTested = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nimport java.util.List;\nclass FooBar {\n};";
        J.CompilationUnit toTest = CommonTestingUtilities.getCompilationUnitFromClassSource(classTested);
        Assertions.assertThat((boolean)this.jpmmlVisitor.hasFieldNameImport(toTest)).isTrue();
    }

    @Test
    public void hasFieldNameImport_false() {
        String classTested = "package com.yourorg;\nimport java.util.List;\nimport org.dmg.pmml.DataField;\nclass FooBar {\n};";
        J.CompilationUnit toTest = CommonTestingUtilities.getCompilationUnitFromClassSource(classTested);
        Assertions.assertThat((boolean)this.jpmmlVisitor.hasFieldNameImport(toTest)).isFalse();
    }

    @Test
    public void isFieldNameImport_true() {
        String classTested = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\n};";
        J.Import toTest = CommonTestingUtilities.getImportsFromClassSource(classTested).get(0);
        Assertions.assertThat((boolean)this.jpmmlVisitor.isFieldNameImport(toTest)).isTrue();
    }

    @Test
    public void isFieldNameImport_false() {
        String classTested = "package com.yourorg;\nimport java.util.List;\nclass FooBar {\n};";
        J.Import toTest = CommonTestingUtilities.getImportsFromClassSource(classTested).get(0);
        Assertions.assertThat((boolean)this.jpmmlVisitor.isFieldNameImport(toTest)).isFalse();
    }

    @Test
    public void addMissingMethod_Add() {
        String classTested = "package com.yourorg;\n\n\nclass Stub {\n    public void hello() {\n        System.out.println(\"Hello\");\n    }\n}";
        String className = "Stub";
        J.CompilationUnit cu = CommonTestingUtilities.getCompilationUnitFromClassSource(classTested);
        J.ClassDeclaration toTest = CommonTestingUtilities.getClassDeclarationFromCompilationUnit(cu, className).orElseThrow(() -> new RuntimeException("Failed to find J.ClassDeclaration Stub"));
        Cursor cursor = new Cursor(this.jpmmlVisitor.getCursor(), (Object)cu);
        JavaTemplate requireMiningSchemaTemplate = JavaTemplate.builder(() -> cursor, (String)"    public boolean requireMiningSchema() {\n        return null;\n    }\n").build();
        J.ClassDeclaration retrieved = this.jpmmlVisitor.addMissingMethod(toTest, "requireMiningSchema", requireMiningSchemaTemplate);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)toTest);
        Assertions.assertThat((boolean)this.jpmmlVisitor.methodExists(retrieved, "requireMiningSchema")).isTrue();
    }

    @Test
    public void addMissingMethod_NotAdd() {
        String classTested = "package com.yourorg;\n\n\nclass Stub {\n    public void hello() {\n        System.out.println(\"Hello\");\n    }\n}";
        String className = "Stub";
        J.ClassDeclaration toTest = CommonTestingUtilities.getClassDeclarationFromClassSource(classTested, className).orElseThrow(() -> new RuntimeException("Failed to find J.ClassDeclaration Stub"));
        Assertions.assertThat((Object)this.jpmmlVisitor.addMissingMethod(toTest, "hello", null)).isEqualTo((Object)toTest);
    }

    @Test
    public void methodExists_true() {
        String classTested = "package com.yourorg;\n\n\nclass Stub {\n    public void hello() {\n        System.out.println(\"Hello\");\n    }\n}";
        String className = "Stub";
        J.ClassDeclaration toTest = CommonTestingUtilities.getClassDeclarationFromClassSource(classTested, className).orElseThrow(() -> new RuntimeException("Failed to find J.ClassDeclaration Stub"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.methodExists(toTest, "hello")).isTrue();
    }

    @Test
    public void methodExists_false() {
        String classTested = "package com.yourorg;\n\n\nclass Stub {\n    public void hello() {\n        System.out.println(\"Hello\");\n    }\n}";
        String className = "Stub";
        J.ClassDeclaration toTest = CommonTestingUtilities.getClassDeclarationFromClassSource(classTested, className).orElseThrow(() -> new RuntimeException("Failed to find J.ClassDeclaration Stub"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.methodExists(toTest, "notHello")).isFalse();
    }

    @Test
    public void replaceOriginalToTargetInstantiation_replaced() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.ScoreDistribution;\n\npublic class Stub {\n\n    public String hello() {\n        ScoreDistribution scoreDistribution = new ScoreDistribution();\n        return \"Hello from com.yourorg.FooLol!\";\n    }\n\n}";
        String classInstantiated = "org.dmg.pmml.ScoreDistribution";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, classInstantiated).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.ScoreDistribution"));
        Assertions.assertThat((Object)toTest).isNotNull();
        J.NewClass retrieved = this.jpmmlVisitor.replaceOriginalToTargetInstantiation(toTest);
        String expected = "new ComplexScoreDistribution()";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.NewClass.class)).hasToString(expected);
    }

    @Test
    public void replaceOriginalToTargetInstantiation_notReplaced() {
        String classTested = "package com.yourorg;\nimport org.dmg.pmml.DataField;\nclass FooBar {\nstatic void method() {\n        DataField dataField = new DataField();\n}\n}";
        String instantiatedClass = "org.dmg.pmml.DataField";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, instantiatedClass).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.DataField"));
        Assertions.assertThat((Object)toTest).isNotNull();
        J.NewClass retrieved = this.jpmmlVisitor.replaceOriginalToTargetInstantiation(toTest);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isEqualTo((Object)toTest);
    }

    @Test
    public void replaceInstantiationListRemoved_replaced() {
        String classTested = "package com.yourorg;\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\nclass FooBar {\nstatic void method(List<DataField> dataFields) {\nDataDictionary dataDictionary = new DataDictionary(dataFields);\n}\n}";
        String instantiatedClass = "org.dmg.pmml.DataDictionary";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, instantiatedClass).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.DataDictionary"));
        Assertions.assertThat((Object)toTest).isNotNull();
        Expression retrieved = this.jpmmlVisitor.replaceInstantiationListRemoved(toTest);
        String expected = "new DataDictionary().addDataFields(dataFields.toArray(new org.dmg.pmml.DataField[0]))";
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.MethodInvocation.class)).hasToString(expected);
    }

    @Test
    public void replaceInstantiationListRemoved_notReplaced() {
        String classTested = "package com.yourorg;\nimport org.dmg.pmml.ScoreDistribution;\nclass FooBar {\nstatic void method() {\n        ScoreDistribution scoreDistribution = new ScoreDistribution();\n}\n}";
        String instantiatedClass = "org.dmg.pmml.ScoreDistribution";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, instantiatedClass).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.DataDictionary"));
        Assertions.assertThat((Object)toTest).isNotNull();
        Expression retrieved = this.jpmmlVisitor.replaceInstantiationListRemoved(toTest);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isEqualTo((Object)toTest);
    }

    @Test
    public void getRemovedListTupla_present() {
        String classTested = "package com.yourorg;\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\nclass FooBar {\nstatic void method(List<DataField> dataFields) {\nDataDictionary dataDictionary = new DataDictionary(dataFields);\n}\n}";
        String instantiatedClass = "org.dmg.pmml.DataDictionary";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, instantiatedClass).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.DataDictionary"));
        Assertions.assertThat((Object)toTest).isNotNull();
        Assertions.assertThat((Optional)this.jpmmlVisitor.getRemovedListTupla(toTest)).isPresent();
    }

    @Test
    public void getRemovedListTupla_notPresent() {
        String classTested = "package com.yourorg;\nimport org.dmg.pmml.ScoreDistribution;\nclass FooBar {\nstatic void method() {\n        ScoreDistribution scoreDistribution = new ScoreDistribution();\n}\n}";
        String instantiatedClass = "org.dmg.pmml.ScoreDistribution";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, instantiatedClass).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.ScoreDistribution"));
        Assertions.assertThat((Object)toTest).isNotNull();
        Assertions.assertThat((Optional)this.jpmmlVisitor.getRemovedListTupla(toTest)).isNotPresent();
    }

    @Test
    public void isFieldNameCreate_true() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\n\nclass Stub {\n    public void hello() {\n        System.out.println(FieldName.create(\"OUTPUT_\"));\n    }\n}";
        String expressionTested = "FieldName.create";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, expressionTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation FieldName.create(\"OUTPUT_\")"));
        Assertions.assertThat((Object)toTest).isNotNull();
        Assertions.assertThat((boolean)this.jpmmlVisitor.isFieldNameCreate(toTest)).isTrue();
    }

    @Test
    public void isFieldNameCreate_false() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\n\nclass Stub {\n    public void hello() {\n        System.out.println(FieldName.create(\"OUTPUT_\"));\n    }\n}";
        String expressionTested = "System.out.println";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, expressionTested).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation System.out.println(FieldName.create(\"OUTPUT_\"))"));
        Assertions.assertThat((Object)toTest).isNotNull();
        Assertions.assertThat((boolean)this.jpmmlVisitor.isFieldNameCreate(toTest)).isFalse();
    }

    @Test
    public void hasFieldNameParameter_true() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.DataField;\nimport org.dmg.pmml.DerivedField;\nimport java.util.Objects;\n\nclass Stub {\n    public void hello(DataField dataField) {\n        DerivedField toReturn = new DerivedField();\n        toReturn.setName(FieldName.create(\"DER_\" + dataField.getName().getValue()));\n    }\n}";
        String methodInvocation = "toReturn.setName";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to toReturn.setName"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.hasFieldNameParameter(toTest)).isTrue();
    }

    @Test
    public void hasFieldNameParameter_false() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.DataField;\nimport java.util.Objects;\n\nclass Stub {\n    public void hello(DataField field) {\n        Objects.equals(null, field.getName().getValue());\n    }\n}";
        String methodInvocation = "Objects.equals";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find Objects.equals"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.hasFieldNameParameter(toTest)).isFalse();
        classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport java.util.Objects;\n\nclass Stub {\n    public void hello(FieldName fieldName) {\n        Objects.equals(null, fieldName.getValue());\n    }\n}";
        toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation numericPredictor.getName()"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.hasFieldNameParameter(toTest)).isFalse();
    }

    @Test
    public void isFieldNameGetNameToGetFieldMapped_true() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.regression.CategoricalPredictor;\n\nclass Stub {\n    public String hello(CategoricalPredictor categoricalPredictor) {\n        FieldName fieldName = categoricalPredictor.getName();\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String methodInvocation = "categoricalPredictor.getName";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation categoricalPredictor.getName()"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.isFieldNameGetNameToGetFieldMapped(toTest)).isTrue();
        classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.regression.NumericPredictor;\n\nclass Stub {\n    public String hello(NumericPredictor numericPredictor) {\n        FieldName fieldName = numericPredictor.getName();\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        methodInvocation = "numericPredictor.getName";
        toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation numericPredictor.getName()"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.isFieldNameGetNameToGetFieldMapped(toTest)).isTrue();
    }

    @Test
    public void isFieldNameGetNameToGetFieldMapped_false() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\nimport org.dmg.pmml.DataField;\n\nclass Stub {\n    public String hello(DataField dataField) {\n        FieldName fieldName = dataField.getName();\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String methodInvocation = "dataField.getName";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation dataField.getName()"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.isFieldNameGetNameToGetFieldMapped(toTest)).isFalse();
    }

    @Test
    public void useFieldNameGetValue_true() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.DataField;\n\nclass Stub {\n    public String hello(DataField field) {\n        System.out.println(field.getName().getValue());\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String methodInvocation = "field.getName().getValue";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation field.getName().getValue()"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.useFieldNameGetValue(toTest)).isTrue();
        classTested = "package com.yourorg;\n\nimport org.dmg.pmml.FieldName;\n\nclass Stub {\n    public String hello(FieldName field) {\n        System.out.println(field.getValue());\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        methodInvocation = "field.getValue";
        toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation field.getValue()"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.useFieldNameGetValue(toTest)).isTrue();
    }

    @Test
    public void useFieldNameGetValue_false() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.DataField;\n\nclass Stub {\n    public String hello(DataField field) {\n        System.out.println(field.getName().getValue());\n        return \"Hello from com.yourorg.FooBar!\";\n    }\n}";
        String methodInvocation = "System.out.println";
        J.MethodInvocation toTest = CommonTestingUtilities.getMethodInvocationFromClassSource(classTested, methodInvocation).orElseThrow(() -> new RuntimeException("Failed to find J.MethodInvocation System.out.println()"));
        Assertions.assertThat((boolean)this.jpmmlVisitor.useFieldNameGetValue(toTest)).isFalse();
    }

    @Test
    public void toMigrate_False() {
        String classTested = "package com.yourorg;\nimport java.util.List;\nimport java.util.Map;\nclass FooBar {\n};";
        List<J.Import> toTest = CommonTestingUtilities.getImportsFromClassSource(classTested);
        Assertions.assertThat((boolean)this.jpmmlVisitor.toMigrate(toTest)).isFalse();
        Assertions.assertThat(toTest).hasSize(2);
    }

    @Test
    public void toMigrate_True() {
        String classTested = "package com.yourorg;\nimport java.util.List;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\n};";
        List<J.Import> toTest = CommonTestingUtilities.getImportsFromClassSource(classTested);
        Assertions.assertThat((boolean)this.jpmmlVisitor.toMigrate(toTest)).isTrue();
        classTested = "package com.yourorg;\nimport java.util.List;\nimport org.jpmml.model.cells.InputCell;\nclass FooBar {\n};";
        toTest = CommonTestingUtilities.getImportsFromClassSource(classTested);
        Assertions.assertThat((boolean)this.jpmmlVisitor.toMigrate(toTest)).isTrue();
        classTested = "package com.yourorg;\nimport java.util.List;\nimport org.jpmml.model.cells.InputCell;\nimport org.jpmml.model.cells.InputCell;\nclass FooBar {\n};";
        toTest = CommonTestingUtilities.getImportsFromClassSource(classTested);
        Assertions.assertThat((boolean)this.jpmmlVisitor.toMigrate(toTest)).isTrue();
    }

    @Test
    public void updateMethodToTargetInstantiatedType() {
        JavaType.Method toTest = new JavaType.Method(null, 1025L, (JavaType.FullyQualified)this.jpmmlVisitor.originalInstantiatedType, "toArray", (JavaType)this.jpmmlVisitor.originalInstantiatedType, Collections.emptyList(), Collections.emptyList(), null, null);
        JavaType.Method retrieved = this.jpmmlVisitor.updateMethodToTargetInstantiatedType(toTest);
        Assertions.assertThat((Object)retrieved.getDeclaringType()).isEqualTo((Object)this.jpmmlVisitor.targetInstantiatedType);
        Assertions.assertThat((Object)retrieved.getReturnType()).isEqualTo((Object)this.jpmmlVisitor.targetInstantiatedType);
    }

    @Test
    public void updateTypeTreeToTargetInstantiatedType() {
        String classTested = "package com.yourorg;\n\nimport org.dmg.pmml.ScoreDistribution;\n\npublic class Stub {\n\n    public void hello() {\n        ScoreDistribution scoreDistribution = new ScoreDistribution();\n    }\n\n}";
        String classInstantiated = "org.dmg.pmml.ScoreDistribution";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, classInstantiated).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.ScoreDistribution"));
        Assertions.assertThat((Object)toTest).isNotNull();
        TypeTree retrieved = this.jpmmlVisitor.updateTypeTreeToTargetInstantiatedType(toTest);
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(J.Identifier.class);
        Assertions.assertThat((Object)retrieved.getType()).isEqualTo((Object)this.jpmmlVisitor.targetInstantiatedType);
        Assertions.assertThat((String)((J.Identifier)retrieved).getSimpleName()).isEqualTo(((JavaType.ShallowClass)this.jpmmlVisitor.targetInstantiatedType).getClassName());
    }

    @Test
    public void removedListaTupla_getJMethod() {
        JPMMLVisitor.RemovedListTupla removedListTupla = new JPMMLVisitor.RemovedListTupla("addDataFields", JavaType.buildType((String)"org.dmg.pmml.DataField"));
        String classTested = "package com.yourorg;\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\nclass FooBar {\nstatic void method(List<DataField> dataFields) {\nDataDictionary dataDictionary = new DataDictionary(dataFields);\n}\n}";
        String classInstantiated = "org.dmg.pmml.DataDictionary";
        J.NewClass toTest = CommonTestingUtilities.getNewClassFromClassSource(classTested, classInstantiated).orElseThrow(() -> new RuntimeException("Failed to find J.NewClass org.dmg.pmml.DataDictionary"));
        J.MethodInvocation retrieved = removedListTupla.getJMethod(toTest);
        String expected = "new DataDictionary().addDataFields(dataFields.toArray(new org.dmg.pmml.DataField[0]))";
        ((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).hasToString(expected);
    }
}

