/*
 * Decompiled with CFR 0.152.
 */
package org.kie.openrewrite.recipe.jpmml;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.kie.openrewrite.recipe.jpmml.JPMMLVisitor;
import org.openrewrite.Parser;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.Java11Parser;
import org.openrewrite.java.JavaParser;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

public class JPMMLRecipeTest
implements RewriteTest {
    private static final String JPMML_RECIPE_NAME = "org.kie.openrewrite.recipe.jpmml.JPMMLRecipe";

    public void defaults(RecipeSpec spec) {
        List paths = JavaParser.runtimeClasspath();
        Path newJpmmlModel = JPMMLVisitor.getNewJPMMLModelPath();
        paths.add(newJpmmlModel);
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/rewrite/rewrite.yml");){
            assert (inputStream != null);
            spec.recipe(inputStream, new String[]{JPMML_RECIPE_NAME});
            spec.parser((Parser.Builder)((Java11Parser.Builder)Java11Parser.builder().classpath((Collection)paths)).logCompilationWarningsAndErrors(true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void changeInstantiation_DataDictionary() {
        String before = "package com.yourorg;\n\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\n\npublic class Stub {\n\n    public String hello(List<DataField> dataFields) {\n        new DataDictionary(dataFields);\n        return \"Hello from com.yourorg.FooLol!\";\n    }\n\n}";
        String after = "package com.yourorg;\n\nimport java.util.List;\nimport org.dmg.pmml.DataDictionary;\nimport org.dmg.pmml.DataField;\n\npublic class Stub {\n\n    public String hello(List<DataField> dataFields) {\n        new DataDictionary().addDataFields(dataFields.toArray(new org.dmg.pmml.DataField[0]));\n        return \"Hello from com.yourorg.FooLol!\";\n    }\n\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void addMissingMethods_Model() {
        String before = "package com.yourorg;\n\nimport org.dmg.pmml.LocalTransformations;\nimport org.dmg.pmml.MathContext;\nimport org.dmg.pmml.MiningFunction;\nimport org.dmg.pmml.MiningSchema;\nimport org.dmg.pmml.Model;\nimport org.dmg.pmml.Visitor;\nimport org.dmg.pmml.VisitorAction;\n\npublic class SubModel extends Model {\n    @Override\n    public String getModelName() {\n        return null;\n    }\n\n    @Override\n    public Model setModelName(String modelName) {\n        return null;\n    }\n\n    @Override\n    public MiningFunction getMiningFunction() {\n        return null;\n    }\n\n    @Override\n    public Model setMiningFunction(MiningFunction miningFunction) {\n        return null;\n    }\n\n    @Override\n    public String getAlgorithmName() {\n        return null;\n    }\n\n    @Override\n    public Model setAlgorithmName(String algorithmName) {\n        return null;\n    }\n\n    @Override\n    public boolean isScorable() {\n        return false;\n    }\n\n    @Override\n    public Model setScorable(Boolean scorable) {\n        return null;\n    }\n\n    @Override\n    public MathContext getMathContext() {\n        return null;\n    }\n\n    @Override\n    public Model setMathContext(MathContext mathContext) {\n        return null;\n    }\n\n    @Override\n    public MiningSchema getMiningSchema() {\n        return null;\n    }\n\n    @Override\n    public Model setMiningSchema(MiningSchema miningSchema) {\n        return null;\n    }\n\n    @Override\n    public LocalTransformations getLocalTransformations() {\n        return null;\n    }\n\n    @Override\n    public Model setLocalTransformations(LocalTransformations localTransformations) {\n        return null;\n    }\n\n    @Override\n    public VisitorAction accept(Visitor visitor) {\n        return null;\n    }\n}\n";
        String after = "package com.yourorg;\n\nimport org.dmg.pmml.LocalTransformations;\nimport org.dmg.pmml.MathContext;\nimport org.dmg.pmml.MiningFunction;\nimport org.dmg.pmml.MiningSchema;\nimport org.dmg.pmml.Model;\nimport org.dmg.pmml.Visitor;\nimport org.dmg.pmml.VisitorAction;\n\npublic class SubModel extends Model {\n    @Override\n    public String getModelName() {\n        return null;\n    }\n\n    @Override\n    public Model setModelName(String modelName) {\n        return null;\n    }\n\n    @Override\n    public MiningFunction getMiningFunction() {\n        return null;\n    }\n\n    @Override\n    public Model setMiningFunction(MiningFunction miningFunction) {\n        return null;\n    }\n\n    @Override\n    public String getAlgorithmName() {\n        return null;\n    }\n\n    @Override\n    public Model setAlgorithmName(String algorithmName) {\n        return null;\n    }\n\n    @Override\n    public boolean isScorable() {\n        return false;\n    }\n\n    @Override\n    public Model setScorable(Boolean scorable) {\n        return null;\n    }\n\n    @Override\n    public MathContext getMathContext() {\n        return null;\n    }\n\n    @Override\n    public Model setMathContext(MathContext mathContext) {\n        return null;\n    }\n\n    @Override\n    public MiningSchema getMiningSchema() {\n        return null;\n    }\n\n    @Override\n    public Model setMiningSchema(MiningSchema miningSchema) {\n        return null;\n    }\n\n    @Override\n    public LocalTransformations getLocalTransformations() {\n        return null;\n    }\n\n    @Override\n    public Model setLocalTransformations(LocalTransformations localTransformations) {\n        return null;\n    }\n\n    @Override\n    public VisitorAction accept(Visitor visitor) {\n        return null;\n    }\n\n    @Override\n    public MiningFunction requireMiningFunction() {\n        return null;\n    }\n\n    @Override\n    public MiningSchema requireMiningSchema() {\n        return null;\n    }\n}\n";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeImports() {
        String before = "package com.yourorg;\nimport org.jpmml.model.inlinetable.InputCell;\nclass FooBar {\nstatic public void method() {\nInputCell input = null;\n}\n}";
        String after = "package com.yourorg;\n\nimport org.jpmml.model.cells.InputCell;\n\nclass FooBar {\nstatic public void method() {\nInputCell input = null;\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeFieldNameVariableDeclaration() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\nFieldName fieldName = FieldName.create(\"OUTPUT_\");\n}\n}";
        String after = "package com.yourorg;\nclass FooBar {\nstatic public void method() {\n String fieldName =\"OUTPUT_\";\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeFieldNameVariableNull() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\nFieldName fieldName = null;\n}\n}";
        String after = "package com.yourorg;\nclass FooBar {\nstatic public void method() {\n String fieldName = null;\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void removeFieldNameCreate() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.FieldName;\nclass FooBar {\nstatic public void method() {\nSystem.out.println(FieldName.create(\"OUTPUT_\"));\n}\n}";
        String after = "package com.yourorg;\nclass FooBar {\nstatic public void method() {\nSystem.out.println(\"OUTPUT_\");\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void removeFieldNameGetValue() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.OutputField;\nclass FooBar {\nstatic public void method(OutputField toConvert) {\nfinal String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;\n}\n}";
        String after = "package com.yourorg;\nimport org.dmg.pmml.OutputField;\nclass FooBar {\nstatic public void method(OutputField toConvert) {\nfinal String name = toConvert.getName() != null ?toConvert.getName() : null;\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }

    @Test
    public void changeInstantiation_ScoreDistribution() {
        String before = "package com.yourorg;\nimport org.dmg.pmml.ScoreDistribution;\nclass FooBar {\nstatic public void method() {\nScoreDistribution toReturn = new ScoreDistribution();\n}\n}";
        String after = "package com.yourorg;\nimport org.dmg.pmml.ComplexScoreDistribution;\nimport org.dmg.pmml.ScoreDistribution;\n\nclass FooBar {\nstatic public void method() {\nScoreDistribution toReturn = new ComplexScoreDistribution();\n}\n}";
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)before, (String)after)});
    }
}

