/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.kie.server.springboot.samples.KieServerApplication;
import org.springframework.boot.context.embedded.LocalServerPort;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@Ignore(value="This test requires keycloak to be setup and present as defined in application.properties, see readme")
@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={KieServerApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
public class KieServerTest {
    static final String ARTIFACT_ID = "evaluation";
    static final String GROUP_ID = "org.jbpm.test";
    static final String VERSION = "1.0.0";
    @LocalServerPort
    private int port;
    private String user = "john";
    private String password = "john1";
    private String containerId = "evaluation";
    private String processId = "evaluation";
    private KieServicesClient kieServicesClient;

    @BeforeClass
    public static void generalSetup() {
        KieServices ks = KieServices.Factory.get();
        org.kie.api.builder.ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("../kjars/evaluation/jbpm-module.jar");
        File pom = new File("../kjars/evaluation/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
    }

    @Before
    public void setup() {
        ReleaseId releaseId = new ReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        String serverUrl = "http://localhost:" + this.port + "/rest/server";
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)serverUrl, (String)this.user, (String)this.password);
        configuration.setTimeout(60000L);
        configuration.setMarshallingFormat(MarshallingFormat.JSON);
        this.kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        KieContainerResource resource = new KieContainerResource(this.containerId, releaseId);
        this.kieServicesClient.createContainer(this.containerId, resource);
    }

    @After
    public void cleanup() {
        this.kieServicesClient.disposeContainer(this.containerId);
    }

    @Test
    public void testProcessStartAndAbort() {
        QueryServicesClient queryClient = (QueryServicesClient)this.kieServicesClient.getServicesClient(QueryServicesClient.class);
        List processes = queryClient.findProcesses(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)processes.size());
        ProcessServicesClient processClient = (ProcessServicesClient)this.kieServicesClient.getServicesClient(ProcessServicesClient.class);
        ProcessDefinition definition = processClient.getProcessDefinition(this.containerId, this.processId);
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)this.processId, (Object)definition.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john");
        params.put("reason", "test on spring boot");
        Long processInstanceId = processClient.startProcess(this.containerId, this.processId, params);
        Assert.assertNotNull((Object)processInstanceId);
        List instances = queryClient.findProcessInstances(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)instances.size());
        processClient.abortProcessInstance(this.containerId, processInstanceId);
        ProcessInstance processInstance = queryClient.findProcessInstanceById(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)3L, (long)processInstance.getState().intValue());
    }

    @Test
    public void testProcessStartAndWorkOnUserTask() {
        QueryServicesClient queryClient = (QueryServicesClient)this.kieServicesClient.getServicesClient(QueryServicesClient.class);
        List processes = queryClient.findProcesses(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)processes.size());
        ProcessServicesClient processClient = (ProcessServicesClient)this.kieServicesClient.getServicesClient(ProcessServicesClient.class);
        ProcessDefinition definition = processClient.getProcessDefinition(this.containerId, this.processId);
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)this.processId, (Object)definition.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john");
        params.put("reason", "test on spring boot");
        Long processInstanceId = processClient.startProcess(this.containerId, this.processId, params);
        Assert.assertNotNull((Object)processInstanceId);
        UserTaskServicesClient taskClient = (UserTaskServicesClient)this.kieServicesClient.getServicesClient(UserTaskServicesClient.class);
        List tasks = taskClient.findTasksAssignedAsPotentialOwner(this.user, Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)tasks.size());
        Long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskClient.startTask(this.containerId, taskId, this.user);
        taskClient.completeTask(this.containerId, taskId, this.user, null);
        List instances = queryClient.findProcessInstances(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)instances.size());
        tasks = taskClient.findTasksAssignedAsPotentialOwner(this.user, Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)tasks.size());
        processClient.abortProcessInstance(this.containerId, processInstanceId);
        ProcessInstance processInstance = queryClient.findProcessInstanceById(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)3L, (long)processInstance.getState().intValue());
    }
}

