/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples.utils;

import com.github.dockerjava.api.DockerClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer> {
    private static Logger logger = LoggerFactory.getLogger(KeycloakContainer.class);
    public static final String KEYCLOAK_ADMIN_USER = "admin";
    public static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_AUTH_PATH = "/auth";
    private static final String KEYCLOAK_IMAGE = System.getProperty("keycloak.image");
    private static final String KEYCLOAK_VERSION = System.getProperty("keycloak.version");
    private static final int KEYCLOAK_PORT_HTTP = Integer.getInteger("keycloak.http.port");

    public KeycloakContainer() {
        this(KeycloakContainer.findImage());
    }

    public KeycloakContainer(String dockerImage) {
        super(dockerImage);
        this.withExposedPorts(new Integer[]{KEYCLOAK_PORT_HTTP});
    }

    protected void configure() {
        this.withEnv("KEYCLOAK_USER", "admin");
        this.withEnv("KEYCLOAK_PASSWORD", "admin");
    }

    public String getAuthServerUrl() {
        return String.format("http://%s:%s%s", this.getContainerIpAddress(), this.getMappedPort(KEYCLOAK_PORT_HTTP), KEYCLOAK_AUTH_PATH);
    }

    private static String findImage() {
        DockerClient client = DockerClientFactory.instance().client();
        String targetImage = KEYCLOAK_IMAGE + ":" + KEYCLOAK_VERSION;
        if (!((List)client.listImagesCmd().withImageNameFilter(targetImage).exec()).isEmpty()) {
            logger.info("Found '{}' image, using it", (Object)targetImage);
            return targetImage;
        }
        logger.info("Not Found '{}' image, using latest", (Object)targetImage);
        return KEYCLOAK_IMAGE + ":latest";
    }
}

