/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime.rule;

import java.util.Collection;
import java.util.NoSuchElementException;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

public interface EntryPoint {
    public String getEntryPointId();

    public FactHandle insert(Object var1);

    public void retract(FactHandle var1);

    public void delete(FactHandle var1);

    public void delete(FactHandle var1, FactHandle.State var2);

    public void update(FactHandle var1, Object var2);

    public void update(FactHandle var1, Object var2, String ... var3);

    public FactHandle getFactHandle(Object var1);

    public Object getObject(FactHandle var1);

    public Collection<? extends Object> getObjects();

    public Collection<? extends Object> getObjects(ObjectFilter var1);

    default public <T> Collection<T> getInstancesOf(Class<T> clazz) {
        return this.getObjects(new ClassObjectFilter(clazz));
    }

    default public <T> T getSingleInstanceOf(Class<T> clazz) {
        Collection<? extends Object> ts = this.getObjects(new ClassObjectFilter(clazz));
        int size = ts.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        if (size > 1) {
            throw new IllegalStateException("Found " + size + " instances instead of the expected single one");
        }
        return (T)ts.iterator().next();
    }

    public <T extends FactHandle> Collection<T> getFactHandles();

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter var1);

    public long getFactCount();
}

