/*
 * Decompiled with CFR 0.152.
 */
package org.kie;

import java.io.File;
import org.kie.builder.KieBuilder;
import org.kie.builder.KieFileSystem;
import org.kie.builder.KieModuleModel;
import org.kie.builder.KieRepository;
import org.kie.builder.KieScanner;
import org.kie.builder.ReleaseId;
import org.kie.command.KieCommands;
import org.kie.io.KieResources;
import org.kie.logger.KieLoggers;
import org.kie.marshalling.KieMarshallers;
import org.kie.persistence.jpa.KieStoreServices;
import org.kie.runtime.KieContainer;

public interface KieServices {
    public KieResources getResources();

    public KieRepository getRepository();

    public KieCommands getCommands();

    public KieMarshallers getMarshallers();

    public KieLoggers getLoggers();

    public KieStoreServices getStoreServices();

    public KieContainer getKieClasspathContainer();

    public KieContainer newKieContainer(ReleaseId var1);

    public KieScanner newKieScanner(KieContainer var1);

    public KieBuilder newKieBuilder(File var1);

    public KieBuilder newKieBuilder(KieFileSystem var1);

    public ReleaseId newReleaseId(String var1, String var2, String var3);

    public KieFileSystem newKieFileSystem();

    public KieModuleModel newKieModuleModel();

    public static class Factory {
        private static KieServices INSTANCE;

        public static KieServices get() {
            return INSTANCE;
        }

        static {
            try {
                INSTANCE = (KieServices)Class.forName("org.kie.builder.impl.KieServicesImpl").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instance KieServices", e);
            }
        }
    }
}

