/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kie.api.Service;
import org.kie.api.internal.utils.ServiceDiscoveryImpl;
import org.kie.api.internal.utils.ServiceUtil;

public interface ServiceRegistry
extends Service {
    public static <T> T getService(Class<T> cls) {
        return ServiceRegistry.getInstance().get(cls);
    }

    public static ServiceRegistry getInstance() {
        return ServiceRegistryHolder.serviceRegistry;
    }

    public <T> T get(Class<T> var1);

    public <T> List<T> getAll(Class<T> var1);

    public static boolean isSupported(Class<?> clazz) {
        return ServiceRegistry.getInstance().get(clazz) != null;
    }

    public static <R, A> Optional<R> ifSupported(Class<A> clazz, Function<A, R> executed) {
        return ServiceRegistry.isSupported(clazz) ? Optional.of(executed.apply(ServiceRegistry.getInstance().get(clazz))) : Optional.empty();
    }

    public static class Impl
    implements ServiceRegistry {
        private static final String DYNAMIC_IMPL = "org.drools.dynamic.DynamicServiceRegistrySupplier";
        private static final String STATIC_IMPL = "org.drools.statics.StaticServiceRegistrySupplier";
        private static Supplier<ServiceRegistry> supplier;
        private Map<String, List<Object>> registry = ServiceDiscoveryImpl.getInstance().getServices();

        public synchronized void reset() {
            ServiceDiscoveryImpl.getInstance().reset();
        }

        public synchronized void reload() {
            this.registry = ServiceDiscoveryImpl.getInstance().getServices();
        }

        @Override
        public <T> T get(Class<T> cls) {
            for (T service : this.getAll(cls)) {
                if (!cls.isInstance(service)) continue;
                return service;
            }
            return null;
        }

        @Override
        public <T> List<T> getAll(Class<T> cls) {
            return this.registry.getOrDefault(cls.getCanonicalName(), Collections.emptyList());
        }

        public static ServiceRegistry getServiceRegistry() {
            if (supplier == null) {
                supplier = (Supplier)ServiceUtil.instanceFromNames(DYNAMIC_IMPL, STATIC_IMPL);
            }
            return supplier.get();
        }

        public static void setSupplier(Supplier<ServiceRegistry> supplier) {
            Impl.supplier = supplier;
        }
    }

    public static class ServiceRegistryHolder {
        private static ServiceRegistry serviceRegistry = Impl.getServiceRegistry();
    }
}

