/*
 * Copyright 2010 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.api.runtime;

import java.util.Collection;
import java.util.Map;

/**
 * <p>
 * Contains the results for the BatchExecution Command. If the identifier is reference the results of a query, you'll need to cast the value to
 * QueryResults.
 * </p>
 */
public interface ExecutionResults {

    Collection<String> getIdentifiers();

    Object getValue(String identifier);

    Object getFactHandle(String identifier);

    Map<String, Object> getResults();

    void setResult(String identifier, Object result);

}
