/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.aries.blueprint.KieBlueprintContainer;
import org.kie.aries.blueprint.factorybeans.KieListenerAdaptor;
import org.kie.aries.blueprint.mocks.MockAgendaEventListener;
import org.kie.aries.blueprint.mocks.MockProcessEventListener;
import org.kie.aries.blueprint.mocks.MockWorkingMemoryEventListener;

public class KieBlueprintListenerTests {
    static BlueprintContainerImpl container = null;

    @BeforeClass
    public static void setup() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(KieBlueprintListenerTests.class.getResource("/org/kie/aries/blueprint/listeners.xml"));
        container = new KieBlueprintContainer(ClassLoader.getSystemClassLoader(), urls);
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)container.getComponentInstance("drl_kiesample");
        System.out.println(kbase);
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("statelessWithGroupedListeners");
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testEventListenersGroup() throws Exception {
        List listeners = (List)container.getComponentInstance("debugListeners");
        Assert.assertNotNull((Object)listeners);
        for (KieListenerAdaptor obj : listeners) {
            Assert.assertNotNull((Object)obj.getObjectRef());
        }
    }

    @Test
    public void testStatelessRefWMEventListener() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("ksession1");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getWorkingMemoryEventListeners().size());
        boolean mockWMEventListenerFound = false;
        for (WorkingMemoryEventListener listener : ksession.getWorkingMemoryEventListeners()) {
            if (!(listener instanceof MockWorkingMemoryEventListener)) continue;
            mockWMEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockWMEventListenerFound);
    }

    @Test
    public void testStatelessRefAgendaEventListener() throws Exception {
        StatelessKieSession kSession = (StatelessKieSession)container.getComponentInstance("ksession1");
        Assert.assertTrue((kSession.getAgendaEventListeners().size() > 0 ? 1 : 0) != 0);
        boolean mockAgendaEventListenerFound = false;
        for (AgendaEventListener listener : kSession.getAgendaEventListeners()) {
            if (!(listener instanceof MockAgendaEventListener)) continue;
            mockAgendaEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockAgendaEventListenerFound);
    }

    @Test
    public void testStatelessRefProcessEventListener() throws Exception {
        StatelessKieSession kSession = (StatelessKieSession)container.getComponentInstance("ksession1");
        Assert.assertTrue((kSession.getProcessEventListeners().size() > 0 ? 1 : 0) != 0);
        boolean mockProcessEventListenerFound = false;
        for (ProcessEventListener listener : kSession.getProcessEventListeners()) {
            if (!(listener instanceof MockProcessEventListener)) continue;
            mockProcessEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockProcessEventListenerFound);
    }

    @Test
    public void testStatelessWMEventListener() throws Exception {
        KieSession ksession = (KieSession)container.getComponentInstance("ksession99");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getWorkingMemoryEventListeners().size());
        boolean mockWMEventListenerFound = false;
        for (WorkingMemoryEventListener listener : ksession.getWorkingMemoryEventListeners()) {
            if (!(listener instanceof MockWorkingMemoryEventListener)) continue;
            mockWMEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockWMEventListenerFound);
    }

    @Test
    public void testStatefulAgendaEventListener() throws Exception {
        KieSession kSession = (KieSession)container.getComponentInstance("ksession99");
        Assert.assertTrue((kSession.getAgendaEventListeners().size() > 0 ? 1 : 0) != 0);
        boolean mockAgendaEventListenerFound = false;
        for (AgendaEventListener listener : kSession.getAgendaEventListeners()) {
            if (!(listener instanceof MockAgendaEventListener)) continue;
            mockAgendaEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockAgendaEventListenerFound);
    }

    @Test
    public void testStatefulProcessEventListener() throws Exception {
        KieSession kSession = (KieSession)container.getComponentInstance("ksession99");
        Assert.assertTrue((kSession.getProcessEventListeners().size() > 0 ? 1 : 0) != 0);
        boolean mockProcessEventListenerFound = false;
        for (ProcessEventListener listener : kSession.getProcessEventListeners()) {
            if (!(listener instanceof MockProcessEventListener)) continue;
            mockProcessEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockProcessEventListenerFound);
    }

    @Test
    public void testEventListenersStandAlone() throws Exception {
        Object obj = container.getComponentInstance("mock-wm-listener");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof MockWorkingMemoryEventListener));
        obj = container.getComponentInstance("mock-agenda-listener");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof MockAgendaEventListener));
        obj = container.getComponentInstance("mock-process-listener");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof MockProcessEventListener));
    }

    @AfterClass
    public static void tearDown() {
        container.destroy();
    }
}

