/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.net.URL;
import java.util.ArrayList;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.aries.blueprint.KieBlueprintContainer;
import org.kie.aries.blueprint.beans.Person;
import org.osgi.service.blueprint.container.NoSuchComponentException;

@Ignore(value="Add when org.apache.aries.blueprint.noosgi 1.0.1 is released")
public class KieBlueprintBasicTest {
    static BlueprintContainerImpl container = null;

    @BeforeClass
    public static void setup() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(KieBlueprintBasicTest.class.getResource("/org/kie/aries/blueprint/basics.xml"));
        container = new KieBlueprintContainer(ClassLoader.getSystemClassLoader(), urls);
    }

    @Test
    public void testReleaseId() throws Exception {
        Object obj = container.getComponentInstance("dummyReleaseId");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof ReleaseId));
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)container.getComponentInstance("drl_kiesample");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testKieContainer() throws Exception {
        KieContainer kieContainer = (KieContainer)container.getComponentInstance("defaultContainer");
        Assert.assertNotNull((Object)kieContainer);
    }

    @Test
    public void testKieStore() throws Exception {
        KieStoreServices sampleKstore = (KieStoreServices)container.getComponentInstance("sampleKstore");
        Assert.assertNotNull((Object)sampleKstore);
    }

    @Test
    public void testKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("ksession9");
        System.out.println(ksession);
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKieSessionRef() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("ksession1");
        System.out.println(ksession);
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testInvalidKieSessionRef() throws Exception {
        try {
            StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("should-fail-ksession1");
            Assert.assertNull((Object)ksession);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NoSuchComponentException));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testKSessionExecution() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("ksession1");
        Assert.assertNotNull((Object)ksession);
        Person person = (Person)container.getComponentInstance("person1");
        Assert.assertNotNull((Object)person);
        Assert.assertFalse((boolean)person.isHappy());
        ksession.execute((Object)person);
        Assert.assertTrue((boolean)person.isHappy());
    }

    @Test
    public void testKieModule() throws Exception {
        Object obj = container.getComponentInstance("basics");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof KieModuleModel));
    }

    @AfterClass
    public static void tearDown() {
        container.destroy();
    }
}

