/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.net.URL;
import java.util.ArrayList;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.drools.core.base.CalendarsImpl;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.aries.blueprint.KieBlueprintContainer;
import org.kie.aries.blueprint.mocks.MockEntityManager;
import org.kie.aries.blueprint.mocks.MockJpaTransactionManager;
import org.kie.aries.blueprint.mocks.MockObjectMarshallingStrategy;
import org.kie.aries.blueprint.tests.KieBlueprintListenerTest;

@Ignore(value="Add when org.apache.aries.blueprint.noosgi 1.0.1 is released")
public class KieBlueprintEnvironmentTest {
    static BlueprintContainerImpl container = null;

    @BeforeClass
    public static void runBeforeClass() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(KieBlueprintListenerTest.class.getResource("/org/kie/aries/blueprint/environment.xml"));
        container = new KieBlueprintContainer(ClassLoader.getSystemClassLoader(), urls);
    }

    @Test
    public void testCtxNotNull() throws Exception {
        Assert.assertNotNull((Object)container);
    }

    @Test
    public void testEnvRef() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-env");
        Assert.assertNotNull((Object)environment);
    }

    @Test
    public void testEnvRefTransManager() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-env");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.transaction.TransactionManager"));
        Assert.assertTrue((boolean)(environment.get("org.kie.transaction.TransactionManager") instanceof MockJpaTransactionManager));
    }

    @Test
    public void testEnvRefEMF() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-env");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        Assert.assertTrue((boolean)(environment.get("org.kie.api.persistence.jpa.EntityManagerFactory") instanceof MockEntityManager));
    }

    @Test
    public void testEnvRefGlobals() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-env");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.Globals"));
        Assert.assertTrue((boolean)(environment.get("org.kie.Globals") instanceof MapGlobalResolver));
    }

    @Test
    public void testEnvRefCalendars() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-env");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.api.time.Calendars"));
        Assert.assertTrue((boolean)(environment.get("org.kie.api.time.Calendars") instanceof CalendarsImpl));
    }

    @Test
    public void testEmptyEnvRef() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-empty-env");
        Assert.assertNotNull((Object)environment);
    }

    @Test
    public void testEnvCustomMarshallerRef() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-env-custom-marshaller-ref");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)1L, (long)objectMarshallingStrategies.length);
        Assert.assertEquals((Object)objectMarshallingStrategies[0].getClass().getName(), (Object)"org.kie.aries.blueprint.mocks.MockObjectMarshallingStrategy");
    }

    @Test
    public void testEnvMarshallerOrder() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-env");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)4L, (long)objectMarshallingStrategies.length);
        Assert.assertTrue((boolean)(objectMarshallingStrategies[0] instanceof SerializablePlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[1] instanceof IdentityPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[2] instanceof JPAPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[3] instanceof ProcessInstanceResolverStrategy));
    }

    @Test
    public void testEnvMarshallerOrderWithCustom() throws Exception {
        Environment environment = (Environment)container.getComponentInstance("drools-env-custom-marshaller-mixed");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)5L, (long)objectMarshallingStrategies.length);
        Assert.assertTrue((boolean)(objectMarshallingStrategies[0] instanceof SerializablePlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[1] instanceof IdentityPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[2] instanceof JPAPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[3] instanceof MockObjectMarshallingStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[4] instanceof ProcessInstanceResolverStrategy));
    }

    @AfterClass
    public static void tearDown() {
        container.destroy();
    }
}

