/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.factorybeans;

import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.aries.blueprint.factorybeans.AbstractKieObjectsResolver;
import org.kie.aries.blueprint.namespace.BlueprintContextHelper;

public class KieImportResolver
extends AbstractKieObjectsResolver {
    private final String releaseIdName;
    private final boolean scannerEnabled;
    private final long scannerInterval;
    private KieContainer kieContainer;

    public KieImportResolver(String releaseIdName, ReleaseId releaseId, boolean scannerEnabled, long scannerInterval) {
        super(releaseId);
        this.releaseIdName = releaseIdName;
        this.scannerEnabled = scannerEnabled;
        this.scannerInterval = scannerInterval;
    }

    @Override
    public Object init(BlueprintContextHelper context) {
        KieContainer kContainer = this.registerKieContainer(context);
        this.registerKieBases(context, kContainer);
        return kContainer;
    }

    private synchronized KieContainer registerKieContainer(BlueprintContextHelper context) {
        if (this.kieContainer == null) {
            KieServices ks = KieServices.Factory.get();
            if (this.releaseId == null) {
                this.kieContainer = ks.getKieClasspathContainer();
            } else {
                this.kieContainer = this.resolveKContainer(this.releaseId);
                if (this.scannerEnabled) {
                    KieScanner kieScanner = KieServices.Factory.get().newKieScanner(this.kieContainer);
                    context.registerBean(this.releaseIdName + "#scanner", kieScanner);
                    if (this.scannerInterval > 0L) {
                        kieScanner.start(this.scannerInterval);
                    }
                }
            }
        }
        return this.kieContainer;
    }

    private void registerKieBases(BlueprintContextHelper context, KieContainer kContainer) {
        for (String kieBaseName : kContainer.getKieBaseNames()) {
            KieBase kieBase = kContainer.getKieBase(kieBaseName);
            context.registerBean(kieBaseName, kieBase);
            this.registerKieSessions(context, kieBaseName, kContainer);
        }
    }

    private void registerKieSessions(BlueprintContextHelper context, String kieBaseName, KieContainer kContainer) {
        for (String kieSessionName : kContainer.getKieSessionNamesInKieBase(kieBaseName)) {
            Object ksession = this.resolveKSession(kieSessionName, kContainer);
            context.registerBean(kieSessionName, ksession);
        }
    }
}

