/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.io.File;
import java.io.IOException;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.scanner.MavenRepository;

public class AbstractKieBlueprintDynamicModuleTest {
    protected ReleaseId releaseId;
    protected FileManager fileManager;

    protected MavenRepository createAndInstallModule(KieServices ks, int FIRST_VALUE) throws IOException {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        this.releaseId = KieServices.Factory.get().newReleaseId("org.kie.blueprint", "blueprint-scanner-test", "1.0-SNAPSHOT");
        File kPom = this.createKPom(this.releaseId);
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, this.releaseId, FIRST_VALUE);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(this.releaseId, kJar1, kPom);
        return repository;
    }

    protected InternalKieModule createKieJarWithClass(KieServices ks, ReleaseId releaseId, int value) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRL(value));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((String)"", (boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks, boolean isdefault) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setDefault(isdefault).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("KSession1").setDefault(isdefault).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime"));
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    protected File createKPom(ReleaseId releaseId) throws IOException {
        File pomFile = this.fileManager.newFile("pom.xml");
        this.fileManager.write(pomFile, this.getPom(releaseId, new ReleaseId[0]));
        return pomFile;
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected String createDRL(int value) {
        return "package org.kie.test\nglobal java.util.List list\nrule simple\nwhen\nthen\n   list.add(" + value + ");\nend\n";
    }
}

