/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.apache.aries.blueprint.container.SimpleNamespaceHandlerSet;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;
import org.apache.aries.blueprint.reflect.PassThroughMetadataImpl;
import org.kie.aries.blueprint.KieNamespaceHandler;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class KieBlueprintContainer
extends BlueprintContainerImpl {
    public KieBlueprintContainer(ClassLoader loader, List<URL> resources) throws Exception {
        this(loader, resources, null, true);
    }

    public KieBlueprintContainer(ClassLoader loader, List<URL> resources, boolean init) throws Exception {
        this(loader, resources, null, init);
    }

    public KieBlueprintContainer(ClassLoader loader, List<URL> resources, Map<String, String> properties, boolean init) throws Exception {
        super(loader, resources, properties, KieBlueprintContainer.createKieNamespaceHandlerSet(loader), false);
        this.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)new PassThroughMetadataImpl("blueprintBundleContext", (Object)KieBlueprintContainer.createMockBundleContext(loader)));
        if (init) {
            super.init();
        }
    }

    private static NamespaceHandlerSet createKieNamespaceHandlerSet(ClassLoader classloader) {
        SimpleNamespaceHandlerSet handlerSet = new SimpleNamespaceHandlerSet();
        URI namespaceURL = URI.create("http://drools.org/schema/kie-aries-blueprint/1.0.0");
        URL schemaURL = classloader.getResource("org/kie/aries/blueprint/kie-aries-blueprint.xsd");
        KieNamespaceHandler namespaceHandler = new KieNamespaceHandler();
        handlerSet.addNamespace(namespaceURL, schemaURL, (NamespaceHandler)namespaceHandler);
        return handlerSet;
    }

    private static BundleContext createMockBundleContext(ClassLoader classLoader) {
        BundleContext mockBundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        Bundle mockBundle = KieBlueprintContainer.createMockBundle(classLoader);
        Mockito.when((Object)mockBundleContext.getBundle()).thenReturn((Object)mockBundle);
        return mockBundleContext;
    }

    private static Bundle createMockBundle(ClassLoader classLoader) {
        Bundle mockBundle = (Bundle)Mockito.mock(Bundle.class);
        BundleWiring mockBundleWiring = KieBlueprintContainer.createMockBundleWiring(classLoader);
        Mockito.when((Object)((BundleWiring)mockBundle.adapt((Class)Matchers.eq(BundleWiring.class)))).thenReturn((Object)mockBundleWiring);
        return mockBundle;
    }

    private static BundleWiring createMockBundleWiring(ClassLoader classLoader) {
        BundleWiring mockBundleWiring = (BundleWiring)Mockito.mock(BundleWiring.class);
        Mockito.when((Object)mockBundleWiring.getClassLoader()).thenReturn((Object)classLoader);
        return mockBundleWiring;
    }

    public void registerBean(String name, Object bean) {
        this.getRepository().addFullObject(name, new CompletedFuture<Object>(bean));
    }

    public static class CompletedFuture<T>
    implements Future<T> {
        private final T result;

        public CompletedFuture(T result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result;
        }
    }
}

