/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.component;

import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CxfSpringEndpoint;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.XStreamDataFormat;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.drools.compiler.runtime.pipeline.impl.DroolsJaxbHelperProviderImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.runtime.CommandExecutor;
import org.kie.camel.component.ExecutionNodePipelineContextImpl;
import org.kie.camel.component.FastCloner;
import org.kie.camel.component.KieEndpoint;
import org.kie.camel.component.PostCxfrs;
import org.kie.camel.component.PreCxfrs;
import org.kie.camel.component.XStreamJson;
import org.kie.camel.component.XStreamXml;
import org.kie.jax.soap.PostCxfSoapProcessor;
import org.kie.jax.soap.PostCxfTransportSoapProcessor;
import org.kie.jax.soap.PreCxfSoapProcessor;
import org.kie.jax.soap.PreCxfTransportSoapProcessor;

public class KiePolicy
implements Policy {
    private static boolean augmented;

    public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> processorDefinition) {
        KiePolicy.augmentNodes(routeContext, processorDefinition, new HashSet());
    }

    public Processor wrap(RouteContext routeContext, Processor processor) {
        RouteDefinition routeDef = routeContext.getRoute();
        ToDefinition toKie = this.getKieNode(routeDef);
        Processor returnedProcessor = toKie != null ? new KieProcess(toKie.getUri(), processor) : processor;
        return returnedProcessor;
    }

    private ToDefinition getKieNode(RouteDefinition routeDef) {
        ProcessorDefinition child;
        ToDefinition toDrools = null;
        Iterator i$ = routeDef.getOutputs().iterator();
        while (i$.hasNext() && (toDrools = this.getKieNode(child = (ProcessorDefinition)i$.next())) == null) {
        }
        return toDrools;
    }

    public static void augmentNodes(RouteContext routeContext, ProcessorDefinition<?> nav, Set visited) {
        if (!nav.getOutputs().isEmpty()) {
            List outputs = nav.getOutputs();
            for (int i = 0; i < outputs.size(); ++i) {
                DataFormatDefinition dformatDefinition;
                MarshalDefinition m;
                ProcessorDefinition child = (ProcessorDefinition)outputs.get(i);
                if (child instanceof ToDefinition) {
                    BeanDefinition beanDef;
                    ToDefinition to = (ToDefinition)child;
                    if (to.getUri().startsWith("cxfrs") && !visited.contains(to)) {
                        beanDef = new BeanDefinition();
                        beanDef.setBeanType(PreCxfrs.class.getName());
                        outputs.add(i, beanDef);
                        beanDef = new BeanDefinition();
                        beanDef.setBeanType(PostCxfrs.class.getName());
                        outputs.add(i + 2, beanDef);
                        i += 2;
                        continue;
                    }
                    if (!to.getUri().startsWith("cxf") || visited.contains(to)) continue;
                    beanDef = new BeanDefinition();
                    beanDef.setBeanType(PreCxfSoapProcessor.class.getName());
                    outputs.add(i, beanDef);
                    beanDef = new BeanDefinition();
                    beanDef.setBeanType(PostCxfSoapProcessor.class.getName());
                    outputs.add(i + 2, beanDef);
                    i += 2;
                    augmented = true;
                    continue;
                }
                if (child instanceof MarshalDefinition) {
                    m = (MarshalDefinition)child;
                    dformatDefinition = m.getDataFormatType();
                    dformatDefinition = KiePolicy.processDataFormatType(routeContext, m.getRef(), dformatDefinition);
                    m.setDataFormatType(dformatDefinition);
                    continue;
                }
                if (!(child instanceof UnmarshalDefinition)) continue;
                m = (UnmarshalDefinition)child;
                dformatDefinition = m.getDataFormatType();
                dformatDefinition = KiePolicy.processDataFormatType(routeContext, m.getRef(), dformatDefinition);
                m.setDataFormatType(dformatDefinition);
            }
            for (ProcessorDefinition child : nav.getOutputs()) {
                KiePolicy.augmentNodes(routeContext, child, visited);
            }
        }
    }

    private static DataFormatDefinition processDataFormatType(RouteContext routeContext, String ref, DataFormatDefinition dformatDefinition) {
        if (dformatDefinition == null) {
            if ("json".equals(ref)) {
                dformatDefinition = new XStreamDataFormat();
                ((XStreamDataFormat)dformatDefinition).setDriver("json");
            } else {
                dformatDefinition = "xstream".equals(ref) ? new XStreamDataFormat() : ("jaxb".equals(ref) ? new JaxbDataFormat() : routeContext.getCamelContext().resolveDataFormatDefinition(ref));
            }
        }
        if ((dformatDefinition = new FastCloner().deepClone(dformatDefinition)) instanceof JaxbDataFormat) {
            dformatDefinition = KiePolicy.augmentJaxbDataFormatDefinition((JaxbDataFormat)dformatDefinition);
        } else if (dformatDefinition instanceof XStreamDataFormat) {
            XStreamDataFormat xstreamDataFormat = (XStreamDataFormat)dformatDefinition;
            dformatDefinition = "json".equals(xstreamDataFormat.getDriver()) ? XStreamJson.newJSonMarshaller(xstreamDataFormat) : XStreamXml.newXStreamMarshaller((XStreamDataFormat)dformatDefinition);
        }
        return dformatDefinition;
    }

    private ToDefinition getKieNode(ProcessorDefinition nav) {
        if (!nav.getOutputs().isEmpty()) {
            List children = nav.getOutputs();
            for (ProcessorDefinition child : children) {
                ToDefinition to;
                if (child instanceof ToDefinition && (to = (ToDefinition)child).getUri().trim().startsWith("kie:")) {
                    return to;
                }
                this.getKieNode(child);
            }
        }
        return null;
    }

    public static JaxbDataFormat augmentJaxbDataFormatDefinition(JaxbDataFormat jaxbDataFormat) {
        HashSet<String> set = new HashSet<String>();
        for (String clsName : DroolsJaxbHelperProviderImpl.JAXB_ANNOTATED_CMD) {
            set.add(clsName.substring(0, clsName.lastIndexOf(46)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(jaxbDataFormat.getContextPath());
        sb.append(":");
        for (String pkgName : set) {
            sb.append(pkgName);
            sb.append(':');
        }
        jaxbDataFormat.setContextPath(sb.toString());
        return jaxbDataFormat;
    }

    public static class KieProcess
    implements Processor {
        private String kieUri;
        private KieEndpoint dep;
        private Processor processor;

        public KieProcess(String kieUri, Processor processor) {
            this.kieUri = kieUri;
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if (this.dep == null) {
                this.dep = (KieEndpoint)exchange.getContext().getEndpoint(this.kieUri, KieEndpoint.class);
            }
            if (this.dep == null) {
                throw new RuntimeException("Could not find DroolsEndPoint for uri=" + this.kieUri);
            }
            ClassLoader originalClassLoader = null;
            try {
                originalClassLoader = Thread.currentThread().getContextClassLoader();
                CommandExecutor exec = this.dep.executor;
                if (exec == null) {
                    String lookup = (String)exchange.getIn().getHeader("KieLookup", String.class);
                    if (StringUtils.isEmpty((CharSequence)lookup)) {
                        lookup = this.dep.getLookup(body);
                    }
                    if (StringUtils.isEmpty((CharSequence)lookup)) {
                        throw new RuntimeException("No Executor defined and no lookup information available for uri " + this.dep.getEndpointUri());
                    }
                    exec = this.dep.getCommandExecutor(lookup);
                }
                if (exec == null) {
                    throw new RuntimeException("CommandExecutor cannot be found for uri " + this.dep.getEndpointUri());
                }
                ClassLoader localClassLoader = this.dep.getClassLoader(exec);
                if (localClassLoader == null) {
                    throw new RuntimeException("CommandExecutor Classloader cannot be null for uri " + this.dep.getEndpointUri());
                }
                Thread.currentThread().setContextClassLoader(localClassLoader);
                ExecutionNodePipelineContextImpl context = new ExecutionNodePipelineContextImpl(localClassLoader);
                context.setCommandExecutor(exec);
                exchange.setProperty("kie-context", (Object)context);
                exchange.getIn().setBody((Object)new ByteArrayInputStream(body.getBytes("UTF-8")));
                boolean soap = false;
                if (!augmented && exchange.getFromEndpoint() instanceof CxfSpringEndpoint) {
                    new PreCxfTransportSoapProcessor().process(exchange);
                    soap = true;
                }
                this.processor.process(exchange);
                if (soap) {
                    new PostCxfTransportSoapProcessor().process(exchange);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public static class KieClientProcessor
    implements Processor {
        private Processor processor;

        public KieClientProcessor(Processor processor) {
            this.processor = processor;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.setPattern(ExchangePattern.InOut);
            Message inMessage = exchange.getIn();
            inMessage.setHeader("CamelCxfRsUsingHttpAPI", (Object)Boolean.TRUE);
            inMessage.setHeader("CamelHttpMethod", (Object)"POST");
            inMessage.setHeader("CamelHttpPath", (Object)"/execute");
            inMessage.setHeader("CamelAcceptContentType", (Object)"text/plain");
            inMessage.setHeader("Content-Type", (Object)"text/plain");
            this.processor.process(exchange);
        }
    }
}

