/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.component;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.apache.camel.util.jndi.JndiContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.camel.component.KiePolicy;
import org.kie.camel.testdomain.Person;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class JaxbInsertTest {
    private StatefulKnowledgeSession ksession;
    private ProducerTemplate template;

    @Before
    public void setUp() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        this.ksession = kbuilder.newKnowledgeBase().newStatefulKnowledgeSession();
        this.initializeTemplate(this.ksession);
    }

    private void initializeTemplate(StatefulKnowledgeSession session) throws Exception {
        CamelContext context = this.configure(session);
        this.template = context.createProducerTemplate();
        context.start();
    }

    private CamelContext configure(StatefulKnowledgeSession session) throws Exception {
        JndiContext context = new JndiContext();
        context.bind("ksession", (Object)session);
        DefaultCamelContext camelContext = new DefaultCamelContext((Context)context);
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat jdf = new JaxbDataFormat();
                jdf.setContextPath("org.kie.camel.testdomain");
                jdf.setPrettyPrint(Boolean.valueOf(true));
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-session").policy((Policy)new KiePolicy()).unmarshal((DataFormatDefinition)jdf)).to("kie://ksession")).marshal((DataFormatDefinition)jdf);
                this.from("direct:unmarshall").policy((Policy)new KiePolicy()).unmarshal((DataFormatDefinition)jdf);
                this.from("direct:marshall").policy((Policy)new KiePolicy()).marshal((DataFormatDefinition)jdf);
            }
        });
        return camelContext;
    }

    @Test
    public void testInsert() throws Exception {
        Person p = new Person("Alice", "spicy meals", 30);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)p, (String)"tempPerson"));
        BatchExecutionCommand command = CommandFactory.newBatchExecution(commands);
        String xmlCommand = (String)this.template.requestBody("direct:marshall", (Object)command, String.class);
        String xml = (String)this.template.requestBody("direct:test-session", (Object)xmlCommand, String.class);
        ExecutionResults res = (ExecutionResults)this.template.requestBody("direct:unmarshall", (Object)xml);
        Object o = res.getFactHandle("tempPerson");
        Assert.assertTrue((String)"returned String instead of FactHandle instance", (boolean)(o instanceof FactHandle));
    }

    @Test
    public void testInsertElements() {
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(new Person("John", "nobody", 50));
        persons.add(new Person("Peter", "himself", 24));
        this.insertElements(persons);
        Assert.assertEquals((long)2L, (long)this.ksession.getFactCount());
    }

    private void insertElements(List<Person> objects) {
        String insertElements = "<batch-execution>\n  <insert-elements return-objects=\"true\">\n    <list>\n";
        for (Person p : objects) {
            insertElements = insertElements + "      <element xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n        <age>" + p.getAge() + "</age>\n" + "        <likes>" + p.getLikes() + "</likes>\n" + "        <name>" + p.getName() + "</name>\n" + "      </element>\n";
        }
        insertElements = insertElements + "    </list>\n  </insert-elements>\n</batch-execution>";
        this.template.requestBody("direct:test-session", (Object)insertElements, String.class);
    }
}

