/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.component;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.custommonkey.xmlunit.XMLUnit;
import org.drools.core.command.runtime.rule.ModifyCommand;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.util.StringUtils;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.camel.component.KiePolicy;
import org.kie.camel.testdomain.ChangeCollector;
import org.kie.camel.testdomain.Cheese;
import org.kie.camel.testdomain.Person;
import org.kie.internal.io.ResourceFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@RunWith(value=JUnit4.class)
public abstract class BatchTest
extends CamelTestSupport {
    protected CommandExecutor exec;
    protected String dataformat;
    protected String copyToDataFormat;
    protected final TemplateRegistry tempReg = new SimpleTemplateRegistry();
    protected PrintWriter writer;

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat jaxbDf = new JaxbDataFormat();
                jaxbDf.setContextPath("org.kie.camel.testdomain");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:exec").policy((Policy)new KiePolicy()).unmarshal(BatchTest.this.dataformat)).to("kie://ksession1")).marshal(BatchTest.this.dataformat);
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:execWithLookup").policy((Policy)new KiePolicy()).unmarshal(BatchTest.this.dataformat)).to("kie://dynamic")).marshal(BatchTest.this.dataformat);
                this.from("direct:unmarshal").policy((Policy)new KiePolicy()).unmarshal(BatchTest.this.dataformat);
                this.from("direct:marshal").policy((Policy)new KiePolicy()).marshal(BatchTest.this.dataformat);
                ((PolicyDefinition)this.from("direct:to-xstream").policy((Policy)new KiePolicy()).unmarshal(BatchTest.this.dataformat)).marshal("xstream");
                ((PolicyDefinition)this.from("direct:to-jaxb").policy((Policy)new KiePolicy()).unmarshal(BatchTest.this.dataformat)).marshal((DataFormatDefinition)jaxbDf);
            }
        };
    }

    public String prettyPrintXml(String xmlSource) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlSource)));
            TransformerFactory tfactory = TransformerFactory.newInstance();
            tfactory.setAttribute("indent-number", 4);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)baos, "UTF-8")));
            return new String(baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("ksession1", (Object)this.exec);
        return context;
    }

    public void setUp() throws Exception {
    }

    public void setExec(CommandExecutor exec) {
        this.exec = exec;
        try {
            super.setUp();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void before() throws Exception {
        this.tempReg.addNamedTemplate("tempReg", TemplateCompiler.compileTemplate((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.dataformat + ".mvt"), (Map)null));
        TemplateRuntime.execute((CompiledTemplate)this.tempReg.getNamedTemplate("tempReg"), null, (TemplateRegistry)this.tempReg);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
        if (!StringUtils.isEmpty((CharSequence)this.copyToDataFormat)) {
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(this.copyToDataFormat + ".mvt", true)));
        }
    }

    @After
    public void after() throws Exception {
        if (!StringUtils.isEmpty((CharSequence)this.copyToDataFormat)) {
            this.writer.close();
        }
    }

    public String getContent(String name, String ... vars) {
        HashMap<String, String> map = new HashMap<String, String>();
        int counter = 1;
        for (String var : vars) {
            map.put("var" + counter++, var);
        }
        if (!StringUtils.isEmpty((CharSequence)this.copyToDataFormat)) {
            this.writer.println();
            this.writer.println("@declare{\"" + name + "\"}");
        }
        String s = (String)TemplateRuntime.execute((CompiledTemplate)this.tempReg.getNamedTemplate(name), map);
        if (!StringUtils.isEmpty((CharSequence)this.copyToDataFormat)) {
            this.writer.print(this.prettyPrintXml((String)this.template.requestBody("direct:to-" + this.copyToDataFormat, (Object)s, String.class)));
            this.writer.println("@end{}");
        }
        return this.roundTripFromXml(s.trim());
    }

    public String execContent(String name) {
        return this.execContent(name, String.class);
    }

    public <T> T execContent(String name, Class<T> cls) {
        return this.execContent(name, cls, new String[0]);
    }

    public <T> T execContent(String name, Class<T> cls, String ... vars) {
        String s = this.execContent(name, vars);
        if (cls.isAssignableFrom(String.class)) {
            return (T)s;
        }
        return this.unmarshalOutXml(s, cls);
    }

    public String execContent(String name, String ... vars) {
        String inXml = this.getContent(name, vars);
        return this.execInXml(inXml);
    }

    public String execInXml(String inXml) {
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        return this.roundTripFromXml(outXml);
    }

    public <T> T unmarshalOutXml(String outXml, Class<T> cls) {
        Object object = this.template.requestBody("direct:unmarshal", (Object)outXml, Object.class);
        return (T)this.roundTripFromObject(object);
    }

    public abstract void assertXMLEqual(String var1, String var2);

    public String roundTripFromXml(String inXml) {
        Object object = this.template.requestBody("direct:unmarshal", (Object)inXml);
        inXml = (String)this.template.requestBody("direct:marshal", object, String.class);
        object = this.template.requestBody("direct:unmarshal", (Object)inXml);
        return (String)this.template.requestBody("direct:marshal", object, String.class);
    }

    public Object roundTripFromObject(Object object) {
        String inXml = (String)this.template.requestBody("direct:marshal", object, String.class);
        object = this.template.requestBody("direct:unmarshal", (Object)inXml);
        inXml = (String)this.template.requestBody("direct:marshal", object, String.class);
        return this.template.requestBody("direct:unmarshal", (Object)inXml);
    }

    private StatelessKieSession getStatelessKieSession(Resource resource) throws Exception {
        return this.getStatelessKieSessionFromResource(resource.setSourcePath("src/main/resources/rule.drl").setResourceType(ResourceType.DRL));
    }

    private StatelessKieSession getStatelessKieSessionFromResource(Resource resource) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(resource);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (!errors.isEmpty()) {
            BatchTest.fail((String)("" + errors));
        }
        return ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newStatelessKieSession();
    }

    private KieSession getKieSession(Resource resource) throws Exception {
        return this.getKieSessionFromResource(resource.setSourcePath("src/main/resources/rule.drl").setResourceType(ResourceType.DRL));
    }

    private KieSession getKieSessionFromResource(Resource resource) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(resource);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (!errors.isEmpty()) {
            BatchTest.fail((String)("" + errors));
        }
        return ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @Test
    public void testListenForChanges() throws Exception {
        String str = "";
        str = str + "package org.kie.camel.testdomain \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "import org.kie.camel.testdomain.ChangeCollector \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese(price==25) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "end\n";
        str = str + "rule rule2 \n";
        str = str + "  when \n";
        str = str + "    p : Person(name=='mic') \n";
        str = str + "    c : Cheese(price != 42) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    c.setPrice( 42 ); \n";
        str = str + "    update(c); \n";
        str = str + "end\n";
        str = str + "rule rule3 \n";
        str = str + "  when \n";
        str = str + "    p : Person(name=='mark') \n";
        str = str + "    c : Cheese(price == 42) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    retract(c); \n";
        str = str + "end\n";
        str = str + "rule ruleBootStrap \n";
        str = str + "salience 10000\n";
        str = str + "  when \n";
        str = str + "    $c : ChangeCollector() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    kcontext.getKnowledgeRuntime().addEventListener($c); \n";
        str = str + "end\n";
        str = str + "rule ruleCleanup \n";
        str = str + "salience -10000\n";
        str = str + "  when \n";
        str = str + "    $c : ChangeCollector() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    kcontext.getKnowledgeRuntime().removeEventListener($c); \n";
        str = str + "    retract($c); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testListenForChanges.in.1");
        outXml = this.execContent("testListenForChanges.in.2");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        this.assertXMLEqual(this.getContent("testListenForChanges.expected.1", ((FactHandle)result.getFactHandle("changes")).toExternalForm(), ((FactHandle)result.getFactHandle("person")).toExternalForm()), outXml);
        ChangeCollector collector = (ChangeCollector)result.getValue("changes");
        Cheese c = (Cheese)collector.getChanges().get(0);
        BatchTest.assertEquals((long)42L, (long)c.getPrice());
        result = this.execContent("testListenForChanges.in.3", ExecutionResults.class);
        collector = (ChangeCollector)result.getValue("changes");
        BatchTest.assertEquals((Object)"stilton", (Object)collector.getRetracted().get(0));
    }

    @Test
    public void testInsertWithDefaults() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testInsertWithDefaults.in.1");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        BatchTest.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        stilton = (Cheese)ksession.getObject(factHandle);
        BatchTest.assertEquals((long)30L, (long)stilton.getPrice());
        String expectedXml = this.getContent("testInsertWithDefaults.expected.1", ((FactHandle)result.getFactHandle("outStilton")).toExternalForm());
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testInsertWithReturnObjectFalse() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testInsertWithReturnObjectFalse.in.1");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        String expectedXml = this.getContent("testInsertWithReturnObjectFalse.expected.1", ((FactHandle)result.getFactHandle("outStilton")).toExternalForm());
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testFactHandleReturn() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    System.err.println(42); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        FactHandle fh = ksession.insert((Object)new Person("mic", 42));
        ArrayList<FactHandle> list = new ArrayList<FactHandle>();
        list.add(fh);
        ksession.setGlobal("list1", list);
        String outXml = this.execContent("testFactHandleReturn.in.1");
        this.assertXMLEqual(this.getContent("testFactHandleReturn.expected.1", fh.toExternalForm()), outXml);
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        List outList = (List)result.getValue("out-list");
        BatchTest.assertEquals((long)1L, (long)outList.size());
        BatchTest.assertEquals((Object)fh.toExternalForm(), (Object)((FactHandle)outList.get(0)).toExternalForm());
        BatchTest.assertNotSame((Object)fh, outList.get(0));
    }

    @Test
    public void testGetObject() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        ExecutionResults result = this.execContent("testGetObject.in.1", ExecutionResults.class);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        BatchTest.assertEquals((long)30L, (long)stilton.getPrice());
        String outXml = this.execContent("testGetObject.in.2", ((FactHandle)result.getFactHandle("outStilton")).toExternalForm());
        result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        stilton = (Cheese)result.getValue("outStilton");
        BatchTest.assertEquals((long)30L, (long)stilton.getPrice());
    }

    @Test
    public void testRetractObject() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        ExecutionResults result = this.execContent("testRetractObject.in.1", ExecutionResults.class);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        BatchTest.assertEquals((long)30L, (long)stilton.getPrice());
        String outXml = this.execContent("testRetractObject.in.2", ((FactHandle)result.getFactHandle("outStilton")).toExternalForm());
        outXml = this.execContent("testRetractObject.in.3", ((FactHandle)result.getFactHandle("outStilton")).toExternalForm());
        result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        BatchTest.assertNull((Object)result.getValue("outStilton"));
    }

    @Test
    public void testModifyObject() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testModifyObject.in.1");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        String stiltonfh = ((FactHandle)result.getFactHandle("outStilton")).toExternalForm();
        Cheese stilton = (Cheese)result.getValue("outStilton");
        BatchTest.assertEquals((long)30L, (long)stilton.getPrice());
        String expectedXml = this.getContent("testModifyObject.expected.1", stiltonfh);
        this.assertXMLEqual(expectedXml, outXml);
        this.execContent("testModifyObject.in.2", ExecutionResults.class, stiltonfh);
        result = this.execContent("testModifyObject.in.3", ExecutionResults.class, stiltonfh);
        stilton = (Cheese)result.getValue("outStilton");
        BatchTest.assertEquals((long)42L, (long)stilton.getOldPrice());
        BatchTest.assertEquals((long)55L, (long)stilton.getPrice());
        ModifyCommand.ALLOW_MODIFY_EXPRESSIONS = false;
        this.execContent("testModifyObject.in.4", ExecutionResults.class, stiltonfh);
        ModifyCommand.ALLOW_MODIFY_EXPRESSIONS = true;
        result = this.execContent("testModifyObject.in.5", ExecutionResults.class, stiltonfh);
        stilton = (Cheese)result.getValue("outStilton");
        BatchTest.assertEquals((Object)"throwException()", (Object)stilton.getType());
    }

    @Test
    public void testInsertElements() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "     list1.add( $c );";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testInsertElements.in.1");
        this.assertXMLEqual(this.getContent("testInsertElements.expected.1", new String[0]), outXml);
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        List list = (List)result.getValue("list1");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        BatchTest.assertEquals(expectedList, new HashSet(list));
    }

    @Test
    public void testInsertElementsWithReturnObjects() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "    list1.add( $c );";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testInsertElementsWithReturnObjects.in.1");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        List list1 = (List)result.getValue("list1");
        BatchTest.assertEquals((long)2L, (long)list1.size());
        BatchTest.assertTrue((boolean)list1.contains(new Cheese("stilton", 35)));
        BatchTest.assertTrue((boolean)list1.contains(new Cheese("stilton", 30)));
        List myFacts = (List)result.getValue("myfacts");
        BatchTest.assertEquals((long)2L, (long)list1.size());
        BatchTest.assertTrue((boolean)myFacts.contains(new Cheese("stilton", 35)));
        BatchTest.assertTrue((boolean)myFacts.contains(new Cheese("stilton", 30)));
        List factHandles = (List)result.getFactHandle("myfacts");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(ksession.getObject((FactHandle)((InternalFactHandle)factHandles.get(0))));
        list.add(ksession.getObject((FactHandle)((InternalFactHandle)factHandles.get(1))));
        BatchTest.assertTrue((boolean)list.contains(new Cheese("stilton", 35)));
        BatchTest.assertTrue((boolean)list.contains(new Cheese("stilton", 30)));
        this.assertXMLEqual(this.getContent("testInsertElementsWithReturnObjects.expected.1", ((FactHandle)factHandles.get(0)).toExternalForm(), ((FactHandle)factHandles.get(1)).toExternalForm()), outXml);
    }

    @Test
    public void testSetGlobal() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "global java.util.List list2 \n";
        str = str + "global java.util.List list3 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( 30 ); \n";
        str = str + "    list1.add( $c ); \n";
        str = str + "    list2.add( $c ); \n";
        str = str + "    list3.add( $c ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testSetGlobal.in.1");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        this.assertXMLEqual(this.getContent("testSetGlobal.expected.1", ((FactHandle)result.getFactHandle("outStilton")).toExternalForm()), outXml);
        Cheese stilton = new Cheese("stilton", 30);
        BatchTest.assertNull((Object)result.getValue("list1"));
        List list2 = (List)result.getValue("list2");
        BatchTest.assertEquals((long)1L, (long)list2.size());
        BatchTest.assertEquals((Object)stilton, list2.get(0));
        List list3 = (List)result.getValue("outList3");
        BatchTest.assertEquals((long)1L, (long)list3.size());
        BatchTest.assertEquals((Object)stilton, list3.get(0));
    }

    @Test
    public void testGetGlobal() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    list1.add( $c ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testGetGlobal.in.1");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        this.assertXMLEqual(this.getContent("testGetGlobal.expected.1", ((FactHandle)result.getFactHandle("outStilton")).toExternalForm()), outXml);
        List resultsList = (List)result.getValue("out-list");
        BatchTest.assertEquals((long)1L, (long)resultsList.size());
        BatchTest.assertEquals((Object)new Cheese("stilton", 25), resultsList.get(0));
    }

    @Test
    public void testGetObjects() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"insert-elements\":{\"objects\":[";
        inXml = inXml + "   {   \"org.kie.camel.testdomain.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, ";
        inXml = inXml + "   {   \"org.kie.camel.testdomain.Cheese\":{\"type\":\"stilton\",\"price\":30,\"oldPrice\":0}} ";
        inXml = inXml + "   ]}}";
        inXml = inXml + ",  {\"get-objects\":{\"out-identifier\":\"list1\"}}";
        inXml = inXml + "]}}";
        StatelessKieSession ksession = this.getStatelessKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testGetObjects.in.1");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        List list = (List)result.getValue("list1");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        BatchTest.assertEquals(expectedList, new HashSet(list));
    }

    @Test
    public void testQuery() throws Exception {
        String str = "";
        str = str + "package org.kie.test  \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        str = str + "query cheesesWithParams(String a, String b) \n";
        str = str + "    stilton : Cheese(type == a) \n";
        str = str + "    cheddar : Cheese(type == b, price == stilton.price) \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testQuery.in.1");
        this.getContent("testQuery.expected.1", new String[0]);
        ExecutionResults batchResult = this.unmarshalOutXml(outXml, ExecutionResults.class);
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        QueryResults results = (QueryResults)batchResult.getValue("cheeses");
        BatchTest.assertEquals((long)2L, (long)results.size());
        BatchTest.assertEquals((long)2L, (long)results.getIdentifiers().length);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        BatchTest.assertEquals(set, newSet);
    }

    @Test
    public void testManualFireAllRules() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "    list1.add( $c );";
        str = str + "end\n";
        StatelessKieSession ksession = this.getStatelessKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testManualFireAllRules.in.1");
        ExecutionResults result = this.unmarshalOutXml(outXml, ExecutionResults.class);
        this.assertXMLEqual(this.getContent("testManualFireAllRules.expected.1", ((FactHandle)result.getFactHandle("outBrie")).toExternalForm()), outXml);
        List list = (List)result.getValue("list1");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        BatchTest.assertEquals(expectedList, new HashSet(list));
        Cheese brie10 = new Cheese("brie", 10);
        brie10.setOldPrice(5);
        BatchTest.assertEquals((Object)brie10, (Object)result.getValue("outBrie"));
    }

    @Test
    public void testProcess() throws Exception {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <imports>\n";
        str = str + "      <import name=\"org.kie.camel.testdomain.TestVariable\" />\n";
        str = str + "    </imports>\n";
        str = str + "    <globals>\n";
        str = str + "      <global identifier=\"list1\" type=\"java.util.List\" />\n";
        str = str + "    </globals>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"person\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"TestVariable\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <actionNode id=\"2\" name=\"MyActionNode\" >\n";
        str = str + "      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\n";
        str = str + "list1.add(person.name);\n";
        str = str + "</action>\n";
        str = str + "    </actionNode>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n\n";
        str = str + "</process>";
        StatelessKieSession ksession = this.getStatelessKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        List list = new ArrayList();
        ksession.setGlobal("list1", list);
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testProcess.in.1");
        this.assertXMLEqual(this.getContent("testProcess.expected.1", new String[0]), outXml);
        ExecutionResults results = this.unmarshalOutXml(outXml, ExecutionResults.class);
        list = (List)results.getValue("out-list");
        BatchTest.assertEquals((long)1L, (long)list.size());
        BatchTest.assertEquals((Object)"John Doe", list.get(0));
    }

    @Test
    public void testProcessInstanceSignalEvent() throws Exception {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.core.event\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"MyVar\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>SomeText</value>\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <eventNode id=\"2\" name=\"Event\" variableName=\"MyVar\" >\n";
        str = str + "      <eventFilters>\n";
        str = str + "        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n";
        str = str + "      </eventFilters>\n";
        str = str + "    </eventNode>\n";
        str = str + "    <join id=\"3\" name=\"Join\" type=\"1\" />\n";
        str = str + "    <end id=\"4\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"3\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "    <connection from=\"3\" to=\"4\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        KieSession ksession = this.getKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        this.setExec((CommandExecutor)ksession);
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.event");
        BatchTest.assertEquals((long)1L, (long)processInstance.getState());
        this.execContent("testProcessInstanceSignalEvent.in.1");
        BatchTest.assertEquals((long)2L, (long)processInstance.getState());
        BatchTest.assertEquals((Object)"MyValue", (Object)((VariableScopeInstance)((org.jbpm.process.instance.ProcessInstance)processInstance).getContextInstance("VariableScope")).getVariable("MyVar"));
    }

    @Test
    public void testProcessRuntimeSignalEvent() throws Exception {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.core.event\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"MyVar\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>SomeText</value>\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <eventNode id=\"2\" name=\"Event\" scope=\"external\" variableName=\"MyVar\" >\n";
        str = str + "      <eventFilters>\n";
        str = str + "        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n";
        str = str + "      </eventFilters>\n";
        str = str + "    </eventNode>\n";
        str = str + "    <join id=\"3\" name=\"Join\" type=\"1\" />\n";
        str = str + "    <end id=\"4\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"3\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "    <connection from=\"3\" to=\"4\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        KieSession ksession = this.getKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        this.setExec((CommandExecutor)ksession);
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.event");
        BatchTest.assertEquals((long)1L, (long)processInstance.getState());
        this.execContent("testProcessRuntimeSignalEvent.in.1");
        BatchTest.assertEquals((long)2L, (long)processInstance.getState());
        BatchTest.assertEquals((Object)"MyValue", (Object)((VariableScopeInstance)((org.jbpm.process.instance.ProcessInstance)processInstance).getContextInstance("VariableScope")).getVariable("MyVar"));
    }

    @Test
    public void testCompleteWorkItem() throws Exception {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"UserName\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>John Doe</value>\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Person\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"org.kie.camel.testdomain.Person\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"MyObject\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" className=\"java.lang.String\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Number\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.IntegerDataType\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <workItem id=\"2\" name=\"HumanTask\" >\n";
        str = str + "      <work name=\"Human Task\" >\n";
        str = str + "        <parameter name=\"ActorId\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{UserName}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Content\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{Person.name}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"TaskName\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>Do something</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Priority\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Comment\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Attachment\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n";
        str = str + "        </parameter>\n";
        str = str + "      </work>\n";
        str = str + "      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />";
        str = str + "      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />";
        str = str + "      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />";
        str = str + "      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />";
        str = str + "    </workItem>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        KieSession ksession = this.getKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        this.setExec((CommandExecutor)ksession);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        BatchTest.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        BatchTest.assertNotNull((Object)workItem);
        BatchTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("ActorId"));
        BatchTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Content"));
        BatchTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Comment"));
        BatchTest.assertEquals((long)0L, (long)workItem.getState());
        this.execContent("testCompleteWorkItem.in.1", Long.toString(workItem.getId()));
        BatchTest.assertEquals((long)2L, (long)workItem.getState());
        BatchTest.assertEquals((long)2L, (long)processInstance.getState());
        parameters = new HashMap();
        parameters.put("UserName", "Jane Doe");
        parameters.put("MyObject", "SomeString");
        person = new Person();
        person.setName("Jane Doe");
        parameters.put("Person", person);
        processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        BatchTest.assertEquals((long)1L, (long)processInstance.getState());
        workItem = handler.getWorkItem();
        BatchTest.assertNotNull((Object)workItem);
        BatchTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("ActorId"));
        BatchTest.assertEquals((Object)"SomeString", (Object)workItem.getParameter("Attachment"));
        BatchTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Content"));
        BatchTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Comment"));
        BatchTest.assertEquals((long)0L, (long)workItem.getState());
        this.execContent("testCompleteWorkItem.in.2", Long.toString(workItem.getId()));
        BatchTest.assertEquals((long)2L, (long)workItem.getState());
        BatchTest.assertEquals((long)2L, (long)processInstance.getState());
        BatchTest.assertEquals((Object)"SomeOtherString", (Object)processInstance.getVariable("MyObject"));
        BatchTest.assertEquals((Object)15, (Object)processInstance.getVariable("Number"));
    }

    @Test
    public void testAbortWorkItem() throws Exception {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"UserName\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>John Doe</value>\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Person\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"org.kie.camel.testdomain.Person\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"MyObject\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" className=\"java.lang.String\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Number\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.IntegerDataType\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <workItem id=\"2\" name=\"HumanTask\" >\n";
        str = str + "      <work name=\"Human Task\" >\n";
        str = str + "        <parameter name=\"ActorId\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{UserName}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Content\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{Person.name}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"TaskName\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>Do something</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Priority\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Comment\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Attachment\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n";
        str = str + "        </parameter>\n";
        str = str + "      </work>\n";
        str = str + "      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />";
        str = str + "      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />";
        str = str + "      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />";
        str = str + "      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />";
        str = str + "    </workItem>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        KieSession ksession = this.getKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        this.setExec((CommandExecutor)ksession);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        BatchTest.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        BatchTest.assertNotNull((Object)workItem);
        BatchTest.assertEquals((long)0L, (long)workItem.getState());
        this.execContent("testAbortWorkItem.in.1", Long.toString(workItem.getId()));
        BatchTest.assertEquals((long)3L, (long)workItem.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testInsertObjectWithDeclaredFact() throws Exception {
        String str = "";
        str = str + "package org.foo \n";
        str = str + "declare Whee \n\ttype: String\n\tprice: Integer\n\toldPrice: Integer\nend\n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Whee() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        ExecutionResults results = null;
        String outXml = null;
        ClassLoader orig = null;
        ClassLoader cl = ((StatefulKnowledgeSessionImpl)ksession).getKnowledgeBase().getRootClassLoader();
        try {
            orig = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            outXml = this.execContent("testInsertObjectWithDeclaredFact.in.1");
            results = this.unmarshalOutXml(outXml, ExecutionResults.class);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        FactHandle factHandle = (FactHandle)results.getFactHandle("outStilton");
        Object object = results.getValue("outStilton");
        BatchTest.assertEquals((Object)"org.foo.Whee", (Object)object.getClass().getName());
        this.assertXMLEqual(this.getContent("testInsertObjectWithDeclaredFact.expected.1", factHandle.toExternalForm()), outXml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testInsertObjectWithDeclaredFactAndQuery() throws Exception {
        String str = "";
        str = str + "package org.foo \n";
        str = str + "declare Whee \n\ttype: String\n\tprice: Integer\n\toldPrice: Integer\nend\n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Whee(price < 30) \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n update($c);\n";
        str = str + "end\n";
        str = str + "query results\n";
        str = str + "    w: Whee(price > 0)";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        ClassLoader cl = ((StatefulKnowledgeSessionImpl)ksession).getKnowledgeBase().getRootClassLoader();
        ClassLoader orig = null;
        try {
            orig = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            String outXml = this.execContent("testInsertObjectWithDeclaredFactAndQuery.in.1");
            ExecutionResults results = this.unmarshalOutXml(outXml, ExecutionResults.class);
            FactHandle fh = (FactHandle)results.getFactHandle("outStilton");
            outXml = this.execContent("testInsertObjectWithDeclaredFactAndQuery.in.2");
            this.assertXMLEqual(this.getContent("testInsertObjectWithDeclaredFactAndQuery.expected.1", fh.toExternalForm()), outXml);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    @Test
    public void testExecutionNodeLookup() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = this.execContent("testExecutionNodeLookup.in.1");
        ExecutionResults results = this.unmarshalOutXml(outXml, ExecutionResults.class);
        Cheese stilton = (Cheese)results.getValue("outStilton");
        BatchTest.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)results.getFactHandle("outStilton");
        stilton = (Cheese)ksession.getObject(factHandle);
        BatchTest.assertEquals((long)30L, (long)stilton.getPrice());
        this.assertXMLEqual(this.getContent("testExecutionNodeLookup.expected.1", factHandle.toExternalForm()), outXml);
    }

    public static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }
    }
}

