/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.component;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.runtime.rule.ModifyCommand;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.runtime.help.impl.XStreamXML;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.camel.component.KiePolicy;
import org.kie.camel.testdomain.Cheese;
import org.kie.camel.testdomain.Person;
import org.kie.camel.testdomain.TestVariable;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.helper.BatchExecutionHelper;
import org.xml.sax.SAXException;

public class XStreamBatchExecutionTest
extends CamelTestSupport {
    protected CommandExecutor exec;
    protected CommandExecutor exec2;

    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        if (this.exec != null) {
            context.bind("ksession1", (Object)this.exec);
        }
        if (this.exec2 != null) {
            context.bind("ksession2", (Object)this.exec2);
        }
        return context;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:exec").policy((Policy)new KiePolicy()).unmarshal("xstream")).to("kie://ksession1")).marshal("xstream");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:execWithLookup").policy((Policy)new KiePolicy()).unmarshal("xstream")).to("kie://dynamic")).marshal("xstream");
                this.from("direct:unmarshal").policy((Policy)new KiePolicy()).unmarshal("xstream");
                this.from("direct:marshal").policy((Policy)new KiePolicy()).marshal("xstream");
            }
        };
    }

    public void setExec(CommandExecutor exec) {
        this.exec = exec;
        try {
            super.setUp();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setExec2(CommandExecutor exec) {
        this.exec2 = exec;
        try {
            super.setUp();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setUp() throws Exception {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
        XStreamXML.SORT_MAPS = true;
    }

    private void assertXMLEqual(String expectedXml, String resultXml) {
        try {
            Diff diff = new Diff(expectedXml, resultXml);
            diff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
            XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("XML Assertion failure", e);
        }
    }

    @Test
    public void testListenForChanges() throws Exception {
        String str = "";
        str = str + "package org.kie.camel.testdomain \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "import org.kie.camel.testdomain.ChangeCollector \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese(price==25) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "end\n";
        str = str + "rule rule2 \n";
        str = str + "  when \n";
        str = str + "    p : Person(name=='mic') \n";
        str = str + "    c : Cheese(price != 42) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    c.setPrice( 42 ); \n";
        str = str + "    update(c); \n";
        str = str + "end\n";
        str = str + "rule rule3 \n";
        str = str + "  when \n";
        str = str + "    p : Person(name=='mark') \n";
        str = str + "    c : Cheese(price == 42) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    retract(c); \n";
        str = str + "end\n";
        str = str + "rule ruleBootStrap \n";
        str = str + "salience 10000\n";
        str = str + "  when \n";
        str = str + "    $c : ChangeCollector() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    kcontext.getKnowledgeRuntime().addEventListener($c); \n";
        str = str + "end\n";
        str = str + "rule ruleCleanup \n";
        str = str + "salience -10000\n";
        str = str + "  when \n";
        str = str + "    $c : ChangeCollector() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    kcontext.getKnowledgeRuntime().removeEventListener($c); \n";
        str = str + "    retract($c); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='outStilton'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='person'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Person>";
        inXml = inXml + "      <name>mic</name>";
        inXml = inXml + "    </org.kie.camel.testdomain.Person>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <insert out-identifier='changes'>";
        inXml = inXml + "    <org.kie.camel.testdomain.ChangeCollector/>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        XStreamBatchExecutionTest.assertTrue((outXml.indexOf("<changes>") > -1 ? 1 : 0) != 0);
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='person'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Person>";
        inXml = inXml + "      <name>mark</name>";
        inXml = inXml + "    </org.kie.camel.testdomain.Person>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <insert out-identifier='changes'>";
        inXml = inXml + "    <org.kie.camel.testdomain.ChangeCollector/>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        XStreamBatchExecutionTest.assertTrue((outXml.indexOf("<retracted>") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testInsertWithDefaults() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='outStilton'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        XStreamBatchExecutionTest.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        stilton = (Cheese)ksession.getObject(factHandle);
        XStreamBatchExecutionTest.assertEquals((long)30L, (long)stilton.getPrice());
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier=\"outStilton\">\n";
        expectedXml = expectedXml + "    <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "      <type>stilton</type>\n";
        expectedXml = expectedXml + "      <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      <price>30</price>\n";
        expectedXml = expectedXml + "    </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <fact-handle identifier=\"outStilton\" external-form=\"" + ((InternalFactHandle)result.getFactHandle("outStilton")).toExternalForm() + "\" /> \n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testInsertWithReturnObjectFalse() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='outStilton' return-object='false'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        XStreamBatchExecutionTest.assertNull((Object)result.getValue("outStilton"));
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        Cheese stilton = (Cheese)ksession.getObject(factHandle);
        XStreamBatchExecutionTest.assertEquals((long)30L, (long)stilton.getPrice());
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <fact-handle identifier=\"outStilton\" external-form=\"" + ((InternalFactHandle)result.getFactHandle("outStilton")).toExternalForm() + "\" /> \n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testGetObject() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='outStilton'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        XStreamBatchExecutionTest.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <get-object out-identifier='outStilton' fact-handle='" + factHandle.toExternalForm() + "' />";
        inXml = inXml + "</batch-execution>";
        outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        stilton = (Cheese)result.getValue("outStilton");
        XStreamBatchExecutionTest.assertEquals((long)30L, (long)stilton.getPrice());
    }

    @Test
    public void testRetractObject() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='outStilton'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        XStreamBatchExecutionTest.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <retract fact-handle='" + factHandle.toExternalForm() + "' />";
        inXml = inXml + "</batch-execution>";
        this.template.requestBody("direct:exec", (Object)inXml, String.class);
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <get-object out-identifier='outStilton' fact-handle='" + factHandle.toExternalForm() + "' />";
        inXml = inXml + "</batch-execution>";
        outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        XStreamBatchExecutionTest.assertNull((Object)result.getValue("outStilton"));
    }

    @Test
    public void testModifyObject() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='outStilton'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        XStreamBatchExecutionTest.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier=\"outStilton\">\n";
        expectedXml = expectedXml + "    <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "      <type>stilton</type>\n";
        expectedXml = expectedXml + "      <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      <price>30</price>\n";
        expectedXml = expectedXml + "    </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <fact-handle identifier=\"outStilton\" external-form=\"" + factHandle.toExternalForm() + "\" /> \n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <modify fact-handle='" + factHandle.toExternalForm() + "'> <set accessor='oldPrice' value='42' /><set accessor='price' value='50' /></modify>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        this.template.requestBody("direct:exec", (Object)inXml, String.class);
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <get-object out-identifier='outCheddar' fact-handle='" + factHandle.toExternalForm() + "' />";
        inXml = inXml + "</batch-execution>";
        this.setExec((CommandExecutor)ksession);
        outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        Cheese cheddar = (Cheese)result.getValue("outCheddar");
        XStreamBatchExecutionTest.assertEquals((long)42L, (long)cheddar.getOldPrice());
        XStreamBatchExecutionTest.assertEquals((long)55L, (long)cheddar.getPrice());
        ModifyCommand.ALLOW_MODIFY_EXPRESSIONS = false;
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <modify fact-handle='" + factHandle.toExternalForm() + "'> <set accessor='type' value='44\"; System.exit(1);' /><set accessor='price' value='50' /></modify>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        result = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        ModifyCommand.ALLOW_MODIFY_EXPRESSIONS = true;
    }

    @Test
    public void testInsertElements() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "     list.add( $c );";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <set-global identifier='list' out-identifier='list' return-objects='true'>";
        inXml = inXml + "    <list/>";
        inXml = inXml + "  </set-global>";
        inXml = inXml + "  <insert-elements>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>30</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert-elements>";
        inXml = inXml + "</batch-execution>";
        StatelessKieSession ksession = this.getStatelessKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier='list'>\n";
        expectedXml = expectedXml + "    <list>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <type>stilton</type>\n";
        expectedXml = expectedXml + "        <price>35</price>\n";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <type>stilton</type>\n";
        expectedXml = expectedXml + "        <price>30</price>\n";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "    </list>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        List list = (List)result.getValue("list");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        XStreamBatchExecutionTest.assertEquals(expectedList, new HashSet(list));
    }

    @Test
    public void testFactHandleReturn() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    System.err.println(42); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <get-global identifier='list' out-identifier='out-list'/>";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        FactHandle fh = ksession.insert((Object)new Person("mic", 42));
        ArrayList<FactHandle> list = new ArrayList<FactHandle>();
        list.add(fh);
        ksession.setGlobal("list", list);
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        System.err.println(outXml);
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n  <result identifier=\"out-list\">\n    <list>\n      <fact-handle external-form=\"" + fh.toExternalForm() + "\"/>\n" + "    </list>\n" + "  </result>\n" + "</execution-results>";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testInsertElementsWithReturnObjects() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "     list.add( $c );";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <set-global identifier='list' out-identifier='list' >";
        inXml = inXml + "    <list/>";
        inXml = inXml + "  </set-global>";
        inXml = inXml + "  <insert-elements out-identifier='myfacts' return-objects='true'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>30</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert-elements>";
        inXml = inXml + "  <fire-all-rules/>";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        Collection factHandles = ksession.getFactHandles();
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier='list'>\n";
        expectedXml = expectedXml + "    <list>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <type>stilton</type>\n";
        expectedXml = expectedXml + "        <price>35</price>\n";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <type>stilton</type>\n";
        expectedXml = expectedXml + "        <price>30</price>\n";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "    </list>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <result identifier=\"myfacts\">\n";
        expectedXml = expectedXml + "  <list>\n";
        expectedXml = expectedXml + "    <org.kie.camel.testdomain.Cheese reference=\"../../../result/list/org.kie.camel.testdomain.Cheese[2]\"/>\n";
        expectedXml = expectedXml + "    <org.kie.camel.testdomain.Cheese reference=\"../../../result/list/org.kie.camel.testdomain.Cheese\"/>\n";
        expectedXml = expectedXml + "  </list>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <fact-handles identifier=\"myfacts\">\n";
        for (FactHandle factHandle : factHandles) {
            if (((Cheese)ksession.getObject(factHandle)).getPrice() != 30) continue;
            expectedXml = expectedXml + "  <fact-handle external-form=\"" + factHandle.toExternalForm() + "\"/>\n";
        }
        for (FactHandle factHandle : factHandles) {
            if (((Cheese)ksession.getObject(factHandle)).getPrice() != 35) continue;
            expectedXml = expectedXml + "  <fact-handle external-form=\"" + factHandle.toExternalForm() + "\"/>\n";
        }
        expectedXml = expectedXml + "  </fact-handles>\n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        List list = (List)result.getValue("list");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        XStreamBatchExecutionTest.assertEquals(expectedList, new HashSet(list));
    }

    @Test
    public void testSetGlobal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "global java.util.List list2 \n";
        str = str + "global java.util.List list3 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( 30 ); \n";
        str = str + "    list1.add( $c ); \n";
        str = str + "    list2.add( $c ); \n";
        str = str + "    list3.add( $c ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <set-global identifier='list1'>";
        inXml = inXml + "    <list/>";
        inXml = inXml + "  </set-global>";
        inXml = inXml + "  <set-global identifier='list2' out-identifier='list2'>";
        inXml = inXml + "    <list/>";
        inXml = inXml + "  </set-global>";
        inXml = inXml + "  <set-global identifier='list3' out-identifier='outList3'>";
        inXml = inXml + "    <list/>";
        inXml = inXml + "  </set-global>";
        inXml = inXml + "  <insert>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>5</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "  </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "</batch-execution>";
        StatelessKieSession ksession = this.getStatelessKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier='list2'>\n";
        expectedXml = expectedXml + "    <list>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <type>stilton</type>\n";
        expectedXml = expectedXml + "        <price>30</price>\n";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "    </list>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <result identifier='outList3'>\n";
        expectedXml = expectedXml + "    <list>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese reference='../../../result/list/org.kie.camel.testdomain.Cheese'/>\n";
        expectedXml = expectedXml + "    </list>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        Cheese stilton = new Cheese("stilton", 30);
        XStreamBatchExecutionTest.assertNull((Object)result.getValue("list1"));
        List list2 = (List)result.getValue("list2");
        XStreamBatchExecutionTest.assertEquals((long)1L, (long)list2.size());
        XStreamBatchExecutionTest.assertEquals((Object)stilton, list2.get(0));
        List list3 = (List)result.getValue("outList3");
        XStreamBatchExecutionTest.assertEquals((long)1L, (long)list3.size());
        XStreamBatchExecutionTest.assertEquals((Object)stilton, list3.get(0));
    }

    @Test
    public void testGetGlobal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    list.add( $c ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <set-global identifier='list'>";
        inXml = inXml + "    <list/>";
        inXml = inXml + "  </set-global>";
        inXml = inXml + "  <insert>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <get-global identifier='list' out-identifier='out-list'/>";
        inXml = inXml + "</batch-execution>";
        StatelessKieSession ksession = this.getStatelessKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier=\"out-list\">\n";
        expectedXml = expectedXml + "    <list>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <type>stilton</type>\n";
        expectedXml = expectedXml + "        <price>25</price>\n";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "    </list>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Ignore(value="The result XML structure has changed 08-MON-2011 -Rikkola-")
    @Test
    public void FIXME_testQuery() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        str = str + "query cheesesWithParams(String a, String b) \n";
        str = str + "    stilton : Cheese(type == a) \n";
        str = str + "    cheddar : Cheese(type == b, price == stilton.price) \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>1</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <insert>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>2</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <insert>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>cheddar</type>";
        inXml = inXml + "      <price>1</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <insert>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>cheddar</type>";
        inXml = inXml + "      <price>2</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <query out-identifier='cheeses' name='cheeses'/>";
        inXml = inXml + "  <query out-identifier='cheeses2' name='cheesesWithParams'>";
        inXml = inXml + "    <string>stilton</string>";
        inXml = inXml + "    <string>cheddar</string>";
        inXml = inXml + "  </query>";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        Iterator it1 = ksession.getQueryResults("cheeses", new Object[0]).iterator();
        Iterator it2 = ksession.getQueryResults("cheesesWithParams", (Object[])new String[]{"stilton", "cheddar"}).iterator();
        QueryResultsRow row = null;
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier='cheeses'>\n";
        expectedXml = expectedXml + "    <query-results>\n";
        expectedXml = expectedXml + "      <identifiers>\n";
        expectedXml = expectedXml + "        <identifier>stilton</identifier>\n";
        expectedXml = expectedXml + "        <identifier>cheddar</identifier>\n";
        expectedXml = expectedXml + "      </identifiers>\n";
        expectedXml = expectedXml + "      <row>\n";
        row = (QueryResultsRow)it1.next();
        expectedXml = expectedXml + "        <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "          <type>stilton</type>\n";
        expectedXml = expectedXml + "          <price>1</price>\n";
        expectedXml = expectedXml + "          <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "        </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <fact-handle external-form='" + row.getFactHandle("stilton").toExternalForm() + "' />";
        expectedXml = expectedXml + "        <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "          <type>cheddar</type>\n";
        expectedXml = expectedXml + "          <price>1</price>\n";
        expectedXml = expectedXml + "          <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "        </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <fact-handle external-form='" + row.getFactHandle("cheddar").toExternalForm() + "' />";
        expectedXml = expectedXml + "      </row>\n";
        expectedXml = expectedXml + "      <row>\n";
        row = (QueryResultsRow)it1.next();
        expectedXml = expectedXml + "        <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "          <type>stilton</type>\n";
        expectedXml = expectedXml + "          <price>2</price>\n";
        expectedXml = expectedXml + "          <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "        </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <fact-handle external-form='" + row.getFactHandle("stilton").toExternalForm() + "' />";
        expectedXml = expectedXml + "        <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "          <type>cheddar</type>\n";
        expectedXml = expectedXml + "          <price>2</price>\n";
        expectedXml = expectedXml + "          <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "        </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <fact-handle external-form='" + row.getFactHandle("cheddar").toExternalForm() + "' />";
        expectedXml = expectedXml + "      </row>\n";
        expectedXml = expectedXml + "    </query-results>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <result identifier='cheeses2'>\n";
        expectedXml = expectedXml + "    <query-results>\n";
        expectedXml = expectedXml + "      <identifiers>\n";
        expectedXml = expectedXml + "        <identifier>stilton</identifier>\n";
        expectedXml = expectedXml + "        <identifier>cheddar</identifier>\n";
        expectedXml = expectedXml + "      </identifiers>\n";
        expectedXml = expectedXml + "      <row>\n";
        row = (QueryResultsRow)it2.next();
        expectedXml = expectedXml + "        <org.kie.camel.testdomain.Cheese reference=\"../../../../result/query-results/row/org.kie.camel.testdomain.Cheese\"/>\n";
        expectedXml = expectedXml + "        <fact-handle external-form='" + row.getFactHandle("stilton").toExternalForm() + "' />";
        expectedXml = expectedXml + "        <org.kie.camel.testdomain.Cheese reference=\"../../../../result/query-results/row/org.kie.camel.testdomain.Cheese[2]\"/>\n";
        expectedXml = expectedXml + "        <fact-handle external-form='" + row.getFactHandle("cheddar").toExternalForm() + "' />";
        expectedXml = expectedXml + "      </row>\n";
        expectedXml = expectedXml + "      <row>\n";
        row = (QueryResultsRow)it2.next();
        expectedXml = expectedXml + "        <org.kie.camel.testdomain.Cheese reference=\"../../../../result/query-results/row[2]/org.kie.camel.testdomain.Cheese\"/>\n";
        expectedXml = expectedXml + "        <fact-handle external-form='" + row.getFactHandle("stilton").toExternalForm() + "' />";
        expectedXml = expectedXml + "        <org.kie.camel.testdomain.Cheese reference=\"../../../../result/query-results/row[2]/org.kie.camel.testdomain.Cheese[2]\"/>\n";
        expectedXml = expectedXml + "        <fact-handle external-form='" + row.getFactHandle("cheddar").toExternalForm() + "' />";
        expectedXml = expectedXml + "      </row>\n";
        expectedXml = expectedXml + "    </query-results>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        ExecutionResults batchResult = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        QueryResults results = (QueryResults)batchResult.getValue("cheeses");
        XStreamBatchExecutionTest.assertEquals((long)2L, (long)results.size());
        XStreamBatchExecutionTest.assertEquals((long)2L, (long)results.getIdentifiers().length);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        XStreamBatchExecutionTest.assertEquals(set, newSet);
    }

    @Test
    public void testGetObjects() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert-elements>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>30</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert-elements>";
        inXml = inXml + "  <get-objects out-identifier='list' />";
        inXml = inXml + "</batch-execution>";
        StatelessKieSession ksession = this.getStatelessKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>";
        expectedXml = expectedXml + "  <result identifier='list'>";
        expectedXml = expectedXml + "    <list>";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>";
        expectedXml = expectedXml + "        <type>stilton</type>";
        expectedXml = expectedXml + "        <price>30</price>";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>";
        expectedXml = expectedXml + "        <type>stilton</type>";
        expectedXml = expectedXml + "        <price>35</price>";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>";
        expectedXml = expectedXml + "    </list>";
        expectedXml = expectedXml + "  </result>";
        expectedXml = expectedXml + "</execution-results>";
        this.assertXMLEqual(expectedXml, outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        List list = (List)result.getValue("list");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        XStreamBatchExecutionTest.assertEquals(expectedList, new HashSet(list));
    }

    @Test
    public void testManualFireAllRules() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.kie.camel.testdomain.Cheese \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "    list.add( $c );";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <set-global identifier='list' out-identifier='list'>";
        inXml = inXml + "    <list/>";
        inXml = inXml + "  </set-global>";
        inXml = inXml + "  <insert-elements>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>30</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert-elements>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "  <insert out-identifier='outBrie'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "      <type>brie</type>";
        inXml = inXml + "      <price>10</price>";
        inXml = inXml + "      <oldPrice>5</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        FactHandle factHandle = (FactHandle)((ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml)).getFactHandle("outBrie");
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier='list'>\n";
        expectedXml = expectedXml + "    <list>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <type>stilton</type>\n";
        expectedXml = expectedXml + "        <price>35</price>\n";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "      <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "        <type>stilton</type>\n";
        expectedXml = expectedXml + "        <price>30</price>\n";
        expectedXml = expectedXml + "        <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "    </list>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <result identifier='outBrie'>\n";
        expectedXml = expectedXml + "    <org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "      <type>brie</type>\n";
        expectedXml = expectedXml + "      <price>10</price>\n";
        expectedXml = expectedXml + "      <oldPrice>5</oldPrice>\n";
        expectedXml = expectedXml + "    </org.kie.camel.testdomain.Cheese>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <fact-handle identifier=\"outBrie\" external-form=\"" + factHandle.toExternalForm() + "\" /> \n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        List list = (List)result.getValue("list");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        XStreamBatchExecutionTest.assertEquals(expectedList, new HashSet(list));
        Cheese brie10 = new Cheese("brie", 10);
        brie10.setOldPrice(5);
        XStreamBatchExecutionTest.assertEquals((Object)brie10, (Object)result.getValue("outBrie"));
    }

    @Test
    public void testProcess() throws SAXException, IOException {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <imports>\n";
        str = str + "      <import name=\"org.kie.camel.testdomain.TestVariable\" />\n";
        str = str + "    </imports>\n";
        str = str + "    <globals>\n";
        str = str + "      <global identifier=\"list\" type=\"java.util.List\" />\n";
        str = str + "    </globals>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"person\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"TestVariable\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <actionNode id=\"2\" name=\"MyActionNode\" >\n";
        str = str + "      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\n";
        str = str + "list.add(person.name);\n";
        str = str + "</action>\n";
        str = str + "    </actionNode>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n\n";
        str = str + "</process>";
        StatelessKieSession ksession = this.getStatelessKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        this.setExec((CommandExecutor)ksession);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        TestVariable person = new TestVariable("John Doe");
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <start-process processId='org.drools.actions'>";
        inXml = inXml + "    <parameter identifier='person'>";
        inXml = inXml + "       <org.kie.camel.testdomain.TestVariable>";
        inXml = inXml + "         <name>John Doe</name>";
        inXml = inXml + "    </org.kie.camel.testdomain.TestVariable>";
        inXml = inXml + "    </parameter>";
        inXml = inXml + "  </start-process>";
        inXml = inXml + "  <get-global identifier='list' out-identifier='out-list'/>";
        inXml = inXml + "</batch-execution>";
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        XStreamBatchExecutionTest.assertEquals((long)1L, (long)list.size());
        XStreamBatchExecutionTest.assertEquals((Object)"John Doe", list.get(0));
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier=\"out-list\">\n";
        expectedXml = expectedXml + "    <list>\n";
        expectedXml = expectedXml + "      <string>John Doe</string>\n";
        expectedXml = expectedXml + "    </list>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testProcessInstanceSignalEvent() throws Exception {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.core.event\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"MyVar\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>SomeText</value>\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <eventNode id=\"2\" name=\"Event\" variableName=\"MyVar\" >\n";
        str = str + "      <eventFilters>\n";
        str = str + "        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n";
        str = str + "      </eventFilters>\n";
        str = str + "    </eventNode>\n";
        str = str + "    <join id=\"3\" name=\"Join\" type=\"1\" />\n";
        str = str + "    <end id=\"4\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"3\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "    <connection from=\"3\" to=\"4\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        KieSession ksession = this.getKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.event");
        XStreamBatchExecutionTest.assertEquals((long)1L, (long)processInstance.getState());
        String inXml = "";
        inXml = inXml + "<signal-event process-instance-id= '" + processInstance.getId() + "' event-type='MyEvent'>";
        inXml = inXml + "    <string>MyValue</string>";
        inXml = inXml + "</signal-event>";
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        XStreamBatchExecutionTest.assertEquals((long)2L, (long)processInstance.getState());
        XStreamBatchExecutionTest.assertEquals((Object)"MyValue", (Object)((VariableScopeInstance)((org.jbpm.process.instance.ProcessInstance)processInstance).getContextInstance("VariableScope")).getVariable("MyVar"));
    }

    @Test
    public void testProcessRuntimeSignalEvent() throws Exception {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.core.event\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"MyVar\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>SomeText</value>\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <eventNode id=\"2\" name=\"Event\" scope=\"external\" variableName=\"MyVar\" >\n";
        str = str + "      <eventFilters>\n";
        str = str + "        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n";
        str = str + "      </eventFilters>\n";
        str = str + "    </eventNode>\n";
        str = str + "    <join id=\"3\" name=\"Join\" type=\"1\" />\n";
        str = str + "    <end id=\"4\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"3\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "    <connection from=\"3\" to=\"4\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        KieSession ksession = this.getKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        ProcessInstance processInstance = ksession.startProcess("org.drools.core.event");
        XStreamBatchExecutionTest.assertEquals((long)1L, (long)processInstance.getState());
        String inXml = "";
        inXml = inXml + "<signal-event event-type='MyEvent'>";
        inXml = inXml + "    <string>MyValue</string>";
        inXml = inXml + "</signal-event>";
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        XStreamBatchExecutionTest.assertEquals((long)2L, (long)processInstance.getState());
        XStreamBatchExecutionTest.assertEquals((Object)"MyValue", (Object)((VariableScopeInstance)((org.jbpm.process.instance.ProcessInstance)processInstance).getContextInstance("VariableScope")).getVariable("MyVar"));
    }

    @Test
    public void testCompleteWorkItem() {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"UserName\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>John Doe</value>\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Person\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"org.kie.camel.testdomain.Person\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"MyObject\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" className=\"java.lang.String\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Number\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.IntegerDataType\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <workItem id=\"2\" name=\"HumanTask\" >\n";
        str = str + "      <work name=\"Human Task\" >\n";
        str = str + "        <parameter name=\"ActorId\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{UserName}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Content\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{Person.name}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"TaskName\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>Do something</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Priority\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Comment\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Attachment\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n";
        str = str + "        </parameter>\n";
        str = str + "      </work>\n";
        str = str + "      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />";
        str = str + "      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />";
        str = str + "      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />";
        str = str + "      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />";
        str = str + "    </workItem>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        KieSession ksession = this.getKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        XStreamBatchExecutionTest.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        XStreamBatchExecutionTest.assertNotNull((Object)workItem);
        XStreamBatchExecutionTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("ActorId"));
        XStreamBatchExecutionTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Content"));
        XStreamBatchExecutionTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Comment"));
        XStreamBatchExecutionTest.assertEquals((long)0L, (long)workItem.getState());
        String inXml = "";
        inXml = "<complete-work-item id='" + workItem.getId() + "' />";
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        XStreamBatchExecutionTest.assertEquals((long)2L, (long)workItem.getState());
        XStreamBatchExecutionTest.assertEquals((long)2L, (long)processInstance.getState());
        parameters = new HashMap();
        parameters.put("UserName", "Jane Doe");
        parameters.put("MyObject", "SomeString");
        person = new Person();
        person.setName("Jane Doe");
        parameters.put("Person", person);
        processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        XStreamBatchExecutionTest.assertEquals((long)1L, (long)processInstance.getState());
        workItem = handler.getWorkItem();
        XStreamBatchExecutionTest.assertNotNull((Object)workItem);
        XStreamBatchExecutionTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("ActorId"));
        XStreamBatchExecutionTest.assertEquals((Object)"SomeString", (Object)workItem.getParameter("Attachment"));
        XStreamBatchExecutionTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Content"));
        XStreamBatchExecutionTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Comment"));
        XStreamBatchExecutionTest.assertEquals((long)0L, (long)workItem.getState());
        inXml = "";
        inXml = inXml + "<complete-work-item id='" + workItem.getId() + "' >";
        inXml = inXml + "    <result identifier='Result'>";
        inXml = inXml + "        <string>SomeOtherString</string>";
        inXml = inXml + "    </result>";
        inXml = inXml + "</complete-work-item>";
        outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        XStreamBatchExecutionTest.assertEquals((long)2L, (long)workItem.getState());
        XStreamBatchExecutionTest.assertEquals((long)2L, (long)processInstance.getState());
        XStreamBatchExecutionTest.assertEquals((Object)"SomeOtherString", (Object)processInstance.getVariable("MyObject"));
        XStreamBatchExecutionTest.assertEquals((Object)15, (Object)processInstance.getVariable("Number"));
    }

    @Test
    public void testAbortWorkItem() {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"UserName\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>John Doe</value>\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Person\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"org.kie.camel.testdomain.Person\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"MyObject\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" className=\"java.lang.String\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Number\" >\n";
        str = str + "        <type name=\"org.drools.core.process.core.datatype.impl.type.IntegerDataType\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <workItem id=\"2\" name=\"HumanTask\" >\n";
        str = str + "      <work name=\"Human Task\" >\n";
        str = str + "        <parameter name=\"ActorId\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{UserName}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Content\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{Person.name}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"TaskName\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>Do something</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Priority\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Comment\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Attachment\" >\n";
        str = str + "          <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n";
        str = str + "        </parameter>\n";
        str = str + "      </work>\n";
        str = str + "      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />";
        str = str + "      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />";
        str = str + "      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />";
        str = str + "      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />";
        str = str + "    </workItem>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        KieSession ksession = this.getKieSessionFromResource(ResourceFactory.newByteArrayResource((byte[])str.getBytes()).setSourcePath("src/main/resources/rule.rf").setResourceType(ResourceType.DRF));
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        XStreamBatchExecutionTest.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        XStreamBatchExecutionTest.assertNotNull((Object)workItem);
        XStreamBatchExecutionTest.assertEquals((long)0L, (long)workItem.getState());
        String inXml = "<abort-work-item id='" + workItem.getId() + "' />";
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        XStreamBatchExecutionTest.assertEquals((long)3L, (long)workItem.getState());
    }

    @Test
    public void testInsertObjectWithDeclaredFact() throws Exception {
        String str = "";
        str = str + "package org.foo \n";
        str = str + "declare Whee \n\ttype: String\n\tprice: Integer\n\toldPrice: Integer\nend\n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Whee() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert out-identifier='outStilton'>";
        inXml = inXml + "    <org.foo.Whee>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.foo.Whee>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        ClassLoader cl = ((StatefulKnowledgeSessionImpl)ksession).getKnowledgeBase().getRootClassLoader();
        XStream xstream = BatchExecutionHelper.newXStreamMarshaller();
        xstream.setClassLoader(cl);
        FactHandle factHandle = (FactHandle)((ExecutionResults)xstream.fromXML(outXml)).getFactHandle("outStilton");
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier=\"outStilton\">\n";
        expectedXml = expectedXml + "    <org.foo.Whee>\n";
        expectedXml = expectedXml + "      <type>stilton</type>\n";
        expectedXml = expectedXml + "      <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      <price>30</price>\n";
        expectedXml = expectedXml + "    </org.foo.Whee>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <fact-handle identifier=\"outStilton\" external-form=\"" + factHandle.toExternalForm() + "\" /> \n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testInsertObjectStateful() throws Exception {
        String str = "";
        str = str + "package org.foo \n";
        str = str + "declare Whee \n\ttype: String\n\tprice: Integer\n\toldPrice: Integer\nend\n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Whee(price < 30) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n update($c);\n";
        str = str + "end\n";
        str = str + "query results\n";
        str = str + "    w: Whee(price == 30)";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <insert>";
        inXml = inXml + "    <org.foo.Whee>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.foo.Whee>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        String outXml = (String)this.template.requestBody("direct:exec", (Object)inXml, String.class);
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        outXml = (String)this.template.requestBody("direct:exec", (Object)"<batch-execution><query out-identifier='matchingthings' name='results'/></batch-execution>", String.class);
        XStreamBatchExecutionTest.assertFalse((outXml.indexOf("<price>30</price>") > -1 ? 1 : 0) != 0);
        inXml = "";
        inXml = inXml + "<batch-execution>";
        inXml = inXml + "  <fire-all-rules max='100'/>";
        inXml = inXml + "</batch-execution>";
        this.template.requestBody("direct:exec", (Object)inXml, String.class);
        outXml = (String)this.template.requestBody("direct:exec", (Object)"<batch-execution><query out-identifier='matchingthings' name='results'/></batch-execution>", String.class);
        XStreamBatchExecutionTest.assertTrue((outXml.indexOf("<price>30</price>") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testExecutionNodeLookup() throws Exception {
        String str = "";
        str = str + "package org.kie.camel.testdomain \ndeclare Cheese1\n   type : String\n   price : int\n   oldPrice : int\nend \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese1() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String str2 = "";
        str2 = str2 + "package org.kie.camel.testdomain \ndeclare Cheese2\n   type : String\n   price : int\n   oldPrice : int\nend \n";
        str2 = str2 + "rule rule2 \n";
        str2 = str2 + "  when \n";
        str2 = str2 + "    $c : Cheese2() \n";
        str2 = str2 + " \n";
        str2 = str2 + "  then \n";
        str2 = str2 + "    $c.setPrice( $c.getPrice() + 10 ); \n";
        str2 = str2 + "end\n";
        String inXml = "";
        inXml = inXml + "<batch-execution lookup=\"ksession1\" >";
        inXml = inXml + "  <insert out-identifier='outStilton'>";
        inXml = inXml + "    <org.kie.camel.testdomain.Cheese1>";
        inXml = inXml + "      <type>stilton</type>";
        inXml = inXml + "      <price>25</price>";
        inXml = inXml + "      <oldPrice>0</oldPrice>";
        inXml = inXml + "    </org.kie.camel.testdomain.Cheese1>";
        inXml = inXml + "  </insert>";
        inXml = inXml + "  <fire-all-rules />";
        inXml = inXml + "</batch-execution>";
        String inXml2 = "";
        inXml2 = inXml2 + "<batch-execution lookup=\"ksession2\" >";
        inXml2 = inXml2 + "  <insert out-identifier='outStilton'>";
        inXml2 = inXml2 + "    <org.kie.camel.testdomain.Cheese2>";
        inXml2 = inXml2 + "      <type>stilton</type>";
        inXml2 = inXml2 + "      <price>25</price>";
        inXml2 = inXml2 + "      <oldPrice>0</oldPrice>";
        inXml2 = inXml2 + "    </org.kie.camel.testdomain.Cheese2>";
        inXml2 = inXml2 + "  </insert>";
        inXml2 = inXml2 + "  <fire-all-rules />";
        inXml2 = inXml2 + "</batch-execution>";
        KieSession ksession = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        this.setExec((CommandExecutor)ksession);
        KieSession ksession2 = this.getKieSession(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()));
        this.setExec2((CommandExecutor)ksession2);
        String outXml = (String)this.template.requestBody("direct:execWithLookup", (Object)inXml, String.class);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader((CommandExecutor)ksession));
        ExecutionResults result = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml, ExecutionResults.class);
        FactType fT = ksession.getKieBase().getFactType("org.kie.camel.testdomain", "Cheese1");
        int price = (Integer)fT.get(result.getValue("outStilton"), "price");
        XStreamBatchExecutionTest.assertEquals((long)30L, (long)price);
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        String outXml2 = (String)this.template.requestBody("direct:execWithLookup", (Object)inXml2, String.class);
        Thread.currentThread().setContextClassLoader(this.getClassLoader((CommandExecutor)ksession2));
        ExecutionResults result2 = (ExecutionResults)this.template.requestBody("direct:unmarshal", (Object)outXml2, ExecutionResults.class);
        FactType fT2 = ksession2.getKieBase().getFactType("org.kie.camel.testdomain", "Cheese2");
        int price2 = (Integer)fT2.get(result2.getValue("outStilton"), "price");
        XStreamBatchExecutionTest.assertEquals((long)35L, (long)price2);
        factHandle = (FactHandle)result2.getFactHandle("outStilton");
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        String expectedXml = "";
        expectedXml = expectedXml + "<execution-results>\n";
        expectedXml = expectedXml + "  <result identifier=\"outStilton\">\n";
        expectedXml = expectedXml + "    <org.kie.camel.testdomain.Cheese1>\n";
        expectedXml = expectedXml + "      <type>stilton</type>\n";
        expectedXml = expectedXml + "      <oldPrice>0</oldPrice>\n";
        expectedXml = expectedXml + "      <price>30</price>\n";
        expectedXml = expectedXml + "    </org.kie.camel.testdomain.Cheese1>\n";
        expectedXml = expectedXml + "  </result>\n";
        expectedXml = expectedXml + "  <fact-handle identifier=\"outStilton\" external-form=\"" + ((InternalFactHandle)result.getFactHandle("outStilton")).toExternalForm() + "\" /> \n";
        expectedXml = expectedXml + "</execution-results>\n";
        String expectedXml2 = "";
        expectedXml2 = expectedXml2 + "<execution-results>\n";
        expectedXml2 = expectedXml2 + "  <result identifier=\"outStilton\">\n";
        expectedXml2 = expectedXml2 + "    <org.kie.camel.testdomain.Cheese2>\n";
        expectedXml2 = expectedXml2 + "      <type>stilton</type>\n";
        expectedXml2 = expectedXml2 + "      <oldPrice>0</oldPrice>\n";
        expectedXml2 = expectedXml2 + "      <price>35</price>\n";
        expectedXml2 = expectedXml2 + "    </org.kie.camel.testdomain.Cheese2>\n";
        expectedXml2 = expectedXml2 + "  </result>\n";
        expectedXml2 = expectedXml2 + "  <fact-handle identifier=\"outStilton\" external-form=\"" + ((InternalFactHandle)result2.getFactHandle("outStilton")).toExternalForm() + "\" /> \n";
        expectedXml2 = expectedXml2 + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        this.assertXMLEqual(expectedXml2, outXml2);
    }

    private StatelessKieSession getStatelessKieSession(Resource resource) {
        return this.getStatelessKieSessionFromResource(resource.setSourcePath("src/main/resources/rule.drl").setResourceType(ResourceType.DRL));
    }

    private StatelessKieSession getStatelessKieSessionFromResource(Resource resource) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(resource);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (!errors.isEmpty()) {
            XStreamBatchExecutionTest.fail((String)("" + errors));
        }
        return ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newStatelessKieSession();
    }

    private KieSession getKieSession(Resource resource) {
        return this.getKieSessionFromResource(resource.setSourcePath("src/main/resources/rule.drl").setResourceType(ResourceType.DRL));
    }

    private KieSession getKieSessionFromResource(Resource resource) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(resource);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (!errors.isEmpty()) {
            XStreamBatchExecutionTest.fail((String)("" + errors));
        }
        return ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    public ClassLoader getClassLoader(CommandExecutor exec) {
        ClassLoader cl = null;
        if (exec instanceof StatefulKnowledgeSessionImpl) {
            cl = ((StatefulKnowledgeSessionImpl)exec).getKnowledgeBase().getRootClassLoader();
        } else if (exec instanceof StatelessKnowledgeSessionImpl) {
            cl = ((StatelessKnowledgeSessionImpl)exec).getKnowledgeBase().getRootClassLoader();
        } else if (exec instanceof CommandBasedStatefulKnowledgeSession) {
            cl = ((InternalKnowledgeBase)((CommandBasedStatefulKnowledgeSession)exec).getKieBase()).getRootClassLoader();
        }
        return cl;
    }

    public static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }
    }
}

