/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;
import org.kie.camel.BaseKieComponentTest;
import org.kie.camel.KieCamelUtils;
import org.kie.camel.KieComponent;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;

public class KieComponentOpOnUriTest
extends BaseKieComponentTest {
    @Test
    public void testBodyParam() throws Exception {
        DMNContext body = new DMNContext(){

            public Object set(String s, Object o) {
                throw new UnsupportedOperationException();
            }

            public Object get(String s) {
                throw new UnsupportedOperationException();
            }

            public Map<String, Object> getAll() {
                return Collections.emptyMap();
            }

            public boolean isDefined(String s) {
                throw new UnsupportedOperationException();
            }

            public DMNContext clone() {
                throw new UnsupportedOperationException();
            }
        };
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(KieCamelUtils.asCamelKieName((String)"containerId"), "containerId");
        this.template.sendBodyAndHeaders("direct:start", (Object)body, headers);
        this.assertMockEndpointsSatisfied();
        DMNResult result = (DMNResult)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(DMNResult.class);
        KieComponentOpOnUriTest.assertEquals((long)1L, (long)result.getDecisionResults().size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n     <capabilities>BPM</capabilities>\n     <capabilities>DMN</capabilities>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers/containerId/dmn")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<response type=\"SUCCESS\" msg=\"OK from container 'two-dmn-models'\">\n   <dmn-evaluation-result>\n       <model-namespace>https://github.com/kiegroup/kie-dmn/input-data-string</model-namespace>\n       <model-name>input-data-string</model-name>\n       <dmn-context xsi:type=\"jaxbListWrapper\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n           <type>MAP</type>\n           <element xsi:type=\"jaxbStringObjectPair\" key=\"Full Name\">\n               <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">John Doe</value>\n           </element>\n           <element xsi:type=\"jaxbStringObjectPair\" key=\"Greeting Message\">\n               <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">Hello John Doe</value>\n           </element>\n       </dmn-context>\n       <messages/>\n       <decisionResults>\n           <entry>\n               <key>d_GreetingMessage</key>\n               <value>\n                   <decision-id>d_GreetingMessage</decision-id>\n                   <decision-name>Greeting Message</decision-name>\n                   <result xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">Hello John Doe</result>\n                   <status>SUCCEEDED</status>\n               </value>\n           </entry>\n       </decisionResults>\n   </dmn-evaluation-result>\n</response>")));
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("kie:" + KieComponentOpOnUriTest.this.getAuthenticadUrl("admin", "admin") + "?client=dmn&operation=evaluateAllDecisions")).to("mock:result");
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        KieComponent kieComponent = new KieComponent();
        kieComponent.getConfiguration().clearBodyParams().setBodyParam("process", "signal", "event").setBodyParam("dmn", "evaluateAllDecisions", "dmnContext");
        context.addComponent("kie", (Component)kieComponent);
        return context;
    }
}

