/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.camel.component;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.util.jndi.JndiContext;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.command.Command;
import org.kie.api.io.KieResources;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.camel.embedded.camel.testdomain.Person;
import org.kie.camel.embedded.component.KiePolicy;
import org.kie.internal.command.CommandFactory;

public class JsonQueryTest {
    private ProducerTemplate template;

    private CamelContext configure(KieSession session) throws Exception {
        JndiContext context = new JndiContext();
        context.bind("ksession", (Object)session);
        DefaultCamelContext camelContext = new DefaultCamelContext((Context)context);
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-session").policy((Policy)new KiePolicy()).unmarshal("json")).to("kie-local://ksession")).marshal("json");
                this.from("direct:unmarshall").policy((Policy)new KiePolicy()).unmarshal("json");
                this.from("direct:marshall").policy((Policy)new KiePolicy()).marshal("json");
            }
        });
        return camelContext;
    }

    private void initializeTemplate(KieSession session) throws Exception {
        CamelContext context = this.configure(session);
        this.template = context.createProducerTemplate();
        context.start();
    }

    private KieSession getKieSession() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieResources kieResources = ks.getResources();
        kfs.write(kieResources.newClassPathResource("getOlder.drl", this.getClass()).setResourceType(ResourceType.DRL));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (!errors.isEmpty()) {
            TestCase.fail((String)("" + errors));
        }
        return ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @Test
    public void testQuery() throws Exception {
        KieSession session = this.getKieSession();
        this.initializeTemplate(session);
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(new Person("john", "john", 25));
        persons.add(new Person("sarah", "john", 35));
        session.execute(CommandFactory.newInsertElements(persons));
        Assert.assertEquals((long)2L, (long)session.getFactCount());
        QueryResults results = this.query("people over the age of x", new Object[]{30});
        Assert.assertNotNull((Object)results);
    }

    private QueryResults query(String queryName, Object[] args) {
        Command command = CommandFactory.newQuery((String)"persons", (String)queryName, (Object[])args);
        String queryStr = (String)this.template.requestBody("direct:marshall", (Object)command, String.class);
        String json = (String)this.template.requestBody("direct:test-session", (Object)queryStr, String.class);
        ExecutionResults res = (ExecutionResults)this.template.requestBody("direct:unmarshall", (Object)json);
        return (QueryResults)res.getValue("persons");
    }
}

