/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.camel.component;

import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ClaimCheckOperation;
import org.apache.camel.model.RouteDefinition;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieSession;
import org.kie.camel.embedded.camel.component.KieCamelTestSupport;
import org.kie.camel.embedded.dmn.DecisionsToHeadersProcessor;
import org.kie.camel.embedded.dmn.ToDMNEvaluateAllCommandProcessor;
import org.kie.camel.embedded.dmn.ToMapProcessor;
import org.kie.pipeline.camel.Person;

public class KieEmbeddedEndpointDMNTest
extends KieCamelTestSupport {
    @Test
    public void testDMN() throws Exception {
        Person johnDoe = new Person("John Doe", 47);
        Person alice = new Person("Alice", 18);
        Person bob = new Person("Bob", 17);
        Person charlie = new Person("Charlie", 21);
        MockEndpoint canDrink = this.getMockEndpoint("mock:canDrink");
        canDrink.expectedMessageCount(3);
        canDrink.expectedBodiesReceived(new Object[]{johnDoe, alice, charlie});
        MockEndpoint noDrink = this.getMockEndpoint("mock:noDrink");
        noDrink.expectedMessageCount(1);
        noDrink.expectedBodiesReceived(new Object[]{bob});
        this.template.requestBody("direct:start", (Object)johnDoe);
        this.template.requestBody("direct:start", (Object)alice);
        this.template.requestBody("direct:start", (Object)bob);
        this.template.requestBody("direct:start", (Object)charlie);
        canDrink.assertIsSatisfied();
        noDrink.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        ToMapProcessor toMap = new ToMapProcessor("a person");
        ToDMNEvaluateAllCommandProcessor toDMNCommand = new ToDMNEvaluateAllCommandProcessor("https://kiegroup.org/dmn/_FD3D17D0-D23E-457E-B41A-380644F030A8", "Can Drink?", "dmnResult");
        DecisionsToHeadersProcessor dmnToHeader = DecisionsToHeadersProcessor.builder((String)"dmnResult", (String)"canDrinkHeader", (String)"Can Drink?").build();
        return new RouteBuilder((Processor)toMap, (Processor)toDMNCommand, (Processor)dmnToHeader){
            final /* synthetic */ Processor val$toMap;
            final /* synthetic */ Processor val$toDMNCommand;
            final /* synthetic */ Processor val$dmnToHeader;
            {
                this.val$toMap = processor;
                this.val$toDMNCommand = processor2;
                this.val$dmnToHeader = processor3;
            }

            public void configure() throws Exception {
                ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").claimCheck(ClaimCheckOperation.Push)).process(this.val$toMap)).process(this.val$toDMNCommand)).to("kie-local://ksession1?channel=default")).process(this.val$dmnToHeader)).claimCheck(ClaimCheckOperation.Pop)).to("log:org.kie.test?level=DEBUG&showAll=true&multiline=true")).choice().when(this.header("canDrinkHeader").isEqualTo((Object)true)).to("mock:canDrink")).otherwise().to("mock:noDrink");
            }
        };
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieResources kieResources = ks.getResources();
        kfs.write("src/main/resources/canDrink.dmn", kieResources.newClassPathResource("/dmn/canDrink.dmn", ((Object)((Object)this)).getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (!errors.isEmpty()) {
            KieEmbeddedEndpointDMNTest.fail((String)("" + errors));
        }
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        try {
            jndiContext.bind("ksession1", (Object)ksession);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

