/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.dmn;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.kie.api.runtime.ExecutionResults;
import org.kie.dmn.api.core.DMNResult;

public class DecisionsToHeadersProcessor
implements Processor {
    private final String outIdentifier;
    private final Map<String, String> toHeadersMap;

    public DecisionsToHeadersProcessor(String outIdentifier, Map<String, String> toHeadersMap) {
        Objects.requireNonNull(outIdentifier);
        Objects.requireNonNull(toHeadersMap);
        this.outIdentifier = outIdentifier;
        this.toHeadersMap = new HashMap<String, String>(toHeadersMap);
    }

    public void process(Exchange exchange) throws Exception {
        ExecutionResults body = (ExecutionResults)exchange.getIn().getBody(ExecutionResults.class);
        DMNResult value = (DMNResult)body.getValue(this.outIdentifier);
        for (Map.Entry<String, String> kv : this.toHeadersMap.entrySet()) {
            exchange.getIn().setHeader(kv.getKey(), value.getDecisionResultByName(kv.getValue()).getResult());
        }
    }

    public static Builder builder(String outIdentifier, String headerKey, String decisionName) {
        return new Builder(outIdentifier, headerKey, decisionName);
    }

    public static class Builder {
        private final String outIdentifier;
        private final Map<String, String> toHeadersMap = new HashMap<String, String>();

        public Builder(String outIdentifier, String headerKey, String decisionName) {
            Objects.requireNonNull(outIdentifier);
            Objects.requireNonNull(headerKey);
            Objects.requireNonNull(decisionName);
            this.outIdentifier = outIdentifier;
            this.toHeadersMap.put(headerKey, decisionName);
        }

        public Builder with(String headerKey, String decisionName) {
            Objects.requireNonNull(headerKey);
            Objects.requireNonNull(decisionName);
            this.toHeadersMap.put(headerKey, decisionName);
            return this;
        }

        public DecisionsToHeadersProcessor build() {
            return new DecisionsToHeadersProcessor(this.outIdentifier, this.toHeadersMap);
        }
    }
}

