/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.UriParam;
import org.kie.camel.KieServicesConfigurationCustomizer;

public class KieConfiguration
implements Cloneable {
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    private KieServicesConfigurationCustomizer kieServicesConfigurationCustomizer;
    private Map<String, String> bodyParams = new HashMap<String, String>();

    public KieConfiguration() {
        this.initBodyParams();
    }

    private void initBodyParams() {
        this.setBodyParam("process", "signal", "event");
        this.setBodyParam("dmn", "evaluateAll", "dmnContext");
        this.setBodyParam("dmn", "evaluateDecisionByName", "dmnContext");
        this.setBodyParam("dmn", "evaluateDecisionById", "dmnContext");
    }

    public void configure(String remaining) {
        String userInfo = null;
        try {
            userInfo = new URI(remaining).getUserInfo();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (userInfo != null) {
            String[] parts = userInfo.split(":");
            if (parts.length == 2) {
                this.setUsername(parts[0]);
                this.setPassword(parts[1]);
            } else {
                this.setUsername(userInfo);
            }
        }
    }

    public KieConfiguration copy() {
        try {
            KieConfiguration copy = (KieConfiguration)this.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public KieServicesConfigurationCustomizer getKieServicesConfigurationCustomizer() {
        return this.kieServicesConfigurationCustomizer;
    }

    public void setKieServicesConfigurationCustomizer(KieServicesConfigurationCustomizer kieServicesConfigurationCustomizer) {
        this.kieServicesConfigurationCustomizer = kieServicesConfigurationCustomizer;
    }

    public KieConfiguration setBodyParam(String serviceName, String methodName, String paramName) {
        this.bodyParams.put(serviceName + "." + methodName, paramName);
        return this;
    }

    public Optional<String> getBodyParam(String serviceName, String methodName) {
        return Optional.ofNullable(this.bodyParams.get(serviceName + "." + methodName));
    }

    public KieConfiguration clearBodyParams() {
        this.bodyParams.clear();
        return this;
    }
}

