/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.MavenRepository;

public class KieModuleBuilderTest
extends AbstractKieCiTest {
    @Test
    public void testKieModuleUsingPOMMissingKBaseDefinition() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "metadata-test2", "1.0-SNAPSHOT");
        String pomText = this.getPom(releaseId, new ReleaseId[0]);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        kfs.write("src/main/java/org/kie/test/Bean.java", this.createJavaSourceInPackage());
        KieBuilder kieBuilder1 = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder1.buildAll().getResults().getMessages().isEmpty());
        InternalKieModule kieModule = (InternalKieModule)kieBuilder1.getKieModule();
        MavenRepository.getMavenRepository().deployArtifact(releaseId, kieModule, pomFile);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "metadata-test-using-pom", "1.0-SNAPSHOT");
        String pomText2 = this.getPom(releaseId2, releaseId);
        File pomFile2 = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId2, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile2);
            fos.write(pomText2.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
        FileInputStream is = new FileInputStream(pomFile2);
        KieModuleModel kproj2 = ks.newKieModuleModel();
        kieFileSystem.write("pom.xml", KieServices.Factory.get().getResources().newInputStreamResource((InputStream)is));
        kieFileSystem.writeKModuleXML(kproj2.toXML());
        kieFileSystem.write("src/main/resources/rule.drl", this.createDRLWithImport("rule1"));
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
        kieBuilder.buildAll();
        junit.framework.Assert.assertTrue((boolean)kieBuilder.getResults().getMessages().isEmpty());
    }

    private String createJavaSourceInPackage() {
        return "package org.kie.test;\npublic class Bean {\n   private int value;\n   public int getValue() {\n       return value;\n   }\n}";
    }

    protected String createDRLWithImport(String ruleName) {
        return "import org.kie.test.Bean\nrule " + ruleName + "\n" + "when\n" + "Bean()\n" + "then\n" + "end\n";
    }
}

