/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.embedder;

import java.io.File;
import java.io.InputStream;
import org.apache.maven.project.MavenProject;
import org.kie.api.builder.KieScanner;
import org.kie.scanner.embedder.MavenEmbedder;
import org.kie.scanner.embedder.MavenRequest;
import org.kie.scanner.embedder.MavenSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectLoader {
    private static final Logger log = LoggerFactory.getLogger(KieScanner.class);
    private static MavenProject mavenProject;

    public static MavenProject parseMavenPom(File pomFile) {
        if (!pomFile.exists()) {
            return null;
        }
        MavenRequest mavenRequest = MavenProjectLoader.createMavenRequest();
        mavenRequest.setPom(pomFile.getAbsolutePath());
        try {
            MavenEmbedder mavenEmbedder = new MavenEmbedder(Thread.currentThread().getContextClassLoader(), mavenRequest);
            return mavenEmbedder.readProject(pomFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MavenProject parseMavenPom(InputStream pomStream) {
        MavenRequest mavenRequest = MavenProjectLoader.createMavenRequest();
        try {
            MavenEmbedder mavenEmbedder = new MavenEmbedder(Thread.currentThread().getContextClassLoader(), mavenRequest);
            return mavenEmbedder.readProject(pomStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static MavenRequest createMavenRequest() {
        MavenRequest mavenRequest = new MavenRequest();
        mavenRequest.setLocalRepositoryPath(MavenSettings.getSettings().getLocalRepository());
        mavenRequest.setResolveDependencies(true);
        return mavenRequest;
    }

    public static synchronized MavenProject loadMavenProject() {
        if (mavenProject == null) {
            File pomFile = new File("pom.xml");
            try {
                mavenProject = MavenProjectLoader.parseMavenPom(pomFile);
            }
            catch (Exception e) {
                log.warn("Unable to parse pom.xml file of the running project: " + e.getMessage());
            }
        }
        return mavenProject;
    }
}

