/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.util.Collection;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.eclipse.aether.repository.RemoteRepository;
import org.junit.Assert;
import org.junit.Test;
import org.kie.scanner.Aether;
import org.kie.scanner.MavenRepository;
import org.kie.scanner.MavenRepositoryConfiguration;

public class MavenRepositoryTest {
    @Test
    public void testMirrors() {
        MavenRepositoryMock repo = new MavenRepositoryMock(Aether.getAether());
        Collection remoteRepos = repo.getRemoteRepositoriesForRequest();
        Assert.assertEquals((long)2L, (long)remoteRepos.size());
        for (RemoteRepository remoteRepo : remoteRepos) {
            Assert.assertTrue((remoteRepo.getId().equals("qa") || remoteRepo.getId().equals("foo") ? 1 : 0) != 0);
        }
    }

    public static class MavenRepositoryMock
    extends MavenRepository {
        protected MavenRepositoryMock(Aether aether) {
            super(aether);
        }

        protected MavenRepositoryConfiguration getMavenRepositoryConfiguration() {
            return new MavenRepositoryConfiguration(this.getMavenSettings());
        }

        private Settings getMavenSettings() {
            String path = ((Object)((Object)this)).getClass().getResource(".").toString().substring("file:".length());
            File testSettingsFile = new File(path + "settings_with_mirror.xml");
            Assert.assertTrue((boolean)testSettingsFile.exists());
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(testSettingsFile);
            try {
                return settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

