/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.embedder;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.junit.Assert;
import org.junit.Test;
import org.kie.scanner.MavenRepositoryConfiguration;
import org.kie.scanner.embedder.MavenEmbedder;
import org.kie.scanner.embedder.MavenEmbedderException;
import org.kie.scanner.embedder.MavenRequest;
import org.kie.scanner.embedder.MavenSettings;

public class MavenEmbedderTest {
    @Test
    public void testExternalRepositories() {
        try {
            MavenRequest mavenRequest = MavenEmbedderTest.createMavenRequest();
            MavenEmbedderMock embedder = new MavenEmbedderMock(mavenRequest);
            MavenExecutionRequest request = embedder.buildMavenExecutionRequest(mavenRequest);
            Assert.assertNotNull((Object)request);
            List remoteRepositories = request.getRemoteRepositories();
            Assert.assertEquals((long)2L, (long)remoteRepositories.size());
            for (ArtifactRepository remoteRepository : remoteRepositories) {
                Assert.assertTrue((remoteRepository.getId().equals("central") || remoteRepository.getId().equals("kie-wb-m2-repo") ? 1 : 0) != 0);
            }
        }
        catch (MavenEmbedderException mee) {
            Assert.fail((String)mee.getMessage());
        }
        catch (ComponentLookupException cle) {
            Assert.fail((String)cle.getMessage());
        }
    }

    private static MavenRequest createMavenRequest() {
        MavenRequest mavenRequest = new MavenRequest();
        mavenRequest.setLocalRepositoryPath(MavenSettings.getSettings().getLocalRepository());
        mavenRequest.setUserSettingsFile(MavenSettings.getUserSettingsFile().getAbsolutePath());
        mavenRequest.setResolveDependencies(true);
        mavenRequest.setOffline(true);
        return mavenRequest;
    }

    public static class MavenEmbedderMock
    extends MavenEmbedder {
        public MavenEmbedderMock(MavenRequest mavenRequest) throws MavenEmbedderException {
            super(mavenRequest);
        }

        protected MavenRepositoryConfiguration getMavenRepositoryConfiguration() {
            return new MavenRepositoryConfiguration(this.getMavenSettings());
        }

        private Settings getMavenSettings() {
            String path = ((Object)((Object)this)).getClass().getResource(".").toString().substring("file:".length());
            File testSettingsFile = new File(path + "settings_with_repositories.xml");
            Assert.assertTrue((boolean)testSettingsFile.exists());
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(testSettingsFile);
            try {
                return settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

