/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.MavenRepository;

public class KieScannerIncrementalCompilationTest
extends AbstractKieCiTest {
    private final int FIRST_VALUE = 5;
    private final int SECOND_VALUE = 10;
    private FileManager fileManager;
    private ReleaseId releaseId;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        this.releaseId = KieServices.Factory.get().newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
    }

    @Test
    public void testChangeJavaClassButNotDrl() throws IOException {
        this.checkIncrementalCompilation(true);
    }

    @Test
    public void testChangeDrlNotUsingJava() throws IOException {
        this.checkIncrementalCompilation(false);
    }

    private void checkIncrementalCompilation(boolean useJavaInDrl) throws IOException {
        KieServices ks = KieServices.Factory.get();
        MavenRepository repository = MavenRepository.getMavenRepository();
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, this.releaseId, 5, useJavaInDrl);
        repository.installArtifact(this.releaseId, kJar1, this.createKPom(this.releaseId));
        KieContainer kieContainer = ks.newKieContainer(this.releaseId);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        this.checkValue(kieContainer, 5);
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, this.releaseId, 10, useJavaInDrl);
        repository.installArtifact(this.releaseId, kJar2, this.createKPom(this.releaseId));
        scanner.scanNow();
        this.checkValue(kieContainer, 10);
        ks.getRepository().removeKieModule(this.releaseId);
    }

    private void checkValue(KieContainer kieContainer, int value) {
        ArrayList list = new ArrayList();
        KieSession ksession = kieContainer.newKieSession("KSession1");
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertTrue((String)("Expected:<" + value + "> but was:<" + list.get(0) + ">"), ((Integer)list.get(0) == value ? 1 : 0) != 0);
    }

    private InternalKieModule createKieJarWithClass(KieServices ks, ReleaseId releaseId, int value, boolean useJavaInDrl) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        if (useJavaInDrl) {
            kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRLForJavaSource());
        } else {
            kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRLNotUsingJava(value));
        }
        kfs.write("src/main/java/org/kie/test/Value.java", this.createJavaSource(value));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((String)"", (boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    private String createDRLForJavaSource() {
        return "package org.kie.test\nglobal java.util.List list\nrule simple\nwhen\nthen\n   list.add(Value.getValue());\nend\n";
    }

    private String createDRLNotUsingJava(int value) {
        return "package org.kie.test\nglobal java.util.List list\nrule simple\nwhen\nthen\n   list.add(" + value + ");\nend\n";
    }

    @Override
    protected String createJavaSource(int value) {
        return "package org.kie.test;\npublic class Value {\n   public static int getValue() {\n      return " + value + ";\n   }\n}";
    }

    private File createKPom(ReleaseId releaseId) throws IOException {
        File pomFile = this.fileManager.newFile("pom.xml");
        this.fileManager.write(pomFile, this.getPom(releaseId, new ReleaseId[0]));
        return pomFile;
    }
}

