/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.junit.Assert;
import org.junit.Test;
import org.kie.scanner.Aether;
import org.kie.scanner.embedder.MavenSettings;

public class AetherTest {
    private final String SETTINGS_WITH_PROXY = "<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\">  <proxies>\n    <proxy>\n      <id>MyProxy</id>\n      <active>true</active>\n      <protocol>http</protocol>\n      <host>localhost</host>\n      <port>8888</port>\n    </proxy>\n  </proxies></settings>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxies() {
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            if (oldSettingsXmlPath != null) {
                System.clearProperty("kie.maven.settings.custom");
            }
            MavenSettings.reinitSettingsFromString((String)"<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\">  <proxies>\n    <proxy>\n      <id>MyProxy</id>\n      <active>true</active>\n      <protocol>http</protocol>\n      <host>localhost</host>\n      <port>8888</port>\n    </proxy>\n  </proxies></settings>\n");
            Aether aether = Aether.getAether();
            RemoteRepository remoteRepository = new RemoteRepository.Builder("local", "default", "http://myserver.com").build();
            Proxy proxy = aether.getSession().getProxySelector().getProxy(remoteRepository);
            Assert.assertEquals((Object)"http", (Object)proxy.getType());
            Assert.assertEquals((Object)"localhost", (Object)proxy.getHost());
            Assert.assertEquals((long)8888L, (long)proxy.getPort());
        }
        finally {
            if (oldSettingsXmlPath != null) {
                System.setProperty("kie.maven.settings.custom", oldSettingsXmlPath);
            }
            MavenSettings.reinitSettings();
        }
    }
}

