/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.builder.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.builder.helper.KieModuleDeploymentHelperImpl;

public class KieModuleDeploymentHelperLoadResourcesTest {
    @Test
    public void testInternalLoadResources() throws Exception {
        List resources = null;
        String path = "/builder/simple_query_test.drl";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)false);
        Assert.assertEquals((String)path, (long)1L, (long)resources.size());
        String content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assert.assertTrue((content != null && content.length() > 10 ? 1 : 0) != 0);
        path = "/builder/test/";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)true);
        Assert.assertEquals((String)path, (long)2L, (long)resources.size());
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assert.assertTrue((content != null && content.length() > 10 ? 1 : 0) != 0);
        path = "/builder/";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)true);
        Assert.assertEquals((String)path, (long)1L, (long)resources.size());
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assert.assertTrue((content != null && content.length() > 10 ? 1 : 0) != 0);
        path = "META-INF/WorkDefinitions.conf";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)false);
        Assert.assertEquals((String)path, (long)1L, (long)resources.size());
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assert.assertTrue((content != null && content.length() > 10 ? 1 : 0) != 0);
        path = "META-INF/plexus/";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)true);
        Assert.assertEquals((String)path, (long)3L, (long)resources.size());
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assert.assertTrue((content != null && content.length() > 10 ? 1 : 0) != 0);
        content = "test file created by " + this.getClass().getSimpleName();
        String baseTempPath = System.getProperty("java.io.tmpdir");
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".tst");
        tempFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempFile);
        fos.write(content.getBytes());
        fos.close();
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)tempFile.getAbsolutePath(), (boolean)false);
        Assert.assertEquals((String)path, (long)1L, (long)resources.size());
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assert.assertTrue((content != null && content.length() > 10 ? 1 : 0) != 0);
        File tempDir = new File(baseTempPath + "/" + UUID.randomUUID().toString());
        tempDir.mkdir();
        tempDir.deleteOnExit();
        tempFile = new File(tempDir.getAbsolutePath() + "/" + UUID.randomUUID().toString() + ".tst");
        fos = new FileOutputStream(tempFile);
        fos.write(content.getBytes());
        fos.close();
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)tempDir.getAbsolutePath(), (boolean)true);
        Assert.assertEquals((String)path, (long)1L, (long)resources.size());
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assert.assertTrue((content != null && content.length() > 10 ? 1 : 0) != 0);
    }
}

