/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.DependencyFilter;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.rule.TypeMetaInfo;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.type.Role;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieMavenRepository;
import org.kie.scanner.KieModuleMetaData;

public class KieModuleMetaDataTest
extends AbstractKieCiTest {
    @Test
    public void testKieModuleMetaData() throws Exception {
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((ReleaseId)releaseId);
        this.checkDroolsCoreDep(kieModuleMetaData);
        Assert.assertTrue((boolean)("" + kieModuleMetaData.getPackages()).contains("junit"));
    }

    @Test
    public void testKieModuleMetaDataWithoutTestDependencies() throws Exception {
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((ReleaseId)releaseId, (DependencyFilter)new DependencyFilter.ExcludeScopeFilter(new String[]{"test"}));
        this.checkDroolsCoreDep(kieModuleMetaData);
        TestCase.assertFalse((boolean)("" + kieModuleMetaData.getPackages()).contains("junit"));
    }

    @Test
    public void testKieModuleMetaDataForNonExistingGAV() throws Exception {
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.drools", "drools-core", "5.7.0.Final");
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((ReleaseId)releaseId);
        Assert.assertEquals((long)0L, (long)kieModuleMetaData.getPackages().size());
    }

    @Test
    public void testKieModuleMetaDataInMemoryWithJavaClass() throws Exception {
        this.testKieModuleMetaDataInMemory(false);
    }

    @Test
    public void testKieModuleMetaDataInMemoryWithTypeDeclaration() throws Exception {
        this.testKieModuleMetaDataInMemory(true);
    }

    @Test
    public void testKieModuleMetaDataInMemoryUsingPOMWithTypeDeclaration() throws Exception {
        this.testKieModuleMetaDataInMemoryUsingPOM(true);
    }

    @Test
    public void testKieModuleMetaDataForDependenciesInMemory() throws Exception {
        this.testKieModuleMetaDataForDependenciesInMemory(false);
    }

    @Test
    public void testKieModuleMetaDataInMemoryWithJavaClassDefaultPackage() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "javaDefaultPackage", "1.0-SNAPSHOT");
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML()).writePomXML(KieBuilderImpl.generatePomXml((AFReleaseId)releaseId)).write("src/main/java/test/Bean.java", this.createJavaSource());
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertTrue((boolean)messages.isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        Class beanClass = kieModuleMetaData.getClass("", "test.Bean");
        Assertions.assertThat((Class)beanClass).isNotNull();
        TypeMetaInfo beanMetaInfo = kieModuleMetaData.getTypeMetaInfo(beanClass);
        Assertions.assertThat((Object)beanMetaInfo).isNotNull();
    }

    @Test
    public void testGetPackageNames() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/test.drl", "package org.test declare Bean end");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertTrue((boolean)messages.isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        TestCase.assertFalse((boolean)kieModuleMetaData.getPackages().isEmpty());
        Assert.assertTrue((boolean)kieModuleMetaData.getPackages().contains("org.test"));
    }

    @Test
    public void testIncludeAllDeps() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writePomXML(this.getPomWithTestDependency());
        KieModule kieModule = ks.newKieBuilder(kfs).getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        Assert.assertTrue((boolean)("" + kieModuleMetaData.getPackages()).contains("junit"));
    }

    @Test
    public void testExcludeTestDeps() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writePomXML(this.getPomWithTestDependency());
        KieModule kieModule = ks.newKieBuilder(kfs).getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule, (DependencyFilter)new DependencyFilter.ExcludeScopeFilter(new String[]{"test"}));
        TestCase.assertFalse((boolean)("" + kieModuleMetaData.getPackages()).contains("junit"));
    }

    private String getPomWithTestDependency() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>org.kie</groupId>\n  <artifactId>test</artifactId>\n  <version>1.0</version>\n\n    <dependencies>\n      <dependency>\n        <groupId>junit</groupId>\n        <artifactId>junit</artifactId>\n        <version>4.11</version>\n        <scope>test</scope>\n      </dependency>\n    </dependencies>\n</project>";
    }

    @Test
    public void testGetRuleNames() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/test1.drl", "package org.test\nrule A\n when\nthen\nend\nrule B\n when\nthen\nend\n");
        kfs.write("src/main/resources/test2.drl", "package org.test\nrule C\n when\nthen\nend\n");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertTrue((boolean)messages.isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        Collection rules = kieModuleMetaData.getRuleNamesInPackage("org.test");
        Assert.assertEquals((long)3L, (long)rules.size());
        Assert.assertTrue((boolean)rules.containsAll(Arrays.asList("A", "B", "C")));
    }

    private String createJavaSource() {
        return "package test;\npublic class Bean {\n   private int value;\n   public int getValue() {\n       return value;\n   }\n}";
    }

    private void testKieModuleMetaDataInMemory(boolean useTypeDeclaration) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "metadata-test", "1.0-SNAPSHOT");
        InternalKieModule kieModule = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 2, 7, dependency);
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        this.checkDroolsCoreDep(kieModuleMetaData);
        Collection testClasses = kieModuleMetaData.getClasses("org.kie.test");
        Assert.assertEquals((long)1L, (long)testClasses.size());
        Assert.assertEquals((Object)"Bean", testClasses.iterator().next());
        Class beanClass = kieModuleMetaData.getClass("org.kie.test", "Bean");
        Assertions.assertThat((Object)beanClass.getMethod("getValue", new Class[0])).isNotNull();
        TypeMetaInfo beanTypeInfo = kieModuleMetaData.getTypeMetaInfo(beanClass);
        Assertions.assertThat((Object)beanTypeInfo).isNotNull();
        Assert.assertTrue((boolean)beanTypeInfo.isEvent());
        Role role = beanClass.getAnnotation(Role.class);
        Assertions.assertThat((Object)role).isNotNull();
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)role.value());
        Assert.assertEquals((Object)useTypeDeclaration, (Object)beanTypeInfo.isDeclaredType());
    }

    private void testKieModuleMetaDataInMemoryUsingPOM(boolean useTypeDeclaration) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "metadata-test", "1.0-SNAPSHOT");
        InternalKieModule kieModule = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 2, 7, dependency);
        String pomText = this.getPom(dependency, new ReleaseId[0]);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((AFReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieMavenRepository.getKieMavenRepository().installArtifact((AFReleaseId)releaseId, kieModule, pomFile);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "metadata-test-using-pom", "1.0-SNAPSHOT");
        String pomText2 = this.getPom(releaseId2, releaseId);
        File pomFile2 = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((AFReleaseId)releaseId2, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile2);
            fos.write(pomText2.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((File)pomFile2);
        Collection testClasses = kieModuleMetaData.getClasses("org.kie.test");
        Assert.assertEquals((long)1L, (long)testClasses.size());
        Assert.assertEquals((Object)"Bean", testClasses.iterator().next());
        Class beanClass = kieModuleMetaData.getClass("org.kie.test", "Bean");
        Assertions.assertThat((Object)beanClass.getMethod("getValue", new Class[0])).isNotNull();
        if (useTypeDeclaration) {
            Assert.assertTrue((boolean)kieModuleMetaData.getTypeMetaInfo(beanClass).isEvent());
        }
    }

    private void checkDroolsCoreDep(KieModuleMetaData kieModuleMetaData) {
        Assert.assertEquals((long)17L, (long)kieModuleMetaData.getClasses("org.drools.runtime").size());
        Class statefulKnowledgeSessionClass = kieModuleMetaData.getClass("org.drools.runtime", "StatefulKnowledgeSession");
        Assert.assertTrue((boolean)statefulKnowledgeSessionClass.isInterface());
        Assert.assertEquals((long)2L, (long)statefulKnowledgeSessionClass.getDeclaredMethods().length);
    }

    private void testKieModuleMetaDataForDependenciesInMemory(boolean useTypeDeclaration) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "metadata-test", "1.0-SNAPSHOT");
        InternalKieModule kieModule = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 2, 7, dependency);
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        this.checkDroolsCoreDep(kieModuleMetaData);
        Collection testClasses = kieModuleMetaData.getClasses("org.drools");
        Assert.assertEquals((long)55L, (long)testClasses.size());
        Class beanClass = kieModuleMetaData.getClass("org.drools", "QueryResult");
        Assertions.assertThat((Class)beanClass).isNotNull();
        TypeMetaInfo beanTypeInfo = kieModuleMetaData.getTypeMetaInfo(beanClass);
        Assertions.assertThat((Object)beanTypeInfo).isNotNull();
        if (useTypeDeclaration) {
            Assert.assertTrue((boolean)beanTypeInfo.isEvent());
        }
        Assert.assertEquals((Object)useTypeDeclaration, (Object)beanTypeInfo.isDeclaredType());
    }

    @Test
    public void testKieMavenPluginEmptyProject() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("pom.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <modelVersion>4.0.0</modelVersion>  <groupId>org.kie</groupId>  <artifactId>plugin-test</artifactId>  <version>1.0</version>  <packaging>kjar</packaging>  <build>    <plugins>      <plugin>        <groupId>org.kie</groupId>        <artifactId>kie-maven-plugin</artifactId>        <version>the-test-does-not-need-proper-version-here</version>        <extensions>true</extensions>      </plugin>    </plugins>  </build></project>");
        kfs.write("/src/main/resources/META-INF/kmodule.xml", "<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertTrue((boolean)messages.isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        boolean fail = false;
        for (String packageName : kieModuleMetaData.getPackages()) {
            for (String className : kieModuleMetaData.getClasses(packageName)) {
                try {
                    kieModuleMetaData.getClass(packageName, className);
                }
                catch (Throwable e) {
                    fail = true;
                    System.out.println(e);
                }
            }
        }
        if (fail) {
            Assert.fail((String)"See console for details.");
        }
    }
}

