/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.management;

import java.util.ArrayList;
import javax.management.ObjectName;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieMavenRepository;
import org.kie.scanner.KieRepositoryScannerImpl;
import org.kie.scanner.management.KieScannerMBeanImpl;
import org.kie.scanner.management.MBeanUtils;

public class KieScannerMBeanTest
extends AbstractKieCiTest {
    private FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        MBeanUtils.setMBeanEnabled((boolean)true);
        System.setProperty("kie.scanner.mbeans", "enabled");
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
        System.setProperty("kie.scanner.mbeans", "");
        MBeanUtils.setMBeanEnabled((boolean)false);
    }

    @Test
    public void testKScannerMBean() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-mbean-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, "rule1", "rule2");
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        KieRepositoryScannerImpl scanner = (KieRepositoryScannerImpl)ks.newKieScanner(kieContainer);
        KieScannerMBeanImpl mBean = (KieScannerMBeanImpl)scanner.getMBean();
        ObjectName mbeanName = mBean.getMBeanName();
        Assertions.assertThat((Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"ScannerReleaseId")).isEqualTo((Object)releaseId.toExternalForm());
        Assertions.assertThat((Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"CurrentReleaseId")).isEqualTo((Object)releaseId.toExternalForm());
        Assertions.assertThat((Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"Status")).isEqualTo((Object)KieScanner.Status.STOPPED.toString());
        MBeanUtils.invoke((ObjectName)mbeanName, (String)"start", (Object[])new Object[]{10000L}, (String[])new String[]{"long"});
        Assertions.assertThat((Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"Status")).isEqualTo((Object)KieScanner.Status.RUNNING.toString());
        MBeanUtils.invoke((ObjectName)mbeanName, (String)"stop", (Object[])new Object[0], (String[])new String[0]);
        Assertions.assertThat((Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"Status")).isEqualTo((Object)KieScanner.Status.STOPPED.toString());
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId, "rule2", "rule3");
        repository.installArtifact((AFReleaseId)releaseId, kJar2, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        MBeanUtils.invoke((ObjectName)mbeanName, (String)"scanNow", (Object[])new Object[0], (String[])new String[0]);
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2", "rule3");
        MBeanUtils.invoke((ObjectName)mbeanName, (String)"shutdown", (Object[])new Object[0], (String[])new String[0]);
        Assertions.assertThat((Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"Status")).isEqualTo((Object)KieScanner.Status.SHUTDOWN.toString());
        ks.getRepository().removeKieModule(releaseId);
    }

    @Override
    protected void checkKSession(KieSession ksession, Object ... results) {
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(results.length);
        for (Object result : results) {
            Assertions.assertThat((boolean)list.contains(result)).isTrue();
        }
    }
}

