/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="ignored because it needs a running nexus server")
public class KieRepositoryScannerNexusTest
extends AbstractKieCiTest {
    private static final Logger LOG = LoggerFactory.getLogger(KieRepositoryScannerNexusTest.class);
    private FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        System.setProperty("kie.maven.settings.custom", new File("target/test-classes/org/kie/scanner/settings_nexus.xml").getAbsolutePath());
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    private void resetFileManager() {
        this.fileManager.tearDown();
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @Test
    public void testKScannerNewContainer() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("com.redhat.gss", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, this.getPomWithDistributionManagement(releaseId, new ReleaseId[0]), true, "rule1", "rule2");
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact(releaseId, kJar1, this.createKPomWithDistributionManagement(this.fileManager, releaseId, new ReleaseId[0]));
        ks.getRepository().removeKieModule(releaseId);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        KieModule firstModuleLoadedFromNexus = ks.getRepository().removeKieModule(releaseId);
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId, this.getPomWithDistributionManagement(releaseId, new ReleaseId[0]), true, "rule2", "rule3");
        repository.deployArtifact(releaseId, kJar2, this.createKPomWithDistributionManagement(this.fileManager, releaseId, new ReleaseId[0]));
        ks.getRepository().removeKieModule(releaseId);
        ks.getRepository().addKieModule(firstModuleLoadedFromNexus);
        KieContainer kieContainer2 = ks.newKieContainer(releaseId);
        KieSession ksession2 = kieContainer2.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2", "rule3");
        ks.getRepository().removeKieModule(releaseId);
    }

    protected String getPomWithDistributionManagement(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n<distributionManagement>\n  <snapshotRepository>\n    <id>local-nexus</id>\n    <name>Local Nexus Instance</name>\n    <url>http://localhost:8081/repository/maven-snapshots/</url>\n    <layout>default</layout>\n   </snapshotRepository>\n</distributionManagement>\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected File createKPomWithDistributionManagement(FileManager fileManager, ReleaseId releaseId, ReleaseId ... dependencies) throws IOException {
        File pomFile = fileManager.newFile("pom.xml");
        fileManager.write(pomFile, this.getPomWithDistributionManagement(releaseId, dependencies));
        return pomFile;
    }
}

