/*
 * Decompiled with CFR 0.152.
 */
package org.kie.declarativetypes;

import org.assertj.core.api.Assertions;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;

public class JavaBeansEventRoleTest
extends CommonTestMethodBase {
    @Test
    public void testFullyQualifiedDeclarativeTypeName() throws Exception {
        String declaration = "package org.drools.compiler;\npublic class Bean {}";
        String drl = "declare org.drools.compiler.Bean\n  @role(event)\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/java/org/drools/compiler/Bean.java", declaration).write("src/main/resources/bean1.drl", drl);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        KieModule kieModule = kieBuilder.buildAll().getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        String packageName = "org.drools.compiler";
        String className = "Bean";
        Class clazz = kieModuleMetaData.getClass("org.drools.compiler", "Bean");
        TypeMetaInfo typeMetaInfo = kieModuleMetaData.getTypeMetaInfo(clazz);
        Assertions.assertThat((boolean)typeMetaInfo.isEvent()).isTrue();
    }

    @Test
    public void testBeanAndDeclarativeTypeInSamePackage() throws Exception {
        String declaration = "package org.drools.compiler;\npublic class Bean {}";
        String drl = "package org.drools.compiler;\ndeclare Bean\n  @role(event)\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/java/org/drools/compiler/Bean.java", declaration).write("src/main/resources/bean1.drl", drl);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        KieModule kieModule = kieBuilder.buildAll().getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        String packageName = "org.drools.compiler";
        String className = "Bean";
        Class clazz = kieModuleMetaData.getClass("org.drools.compiler", "Bean");
        TypeMetaInfo typeMetaInfo = kieModuleMetaData.getTypeMetaInfo(clazz);
        Assertions.assertThat((boolean)typeMetaInfo.isEvent()).isTrue();
    }

    @Test
    public void testImportBean() throws Exception {
        String declaration = "package org.drools.compiler;\npublic class Bean {}";
        String drl = "package some.other.package;\nimport org.drools.compiler.Bean;\ndeclare Bean\n  @role(event)\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/java/org/drools/compiler/Bean.java", declaration).write("src/main/resources/bean1.drl", drl);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        KieModule kieModule = kieBuilder.buildAll().getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        String packageName = "org.drools.compiler";
        String className = "Bean";
        Class clazz = kieModuleMetaData.getClass("org.drools.compiler", "Bean");
        TypeMetaInfo typeMetaInfo = kieModuleMetaData.getTypeMetaInfo(clazz);
        Assertions.assertThat((boolean)typeMetaInfo.isEvent()).isTrue();
    }
}

