/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.builder.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.builder.helper.KieModuleDeploymentHelperImpl;

public class KieModuleDeploymentHelperLoadResourcesTest {
    @Test
    public void testInternalLoadResources() throws Exception {
        List resources = null;
        String path = "/builder/simple_query_test.drl";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)false);
        ((AbstractIntegerAssert)Assertions.assertThat((int)resources.size()).as(path, new Object[0])).isEqualTo(1);
        Object content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assertions.assertThat((content != null && ((String)content).length() > 10 ? 1 : 0) != 0).isTrue();
        path = "/builder/test/";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)resources.size()).as(path, new Object[0])).isEqualTo(2);
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assertions.assertThat((content != null && ((String)content).length() > 10 ? 1 : 0) != 0).isTrue();
        path = "/builder/";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)resources.size()).as(path, new Object[0])).isEqualTo(1);
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assertions.assertThat((content != null && ((String)content).length() > 10 ? 1 : 0) != 0).isTrue();
        path = "META-INF/WorkDefinitions.conf";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)false);
        ((AbstractIntegerAssert)Assertions.assertThat((int)resources.size()).as(path, new Object[0])).isEqualTo(1);
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assertions.assertThat((content != null && ((String)content).length() > 10 ? 1 : 0) != 0).isTrue();
        path = "META-INF/plexus/";
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)path, (boolean)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)resources.size()).as(path, new Object[0])).isEqualTo(1);
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assertions.assertThat((content != null && ((String)content).length() > 10 ? 1 : 0) != 0).isTrue();
        content = "test file created by " + this.getClass().getSimpleName();
        String baseTempPath = System.getProperty("java.io.tmpdir");
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".tst");
        tempFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempFile);
        fos.write(((String)content).getBytes());
        fos.close();
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)tempFile.getAbsolutePath(), (boolean)false);
        ((AbstractIntegerAssert)Assertions.assertThat((int)resources.size()).as(path, new Object[0])).isEqualTo(1);
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assertions.assertThat((content != null && ((String)content).length() > 10 ? 1 : 0) != 0).isTrue();
        File tempDir = new File(baseTempPath + "/" + UUID.randomUUID().toString());
        tempDir.mkdir();
        tempDir.deleteOnExit();
        tempFile = new File(tempDir.getAbsolutePath() + "/" + UUID.randomUUID().toString() + ".tst");
        fos = new FileOutputStream(tempFile);
        fos.write(((String)content).getBytes());
        fos.close();
        resources = KieModuleDeploymentHelperImpl.internalLoadResources((String)tempDir.getAbsolutePath(), (boolean)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)resources.size()).as(path, new Object[0])).isEqualTo(1);
        content = ((KieModuleDeploymentHelperImpl.KJarResource)resources.get((int)0)).content;
        Assertions.assertThat((content != null && ((String)content).length() > 10 ? 1 : 0) != 0).isTrue();
    }
}

