/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.drools.drl.parser.MessageImpl;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieModuleMetaData;

public class KieModuleIncrementalCompilationTest
extends AbstractKieCiTest {
    @Test
    public void testCheckMetaDataAfterIncrementalDelete() throws Exception {
        String drl1 = "package org.kie.scanner\nrule R1 when\n   String()\nthen\nend\n";
        String drl2 = "package org.kie.scanner\nrule R2_2 when\n   String( )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1).write("src/main/resources/r2.drl", drl2);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((int)this.getRuleNames(kieBuilder).get("org.kie.scanner").size()).isEqualTo(2);
        kfs.delete(new String[]{"src/main/resources/r2.drl"});
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)this.getRuleNames(kieBuilder).get("org.kie.scanner").size()).isEqualTo(1);
    }

    private HashMap<String, Collection<String>> getRuleNames(KieBuilder kieBuilder) {
        KieModuleMetaData kieModuleMetaData = this.getKieModuleMetaData(kieBuilder);
        HashMap<String, Collection<String>> ruleNames = new HashMap<String, Collection<String>>();
        for (String packageName : kieModuleMetaData.getPackages()) {
            ruleNames.put(packageName, kieModuleMetaData.getRuleNamesInPackage(packageName));
        }
        return ruleNames;
    }

    private KieModuleMetaData getKieModuleMetaData(KieBuilder kieBuilder) {
        return KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)((InternalKieBuilder)kieBuilder).getKieModuleIgnoringErrors());
    }

    @Test
    public void testIncrementalCompilationFirstBuildHasErrors() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "incremental-test-with-invalid pom", "");
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        String drl1 = "rule R1 when\n   $s : String()\nthen\nend\n";
        String drl2 = "rule R2 when\n   $s : Strin( )\nthen\nend\n";
        kfs.write("src/main/resources/KBase1/r1.drl", drl1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(1);
        kfs.write("src/main/resources/KBase1/r2.drl", drl2);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/KBase1/r2.drl"}).build();
        Assertions.assertThat((int)addResults.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)addResults.getRemovedMessages().size()).isEqualTo(0);
    }

    @Test
    public void checkIncrementalCompilationWithRuleFunctionRule() throws Exception {
        String rule_1 = "package org.kie.scanner\nrule R1 when\n   String()\nthen\nend\n";
        String rule_2 = "package org.kie.scanner\nrule R1 when\n   String()\nthen\n   System.out.println(MyFunction());\nend\n";
        String function = "package org.kie.scanner\nfunction int MyFunction() {\n   return 1;\n}\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/org/kie/scanner/rule.drl", rule_1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/org/kie/scanner/function.drl", function);
        IncrementalResults addResults1 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/org/kie/scanner/function.drl"}).build();
        Assertions.assertThat((int)addResults1.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)addResults1.getRemovedMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/org/kie/scanner/rule.drl", rule_2);
        IncrementalResults addResults2 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/org/kie/scanner/rule.drl"}).build();
        Assertions.assertThat((int)addResults2.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)addResults2.getRemovedMessages().size()).isEqualTo(0);
    }

    @Test
    public void checkIncrementalCompilationWithRuleThenFunction() throws Exception {
        String rule = "package org.kie.scanner\nrule R1 when\n   String()\nthen\n   System.out.println(MyFunction());\nend\n";
        String function = "package org.kie.scanner\nfunction int MyFunction() {\n   return 1;\n}\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/org/kie/scanner/rule.drl", rule);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(1);
        kfs.write("src/main/resources/org/kie/scanner/function.drl", function);
        IncrementalResults addResults1 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/org/kie/scanner/function.drl"}).build();
        Assertions.assertThat((int)addResults1.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)addResults1.getRemovedMessages().size()).isEqualTo(1);
    }

    @Test
    public void checkIncrementalCompilationWithFunctionThenRule() throws Exception {
        String rule = "package org.kie.scanner\nrule R1 when\n   String()\nthen\n   System.out.println(MyFunction());\nend\n";
        String function = "package org.kie.scanner\nfunction int MyFunction() {\n   return 1;\n}\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/org/kie/scanner/function.drl", function);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/org/kie/scanner/rule.drl", rule);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/org/kie/scanner/rule.drl"}).build();
        Assertions.assertThat((int)addResults.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)addResults.getRemovedMessages().size()).isEqualTo(0);
    }

    @Test
    public void checkIncrementalCompilationWithMultipleKieBases() throws Exception {
        String rule = "package org.kie.scanner\nrule R1 when\nthen\nend\n";
        String invalidRule = "package org.kie.scanner\nrule R2 when\n   Cheese()\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = this.createKieFileSystemWithTwoKBases(ks);
        kfs.write("src/main/resources/org/kie/scanner/rule.drl", rule);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((int)kieBuilder.getResults().getMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/org/kie/scanner/invalidRule.drl", invalidRule);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/org/kie/scanner/invalidRule.drl"}).build();
        Assertions.assertThat((int)addResults.getAddedMessages().size()).isEqualTo(2);
        addResults.getAddedMessages().stream().map(m -> (MessageImpl)m).forEach(m -> Assertions.assertThat((String)m.getKieBaseName()).isNotNull());
    }

    private KieFileSystem createKieFileSystemWithTwoKBases(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("default").setDefault(true).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kproj.newKieBaseModel("kbase1").setDefault(false).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }
}

